<?php
/**
 * Related Products
 *
 * Custom related products template for Avada theme.
 *
 * @see https://woo.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.9.0
 */

if (!defined('ABSPATH')) {
    exit;
}

// Hardcode related product IDs for now (you can replace this with dynamic logic)
$related_product_ids = [1019, 563, 1044, 507]; // As per your provided HTML

// Alternatively, fetch related products dynamically (uncomment to use):
/*
global $product;
$related_product_ids = wc_get_related_products($product->get_id(), 4);
*/

if ($related_product_ids) : ?>

    <section class="related products">
        <div class="fusion-title title sep-none">
            <h2 class="title-heading-left"><?php echo esc_html(apply_filters('woocommerce_product_related_products_heading', __('Related products', 'woocommerce'))); ?></h2>
            <span class="awb-title-spacer"></span>
            <div class="title-sep-container">
                <div class="title-sep sep-none"></div>
            </div>
        </div>

        <?php woocommerce_product_loop_start(); ?>

        <?php foreach ($related_product_ids as $related_id) : ?>
            <?php
            $related_product = wc_get_product($related_id);
            if (!$related_product) {
                continue; // Skip if the product doesn't exist
            }
            $post_object = get_post($related_id);
            setup_postdata($GLOBALS['post'] =& $post_object); // Set up post data for the related product
            ?>

            <li <?php wc_product_class('', $related_product); ?>>
                <div class="fusion-product-wrapper">
                    <a href="<?php echo esc_url(get_permalink($related_id)); ?>" class="product-images" aria-label="<?php echo esc_attr($related_product->get_name()); ?>">
                        <div class="featured-image">
                            <?php
                            if (has_post_thumbnail($related_id)) {
                                echo get_the_post_thumbnail($related_id, 'woocommerce_thumbnail');
                            } else {
                                echo wc_placeholder_img('woocommerce_thumbnail');
                            }
                            ?>
                            <div class="cart-loading"><i class="awb-icon-spinner" aria-hidden="true"></i></div>
                        </div>
                    </a>
                    <div class="fusion-product-content">
                        <div class="product-details">
                            <div class="product-details-container">
                                <h3 class="product-title">
                                    <a href="<?php echo esc_url(get_permalink($related_id)); ?>">
                                        <?php echo esc_html($related_product->get_name()); ?>
                                    </a>
                                </h3>
                                <div class="fusion-price-rating">
                                    <div class="tiered-pricing-shop-loop"></div>
                                    <span class="price">
                                        <span class="tiered-pricing-dynamic-price-wrapper" data-display-context="shop-loop" data-price-type="no-rules" data-product-id="<?php echo esc_attr($related_id); ?>" data-parent-id="<?php echo esc_attr($related_id); ?>">
                                            <span class="woocommerce-Price-amount amount">
                                                <?php echo wc_price($related_product->get_price()); ?>
                                            </span>
                                        </span>
                                    </span>
                                </div>
                            </div>
                        </div>
                        <div class="product-buttons">
                            <div class="fusion-content-sep sep-double sep-solid"></div>
                            <div class="product-buttons-container clearfix">
                                <?php if ($related_product->is_in_stock()) : ?>
                                    <a href="?add-to-cart=<?php echo esc_attr($related_id); ?>" data-quantity="1" class="button product_type_simple add_to_cart_button ajax_add_to_cart" data-product_id="<?php echo esc_attr($related_id); ?>" data-product_sku="<?php echo esc_attr($related_product->get_sku()); ?>" aria-label="Add to cart: '<?php echo esc_attr($related_product->get_name()); ?>'" rel="nofollow">Add to cart</a>
                                <?php else : ?>
                                    <a href="#" class="button wc-out-of-stock-button" style="color: red !important;">
                                        <i class="fa-solid fa-cart-shopping"></i> Out Of Stock
                                    </a>
                                <?php endif; ?>
                                <a href="<?php echo esc_url(get_permalink($related_id)); ?>" class="show_details_button" style="float:none;max-width:none;text-align:center;">
                                    Details
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </li>

        <?php endforeach; ?>

        <?php woocommerce_product_loop_end(); ?>

    </section>

    <?php
    wp_reset_postdata(); // Reset post data after the loop
endif;