<?php

use Automattic\WooCommerce\Blocks\Integrations\IntegrationInterface;
use Automattic\WooCommerce\Blocks\StoreApi\Schemas\CheckoutSchema;
use Automattic\WooCommerce\StoreApi\Schemas\ExtendSchema;
use Automattic\WooCommerce\StoreApi\StoreApi;
#use Automattic\WooCommerce\StoreApi\Schemas\V1\CheckoutSchema;

define('RECAPTCHA_BLOCK_VERSION', '1.0.1');
defined( 'ABSPATH' ) || exit;

/**
 * Class I13Recaptcha_Blocks_Integration
 *
 * Class for integrating marketing reCaptcha block with WooCommerce Checkout
 *
 */
class I13Recaptcha_Blocks_Integration implements IntegrationInterface {

	/**
	 * The name of the integration.
	 *
	 * @return string
	 */
	public function get_name() {
		return 'i13-recaptcha-checkout-block';
	}

	/**
	 * When called invokes any initialization/setup for the integration.
	 */
	public function initialize() {
			
				
		$this->register_frontend_scripts();
		$this->register_editor_scripts();
		$this->register_editor_blocks();
			 
		$this->extend_store_api();
				add_filter( '__experimental_woocommerce_blocks_add_data_attributes_to_block', [ $this, 'add_attributes_to_frontend_blocks' ], 10, 1 );
				add_action( 'wp_enqueue_scripts', array( $this, 'i13_woo_recaptcha_remove_ref' ), 99999 );
				add_filter( 'nonce_user_logged_out', array( $this, 'i13_modify_nonce_user_logged_out_defaults'), 10, 2 );
				add_action('woocommerce_store_api_checkout_update_order_from_request', function( $order, $request ) {
									
					if ( $request->get_method() === 'POST' ) {
						$extensions = $request->get_param( 'extensions' );
						if ( empty( $extensions ) ) {
							throw new \Exception( __('Extensions cannot be empty', 'recaptcha-for-woocommerce') );
						}
												
								//check unknown order source
								 $i13_recaptcha_block_unknown_orgin_orders = get_option( 'i13_recaptcha_block_unknown_orgin_orders' );
						if ('yes' == $i13_recaptcha_block_unknown_orgin_orders) {
													
										$i13_recapcha_error_msg_invalid_order_origin = get_option( 'i13_recapcha_error_msg_invalid_order_origin' );
										$source_types=array('utm','organic','referral','typein','mobile_app','admin');
										$_wc_order_attribution_source_type='';
							if (isset($extensions['woocommerce/order-attribution']) && isset($extensions['woocommerce/order-attribution']['source_type'])) {
					
						  $_wc_order_attribution_source_type=$extensions['woocommerce/order-attribution']['source_type'];
							}  
		   
							if ('' == $_wc_order_attribution_source_type) {
				
								if (''==$i13_recapcha_error_msg_invalid_order_origin) {
																	
												 throw new \Exception(__('Order with an unknown origin is not allowed.', 'recaptcha-for-woocommerce') );
																	
								} else {

																  throw new \Exception($i13_recapcha_error_msg_invalid_order_origin );
																  
								}

							} else if (!in_array(strtolower($_wc_order_attribution_source_type), $source_types)) { 

								if (''==$i13_recapcha_error_msg_invalid_order_origin) {
																 
								  throw new \Exception(__('Order with an unknown origin is not allowed.', 'recaptcha-for-woocommerce') );
								} else {

								throw new \Exception($i13_recapcha_error_msg_invalid_order_origin );
								}
							}

						}
												
												
						$value = $extensions[ $this->get_name() ];
						if ( empty( $value ) ) {
							throw new \Exception(__('Catpcha response cannot be empty', 'recaptcha-for-woocommerce') );
						}
						$response = $this->i13_checkout_check_captcha( $value );
						if ( is_wp_error($response) ) {
							throw new \Exception( $response->get_error_message() );
						}
												
						return $order;
					}
				}, 10, 2);
		   

	}
		
		
		
	  
	public function i13_woo_recaptcha_remove_ref() {
			
			
		wp_enqueue_style('frontend-recaptcha-block', plugins_url('/build/recaptcha-block-frontend.css', __FILE__), array(), RECAPTCHA_BLOCK_VERSION);
			
			
		if (is_singular()) {
			//We only want the script if it's a singular page
			$id = get_the_ID();
			if (has_block('woocommerce/checkout', $id)) {
					

					global $wp_scripts;
					$urls = array( 'google.com/recaptcha', 'gstatic.com/recaptcha', 'recaptcha.net/recaptcha' );

				foreach ( $wp_scripts->queue as $handle ) {

					foreach ( $urls as $url ) {
						if ( false !== strpos( $wp_scripts->registered[ $handle ]->src, $url ) && ( 'i13-woo-captcha' != $handle && 'i13-woo-captcha-v3' != $handle ) ) {
					  wp_dequeue_script( $handle );
					  wp_deregister_script( $handle );
					  break;
						}
					}
				}
			}
		}
	}
	   
	public function register_frontend_scripts() {
		$script_path       = '/build/recaptcha-block-frontend.js';
		$script_url        = plugins_url( $script_path, __FILE__ );
		$script_asset_path = dirname( __FILE__ ) . '/build/recaptcha-block-frontend.asset.php';
		$script_asset      = file_exists( $script_asset_path )
			? require $script_asset_path
			: array(
				'dependencies' => array(),
				'version'      => $this->get_file_version( $script_asset_path ),
			);

		wp_register_script(
			'i13-recaptcha-checkout-block-frontend',
			$script_url,
			$script_asset['dependencies'],
			$script_asset['version'],
			true
		);
			
				wp_set_script_translations(
			'i13-recaptcha-checkout-block-frontend', // script handle
			'recaptcha-for-woocommerce', // text domain
			dirname(dirname( __FILE__ )) . '/languages'
		);
				
				
							  
						
				   
	}

	public function register_editor_scripts() {
		$script_path       = '/build/recaptcha-block.js';
		$script_url        = plugins_url( $script_path, __FILE__ );
		$script_asset_path = dirname( __FILE__ ) . '/build/recaptcha-block.asset.php';
		$script_asset      = file_exists( $script_asset_path )
			? require $script_asset_path
			: array(
				'dependencies' => array(),
				'version'      => $this->get_file_version( $script_asset_path ),
			);

		wp_register_script(
			'i13-recaptcha-checkout-block-editor',
			$script_url,
			$script_asset['dependencies'],
			$script_asset['version'],
			true
		);

		wp_set_script_translations(
			'i13-recaptcha-checkout-block-editor', // script handle
			'i13-recaptcha-checkout-block', // text domain
			dirname( __FILE__ ) . '/languages'
		);
	}
	/**
	 * Returns an array of script handles to enqueue in the frontend context.
	 *
	 * @return string[]
	 */
	public function get_script_handles() {
		return array( 'i13-recaptcha-checkout-block-frontend' );
	}

	/**
	 * Returns an array of script handles to enqueue in the editor context.
	 *
	 * @return string[]
	 */
	public function get_editor_script_handles() {
		return array( 'i13-recaptcha-checkout-block-editor' );
	}

	/**
	 * An array of key, value pairs of data made available to the block on the client side.
	 *
	 * @return array
	 */
	public function get_script_data() {
			
				$i13_recapcha_checkout_action_v3 = get_option( 'i13_recapcha_checkout_action_v3' );
				$reCapcha_version = get_option('i13_recapcha_version'); 
				
		if (''==$reCapcha_version) {
			$reCapcha_version='v2';
		}
				
				
				$recaptcha_img=plugin_dir_url( __FILE__) . 'assets/js/recaptcha-block/img/recaptcha.png';
				$i13_recapcha_domain = get_option( 'i13_recapcha_domain' );
				$i13_recapcha_v2_lang = get_option( 'i13_recapcha_v2_lang' );
				$disable_submit_btn = get_option( 'i13_recapcha_disable_submitbtn_guestcheckout' );
				$disable_submit_btn_login_checkout = get_option( 'i13_recapcha_disable_submitbtn_logincheckout' );
				$i13_recapcha_hide_label_checkout = get_option( 'i13_recapcha_hide_label_checkout' );
				$captcha_lable = get_option( 'i13_recapcha_guestcheckout_title' );
				$captcha_lable_ = get_option( 'i13_recapcha_guestcheckout_title' );
				$refresh_lable = get_option( 'i13_recapcha_guestcheckout_refresh' );
		if ( '' == esc_html( $refresh_lable ) ) {

				$refresh_lable = __( 'Refresh Captcha', 'recaptcha-for-woocommerce' );
		}
				$site_key_v2 = get_option( 'wc_settings_tab_recapcha_site_key' );
				$site_key_v3 = get_option( 'wc_settings_tab_recapcha_site_key_v3' );
				$theme = get_option( 'i13_recapcha_guestcheckout_theme' );
				$size = get_option( 'i13_recapcha_guestcheckout_size' );
				$is_enabled = get_option( 'i13_recapcha_enable_on_guestcheckout' );
				$is_enabled_logincheckout = get_option( 'i13_recapcha_enable_on_logincheckout' );
				$i13_recapcha_guest_recpacha_refersh_on_error = get_option( 'i13_recapcha_guest_recpacha_refersh_on_error' );
				$i13_recapcha_login_recpacha_refersh_on_error = get_option( 'i13_recapcha_login_recpacha_refersh_on_error' );
				
				$recapcha_error_msg_captcha_blank = get_option( 'wc_settings_tab_recapcha_error_msg_captcha_blank' );
		if ( '' == trim( $captcha_lable_ ) ) {

				$captcha_lable_ = 'recaptcha';
		}
				$recapcha_error_msg_captcha_blank = str_replace( '[recaptcha]', ucfirst( $captcha_lable_ ), $recapcha_error_msg_captcha_blank );
				
				$is_user_login=is_user_logged_in();
				
				
				$i13_recapcha_checkout_action_v3 = get_option( 'i13_recapcha_checkout_action_v3' );
				$i13_recapcha_wp_disable_to_woo_checkout = get_option( 'i13_recapcha_wp_disable_submit_token_generation_v3_woo_checkout' );
				
		if ( '' == $i13_recapcha_checkout_action_v3 ) {

				$i13_recapcha_checkout_action_v3 = 'checkout';
		}

		if ( '' == $i13_recapcha_wp_disable_to_woo_checkout ) {

				$i13_recapcha_wp_disable_to_woo_checkout = 'no';
		}
				

		$data = array(
			'reCapchaVersion' => $reCapcha_version,
			'disable_submit_btn' => ( 'yes'==$disable_submit_btn )?1:0,
			'disable_submit_btn_login_checkout' => ( 'yes'==$disable_submit_btn_login_checkout )?1:0,
			'i13_recapcha_hide_label_checkout' => ( 'yes'==$i13_recapcha_hide_label_checkout )?1:0,
			'captcha_lable' => $captcha_lable,
			'refresh_lable' => $refresh_lable,
			'site_key_v2' => $site_key_v2,
			'site_key_v3' => $site_key_v3,
			'theme' => $theme,
			'size' => $size,
			'is_enabled_guest' => ( 'yes'==$is_enabled )?1:0,
			'is_enabled_logincheckout' => ( 'yes'==$is_enabled_logincheckout )?1:0,
			'i13_recapcha_guest_recpacha_refersh_on_error' => ( 'yes'==$i13_recapcha_guest_recpacha_refersh_on_error )?1:0,
			'i13_recapcha_login_recpacha_refersh_on_error' => ( 'yes'==$i13_recapcha_login_recpacha_refersh_on_error )?1:0,
			'recapcha_error_msg_captcha_blank' => $recapcha_error_msg_captcha_blank,
			'is_user_login' => ( 'yes'==$is_user_login )?1:0,
			'i13_recapcha_checkout_action_v3' => $i13_recapcha_checkout_action_v3,
			'i13_recapcha_wp_disable_to_woo_checkout' => ( 'yes'==$i13_recapcha_wp_disable_to_woo_checkout )?1:0,
			'i13_recapcha_v2_lang' => $i13_recapcha_v2_lang,
			'i13_recapcha_domain' => ( 'yes'==$i13_recapcha_domain )?1:0,
			'i13_checkout_nonce' => esc_html(wp_create_nonce('i13-woocommerce-process_checkout-block')),
						 'recaptcha_url'=>$recaptcha_img
		);

			  
			return $data;
	}

	/**
	 * Register blocks.
	 */
	public function register_editor_blocks() {
		register_block_type( dirname( __FILE__ ) . '/assets/js/recaptcha-block', array(
			'editor_script' => 'i13-recaptcha-checkout-block-editor',
		) );
	}

	/**
	 * This allows dynamic (JS) blocks to access attributes in the frontend.
	 *
	 * @param string[] $allowed_blocks
	 */
	public function add_attributes_to_frontend_blocks( $allowed_blocks ) {
		//$allowed_blocks[] = 'woocommerce/checkout-newsletter-subscription';
		$allowed_blocks[] = 'i13websolution/i13-recaptcha-checkout-block';
		return $allowed_blocks;
	}

	/**
	 * Add schema Store API to support posted data.
	 */
	public function extend_store_api() {
		$extend = StoreApi::container()->get(
			ExtendSchema::class
		);
				
		$extend->register_endpoint_data(
			array(
				'endpoint'        => CheckoutSchema::IDENTIFIER,
				'namespace'       => $this->get_name(),
				'schema_callback' => function() {
					
					return array(
						'optin' => array(
							'description' => __( 'Check recaptcha value.', 'recaptcha-for-woocommerce' ),
							'type'        => 'boolean',
							'context'     => array(),
							'arg_options' => array(
								'validate_callback' => function( $value ) {
																
																		
																		return $this->i13_checkout_check_captcha($value);
									
								},
							),
						),
					);
				},
			)
		);
								
								
	}

		
		
	public function i13_modify_nonce_user_logged_out_defaults($uid, $action) { 
			
		if ('i13-woocommerce-process_checkout-block'==esc_html($action)) {
				
			return 0;
		}
		return $uid; 
	}
		// add the filter

		
	public function i13_checkout_check_captcha($value) {

				
		$rawData=file_get_contents('php://input');
		$arrdata=json_decode($rawData, true);

				
							
									
				
		$reCapcha_version = get_option('i13_recapcha_version');
		if ('' == $reCapcha_version) {
				$reCapcha_version = 'v2';
		}
		if ('v2' == strtolower($reCapcha_version)) {
				
				
			$i13_recaptcha_v3_login_recpacha_for_req_btn = get_option( 'i13_recaptcha_v3_login_recpacha_for_req_btn' );
			$captcha_lable = get_option( 'i13_recapcha_guestcheckout_title' );
			if ( '' == trim( $captcha_lable ) ) {

					$captcha_lable = 'recaptcha';
			}
			if ( '' == $i13_recaptcha_v3_login_recpacha_for_req_btn ) {
					$i13_recaptcha_v3_login_recpacha_for_req_btn = 'no';
			}
			$recapcha_error_msg_captcha_blank = get_option( 'wc_settings_tab_recapcha_error_msg_captcha_blank' );
			$recapcha_error_msg_captcha_no_response = get_option( 'wc_settings_tab_recapcha_error_msg_captcha_no_response' );
			$recapcha_error_msg_captcha_invalid = get_option( 'wc_settings_tab_recapcha_error_msg_captcha_invalid' );
			$i13_recapcha_checkout_timeout = get_option( 'i13_recapcha_checkout_timeout' );
			if ( null == $i13_recapcha_checkout_timeout || '' == $i13_recapcha_checkout_timeout ) {

					$i13_recapcha_checkout_timeout = 3;
			}
			if (0 == $i13_recapcha_checkout_timeout) {
				$i13_recapcha_checkout_timeout=0.2;
			}
			$secret_key = get_option( 'wc_settings_tab_recapcha_secret_key' );
			$is_enabled = get_option( 'i13_recapcha_enable_on_guestcheckout' );
			$i13_recapcha_enable_on_logincheckout = get_option( 'i13_recapcha_enable_on_logincheckout' );

			$recapcha_error_msg_captcha_blank = str_replace( '[recaptcha]', '<strong>' . ucfirst( $captcha_lable ) . '</strong>', $recapcha_error_msg_captcha_blank );
			$recapcha_error_msg_captcha_no_response = str_replace( '[recaptcha]', '<strong>' . $captcha_lable . '</strong>', $recapcha_error_msg_captcha_no_response );
			$recapcha_error_msg_captcha_invalid = str_replace( '[recaptcha]', '<strong>' . $captcha_lable . '</strong>', $recapcha_error_msg_captcha_invalid );


			$nonce_value=( isset($arrdata['extensions'], $arrdata['extensions']['i13-recaptcha-checkout-block']) && isset($arrdata['extensions']['i13-recaptcha-checkout-block']['woo-checkout-nonce']) )?$arrdata['extensions']['i13-recaptcha-checkout-block']['woo-checkout-nonce']:'';
			/*if (! wp_verify_nonce( $nonce_value, 'i13-woocommerce-process_checkout-block' ) ) {


				  return new \WP_Error( 'api-error', __('Could not verify request.', 'recaptcha-for-woocommerce'));

			}*/
						
			if (''==$nonce_value) {
							
				$nonce_value=esc_html(wp_create_nonce('i13-woocommerce-process_checkout-block'));
			}

						//check already created order
					
			if (isset($arrdata['payment_data']) && is_array($arrdata['payment_data'])) {
							
				foreach ($arrdata['payment_data'] as $val_) {
								
					if (is_array($val_) && isset($val_['key']) && isset($val_['value'])) {
									
						/*if (false !==stripos($val_['key'], 'order_id') && ''!=trim($val_['value'])) {
								
													return true;
							break;
										
						} else */
													
						if (false !==stripos($val_['key'], 'is-woopay-preflight-check') && ''!=trim($val_['value'])) {
								
						return true;
							break;
										
						} else if (false !==stripos($val_['key'], 'is_woopay') && ''!=trim($val_['value'])) {
								
													return true;
							break;
										
						}
									
					}
				}
							
			}
						
			if (( ( $is_enabled && !is_user_logged_in() ) || ( $i13_recapcha_enable_on_logincheckout  && is_user_logged_in() ) ) &&  isset($arrdata['payment_method']) && !$this->i13_is_payment_request_btn($arrdata)) {



				if ('yes' == get_transient($nonce_value)) {

			return true;
				}

					   

				if ( isset($arrdata['extensions']) && isset($arrdata['extensions']['i13-recaptcha-checkout-block']) && isset($arrdata['extensions']['i13-recaptcha-checkout-block']['g-recaptcha-response-v2']) ) {
							
								// Google reCAPTCHA API secret key 
								$response = sanitize_text_field($arrdata['extensions']['i13-recaptcha-checkout-block']['g-recaptcha-response-v2']);

								  // Verify the reCAPTCHA response 
								 $verifyResponse = wp_remote_get('https://www.' . esc_html(sanitize_text_field($this->i13_get_recaptcha_domain())) . '/recaptcha/api/siteverify?secret=' . $secret_key . '&response=' . $response, array('timeout' => 30));
											   
					if (is_array($verifyResponse) && !is_wp_error($verifyResponse) && isset($verifyResponse['body'])) {

				 // Decode json data 
				 $responseData = json_decode($verifyResponse['body']);
												
				 // If reCAPTCHA response is valid 
						if (!$responseData->success) {


							if ('' == trim($recapcha_error_msg_captcha_invalid)) {

															
					 return new \WP_Error( 'api-error', __('Invalid recaptcha.', 'recaptcha-for-woocommerce'));
																	   
							} else {
															
															
					  return new \WP_Error( 'api-error', __($recapcha_error_msg_captcha_invalid, 'recaptcha-for-woocommerce'));

																

							}
						} else {



							if (0 != $i13_recapcha_checkout_timeout) {

										set_transient($nonce_value, 'yes', ( $i13_recapcha_checkout_timeout * 60 ));
							}
						}
					} else {

						if ('' == trim($recapcha_error_msg_captcha_no_response)) {

									   return new \WP_Error( 'api-error', __('Could not get response from reCAPTCHA server.', 'recaptcha-for-woocommerce'));
														
													   

						} else {

											  return new \WP_Error( 'api-error', $recapcha_error_msg_captcha_no_response);
														 
														


						}
					}
				} else {

									
										
												
					if ('' == trim($recapcha_error_msg_captcha_blank)) {

											
								return new \WP_Error( 'api-error', 'Recaptcha is a required field.');
											   


					} else {

											 return new \WP_Error( 'api-error', $recapcha_error_msg_captcha_blank);
											   
												   
												

					}
				}


			}
		} else {
				
				
						
					$i13_recapcha_checkout_score_threshold_v3 = get_option( 'i13_recapcha_checkout_score_threshold_v3' );
			if ( '' == $i13_recapcha_checkout_score_threshold_v3 ) {

				$i13_recapcha_checkout_score_threshold_v3 = '0.5';
			}
			$i13_recapcha_checkout_action_v3 = get_option( 'i13_recapcha_checkout_action_v3' );
			if ( '' == $i13_recapcha_checkout_action_v3 ) {

				$i13_recapcha_checkout_action_v3 = 'checkout';
			}

			$recapcha_error_msg_captcha_blank = get_option( 'i13_recapcha_error_msg_captcha_blank_v3' );
			$recapcha_error_msg_captcha_no_response = get_option( 'i13_recapcha_error_msg_captcha_no_response_v3' );
			$recapcha_error_msg_captcha_invalid = get_option( 'i13_recapcha_error_msg_v3_invalid_captcha' );
			$secret_key = get_option( 'wc_settings_tab_recapcha_secret_key_v3' );
			$is_enabled = get_option( 'i13_recapcha_enable_on_guestcheckout' );
			$i13_recapcha_enable_on_logincheckout = get_option( 'i13_recapcha_enable_on_logincheckout' );

			$i13_recapcha_checkout_timeout = get_option( 'i13_recapcha_checkout_timeout' );
			if ( null == $i13_recapcha_checkout_timeout || '' == $i13_recapcha_checkout_timeout ) {

				$i13_recapcha_checkout_timeout = 3;
			}
			if (0 == $i13_recapcha_checkout_timeout) {
				$i13_recapcha_checkout_timeout=0.2;
			}
				   
			$nonce_value=( isset($arrdata['extensions'], $arrdata['extensions']['i13-recaptcha-checkout-block']) && isset($arrdata['extensions']['i13-recaptcha-checkout-block']['woo-checkout-nonce']) )?$arrdata['extensions']['i13-recaptcha-checkout-block']['woo-checkout-nonce']:'';
						
			/*if (! wp_verify_nonce( $nonce_value, 'i13-woocommerce-process_checkout-block' ) ) {
							
									
			  return new \WP_Error( 'api-error', __('Could not verify request.', 'recaptcha-for-woocommerce'));
							
			}
						 * 
						 */
						
			if (''==$nonce_value) {
							
				$nonce_value=esc_html(wp_create_nonce('i13-woocommerce-process_checkout-block'));
			}
						
			if (isset($arrdata['payment_data']) && is_array($arrdata['payment_data'])) {
							
				foreach ($arrdata['payment_data'] as $val_) {
								
					if (is_array($val_) && isset($val_['key']) && isset($val_['value'])) {
									
						/*if (false !==stripos($val_['key'], 'order_id') && ''!=trim($val_['value'])) {
								
													return true;
							break;
										
						} else */
													
						if (false !==stripos($val_['key'], 'is-woopay-preflight-check') && ''!=trim($val_['value'])) {
								
						return true;
							break;
										
						} else if (false !==stripos($val_['key'], 'is_woopay') && ''!=trim($val_['value'])) {
								
													return true;
							break;
										
						}
									
					}
				}
							
			}
			if (( ( $is_enabled && !is_user_logged_in() ) || ( $i13_recapcha_enable_on_logincheckout  && is_user_logged_in() ) ) &&  isset($arrdata['payment_method']) && !$this->i13_is_payment_request_btn($arrdata)) {
						
							
				if ('yes' == get_transient($nonce_value)) {

											return true;
				}

									   
										
				if ( isset($arrdata['extensions']) && isset($arrdata['extensions']['i13-recaptcha-checkout-block']) && isset($arrdata['extensions']['i13-recaptcha-checkout-block']['i13_checkout_token_']) ) {
							
												// Google reCAPTCHA API secret key 
					$response = sanitize_text_field($arrdata['extensions']['i13-recaptcha-checkout-block']['i13_checkout_token_']);

					// Verify the reCAPTCHA response 
					$verifyResponse = wp_remote_post(
									'https://www.' . esc_html(sanitize_text_field($this->i13_get_recaptcha_domain())) . '/recaptcha/api/siteverify',
									array(
											'method' => 'POST',
											'timeout' => 60,
											'body' => array(
													'secret' => $secret_key,
													'response' => $response
											)
									)
						);

										
					if (is_array($verifyResponse) && !is_wp_error($verifyResponse) && isset($verifyResponse['body'])) {

						// Decode json data 
						$responseData = json_decode($verifyResponse['body']);
														
						// If reCAPTCHA response is valid 
						if (!$responseData->success) {


							if ('' == trim($recapcha_error_msg_captcha_invalid)) {

																	
																	return new \WP_Error( 'api-error', __('Google reCAPTCHA verification failed, please try again later.', 'recaptcha-for-woocommerce'));
																			
																			
									
							} else {
									
									return new \WP_Error( 'api-error', $recapcha_error_msg_captcha_invalid);
																			
																	
							}
						} else {



							if ($responseData->score < $i13_recapcha_checkout_score_threshold_v3 || $responseData->action != $i13_recapcha_checkout_action_v3) {

								if ('' == trim($recapcha_error_msg_captcha_invalid)) {

																		 return new \WP_Error( 'api-error', __('Google reCAPTCHA verification failed, please try again later.', 'recaptcha-for-woocommerce'));
										
								} else {

																			return new \WP_Error( 'api-error', $recapcha_error_msg_captcha_invalid);  
																			
								}
							} else {

								if (0 != $i13_recapcha_checkout_timeout) {

									set_transient($nonce_value, 'yes', ( $i13_recapcha_checkout_timeout * 60 ));
								}
							}
						}
					} else {

						if ('' == trim($recapcha_error_msg_captcha_no_response)) {

														 return new \WP_Error( 'api-error', __('Could not get response from reCAPTCHA server.', 'recaptcha-for-woocommerce'));  
																
								
						} else {

															
														 return new \WP_Error( 'api-error', $recapcha_error_msg_captcha_no_response);  
																 
																  
								
						}
					}
				} else {

					if ('' == trim($recapcha_error_msg_captcha_blank)) {
													
													
												 return new \WP_Error( 'api-error', __('Google reCAPTCHA token is missing.', 'recaptcha-for-woocommerce'));  
													  

											
					} else {

													 return new \WP_Error( 'api-error', $recapcha_error_msg_captcha_blank);  
													  
																		
					}
				}
								
				
			}
				
		}

				
		return true;
			  
	}
	/**
	 * Get the file modified time as a cache buster if we're in dev mode.
	 *
	 * @param string $file Local path to the file.
	 * @return string The cache buster value to use for the given file.
	 */
	protected function get_file_version( $file ) {
		if ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG && file_exists( $file ) ) {
			return filemtime( $file );
		}
		return RECAPTCHA_BLOCK_VERSION;
	}
		

	public function i13_get_recaptcha_domain() {

			$domain = 'google.com';
			$reCapcha_domain = get_option('i13_recapcha_domain');

		if ('yes' == $reCapcha_domain) {

				$domain = 'recaptcha.net';
		}

			return $domain;
	}
	
	public function i13_is_payment_request_btn($arrdata) {
		 
		   $is_pay_req_btn=false;
		if (isset($arrdata['payment_method'])) {
				
			if (stripos($arrdata['payment_method'], 'googlepay')!==false) {
					
				   $is_pay_req_btn=true;
			} else if (stripos($arrdata['payment_method'], 'applepay')!==false) {
					
				 $is_pay_req_btn=true;
			} else if (stripos($arrdata['payment_method'], 'wcpay')!==false) {
					
				$is_pay_req_btn=true;
			} else if (stripos($arrdata['payment_method'], 'paymentplugins_ppcp_express')!==false) {
					
				$is_pay_req_btn=true;
			}
		}
			
		   return $is_pay_req_btn;
			
	}
}
