<?php
namespace Yay_Currency\Helpers;

use Yay_Currency\Utils\SingletonTrait;
class RateHelper {

	use SingletonTrait;

	protected function __construct() {}

	public static function get_exchange_rates( $currency_params_template ) {
		$url_template = 'https://query1.finance.yahoo.com/v8/finance/chart/$src$dest=X?interval=1m';
		$url          = strtr( $url_template, $currency_params_template );
		$json_data    = wp_remote_get( $url );
		return $json_data;
	}

	public static function get_rate_fee_from_currency_not_exists_in_list( $currency_code ) {
		$exchange_data = self::get_exchange_rates(
			array(
				'$src'  => Helper::default_currency_code(),
				'$dest' => $currency_code,
			)
		);

		// Return 1 on error or invalid response
		if ( is_wp_error( $exchange_data ) || ! isset( $exchange_data['response']['code'] ) || 200 !== $exchange_data['response']['code'] ) {
			return 1;
		}

		$data   = json_decode( wp_remote_retrieve_body( $exchange_data ) );
		$result = isset( $data->chart->result[0] ) ? $data->chart->result[0] : null;

		// Return 1 if no result is found
		if ( ! $result ) {
			return 1;
		}

		// Return close value or previous close, defaulting to 1
		return isset( $result->indicators->quote[0]->close[0] )
			? $result->indicators->quote[0]->close[0]
			: ( isset( $result->meta->previousClose ) ? $result->meta->previousClose : 1 );
	}


	public static function update_exchange_rate_currency( $yay_currencies = array(), $woocommerce_currency = '', $is_auto_update = false ) {
		if ( ! empty( $woocommerce_currency ) && $yay_currencies ) {
			foreach ( $yay_currencies as $currency ) {
				if ( $currency->post_title !== $woocommerce_currency ) {
					if ( ! isset( $currency->ID ) ) {
						continue;
					}
					$rate_type = get_post_meta( $currency->ID, 'rate_type', true );
					if ( 'auto' === $rate_type || empty( $rate_type ) ) {
						$json_data = self::get_exchange_rates(
							array(
								'$src'  => $woocommerce_currency,
								'$dest' => $currency->post_title,
							)
						);

						if ( is_wp_error( $json_data ) || ! isset( $json_data['response']['code'] ) ) {
							continue;
						}

						if ( 200 !== $json_data['response']['code'] ) {
							if ( ! $is_auto_update ) {
								update_post_meta( $currency->ID, 'rate', 'N/A' );
							}
							continue;
						}

						$decoded_json_data = json_decode( $json_data['body'] );
						$exchange_rate     = 1;

						if ( isset( $decoded_json_data->chart->result[0]->meta->regularMarketPrice ) ) {
							$exchange_rate = $decoded_json_data->chart->result[0]->meta->regularMarketPrice;
						} elseif ( isset( $decoded_json_data->chart->result[0]->indicators->quote[0]->close ) ) {
							$exchange_rate = $decoded_json_data->chart->result[0]->indicators->quote[0]->close[0];
						} else {
							$exchange_rate = $decoded_json_data->chart->result[0]->meta->previousClose;
						}

						update_post_meta( $currency->ID, 'rate', $exchange_rate );

					}
				} else {
					update_post_meta( $currency->ID, 'rate', 1 );
				}
			}
		}
	}
}
