<?php
namespace Yay_Currency\Engine\Compatibles;

use Yay_Currency\Utils\SingletonTrait;
use Yay_Currency\Helpers\CountryHelper;
use Yay_Currency\Helpers\YayCurrencyHelper;
use LearnPress\Models\CourseModel;

defined( 'ABSPATH' ) || exit;

// link plugin :

class LearnPress {
	use SingletonTrait;

	private $apply_currency = array();

	public function __construct() {

		if ( ! class_exists( '\LP_Admin_Assets' ) ) {
			return;
		}

		$this->apply_currency = YayCurrencyHelper::detect_current_currency();
		add_filter( 'learn-press/course/price', array( $this, 'custom_course_price' ), 10, 2 );
		add_filter( 'learn-press/course/regular-price', array( $this, 'custom_course_regular_price' ), 10, 2 );
		add_filter( 'learn_press_currency_symbol', array( $this, 'learn_press_currency_symbol' ), 10, 2 );

		// Archive
		add_filter( 'learnPress/course/price', array( $this, 'archive_course_price' ), 10, 2 );
		add_filter( 'learnPress/course/regular-price', array( $this, 'archive_course_regular_price' ), 10, 2 );

		add_filter( 'learn-press/course/regular-price-html', array( $this, 'archive_course_regular_price_html' ), 10, 2 );
		add_filter( 'learn_press_course_price_html', array( $this, 'archive_course_price_html' ), 10, 3 );

		// LearnPress - WooCommerce Payment Methods Integration
		if ( defined( 'LP_ADDON_WOO_PAYMENT_VER' ) ) {
			add_filter( 'learn-press/woo-course/price', array( $this, 'get_woo_course_price_custom' ), 10, 2 );
			add_filter( 'learn-press/woo-course/regular-price', array( $this, 'get_woo_course_price_custom' ), 10, 2 );
			add_filter( 'learn-press/woo-course/sale-price', array( $this, 'get_woo_course_price_custom' ), 10, 2 );
		}

	}

	protected function archive_course_rest_route() {

		if ( isset( $GLOBALS['wp']->query_vars ) && isset( $GLOBALS['wp']->query_vars['course-item'] ) ) {
			return true;
		}

		$rest_route = CountryHelper::get_rest_route_via_rest_api();

		if ( $rest_route && str_contains( $rest_route, '/lp/v1/' ) ) {
			return true;
		}

		return false;
	}

	public function custom_course_price( $price, $course_id ) {
		if ( apply_filters( 'yay_currency_learn_press_default_course_price', false ) ) {
			return $price;
		}
		$course = CourseModel::find( $course_id, true );
		$price  = $course->get_price();
		$price  = apply_filters( 'yay_currency_convert_price', $price, $this->apply_currency );
		return $price;
	}

	public function custom_course_regular_price( $regular_price, $course_id ) {
		if ( empty( $regular_price ) || ! is_numeric( $regular_price ) ) {
			return $regular_price;
		}

		if ( apply_filters( 'yay_currency_learn_press_default_course_price', false ) ) {
			return $regular_price;
		}

		$course        = CourseModel::find( $course_id, true );
		$regular_price = $course->get_regular_price();
		$regular_price = apply_filters( 'yay_currency_convert_price', $regular_price, $this->apply_currency );

		return $regular_price;

	}

	public function learn_press_currency_symbol( $currency_symbol, $currency ) {
		if ( isset( $this->apply_currency['symbol'] ) && ! is_admin() ) {
			$currency_symbol = $this->apply_currency['symbol'];
		}
		return $currency_symbol;
	}

	public function archive_course_price( $price, $course_id ) {
		if ( empty( $price ) || ! is_numeric( $price ) ) {
			return $price;
		}
		$rest_route = isset( $GLOBALS['wp']->query_vars ) && isset( $GLOBALS['wp']->query_vars['rest_route'] ) ? $GLOBALS['wp']->query_vars['rest_route'] : false;
		if ( ! $rest_route || ! str_contains( $rest_route, 'v1/load_content_via_ajax' ) ) {
			return $price;
		}
		$price = apply_filters( 'yay_currency_convert_price', $price, $this->apply_currency );
		return $price;

	}

	public function archive_course_regular_price( $regular_price, $course_id ) {
		if ( empty( $regular_price ) || ! is_numeric( $regular_price ) ) {
			return $regular_price;
		}
		$rest_route = isset( $GLOBALS['wp']->query_vars ) && isset( $GLOBALS['wp']->query_vars['rest_route'] ) ? $GLOBALS['wp']->query_vars['rest_route'] : false;
		if ( ! $rest_route || ! str_contains( $rest_route, 'v1/load_content_via_ajax' ) ) {
			return $regular_price;
		}
		$regular_price = apply_filters( 'yay_currency_convert_price', $regular_price, $this->apply_currency );
		return $regular_price;
	}

	public function archive_course_regular_price_html( $price, $course ) {
		if ( isset( $GLOBALS['wp']->query_vars ) && isset( $GLOBALS['wp']->query_vars['lp_course'] ) ) {
			return $price;
		}
		if ( self::archive_course_rest_route() ) {
			$regular_price = $course->get_regular_price();
			$regular_price = YayCurrencyHelper::calculate_price_by_currency( $regular_price, false, $this->apply_currency );
			$price         = YayCurrencyHelper::format_price( $regular_price );
		}
		return $price;
	}

	public function archive_course_price_html( $price, $has_sale_price, $course_id ) {
		if ( isset( $GLOBALS['wp']->query_vars ) && isset( $GLOBALS['wp']->query_vars['lp_course'] ) ) {
			return $price;
		}
		if ( self::archive_course_rest_route() ) {
			$course = CourseModel::find( $course_id, true );
			if ( $course ) {
				$price_html = '';
				if ( $has_sale_price ) {
					$price_html .= sprintf( '<span class="origin-price">%s</span>', self::archive_course_regular_price_html( $price, $course ) );
				}
				$regular_price = $course->get_price();
				$price         = $price_html . YayCurrencyHelper::format_price( $regular_price );
			}
		}
		return $price;
	}

	public function get_woo_course_price_custom( $price, $course ) {
		if ( apply_filters( 'yay_currency_learn_press_default_course_price', false ) || YayCurrencyHelper::disable_fallback_option_in_checkout_page( $this->apply_currency ) ) {
			return $price;
		}
		$price = apply_filters( 'yay_currency_convert_price', $price, $this->apply_currency );
		return $price;
	}
}
