jQuery(document).ready(function ($) {
    console.log('[Precious Metals Refresh] JavaScript loaded on', window.location.pathname);

    if (preciousMetalsRefresh.debug_logs && preciousMetalsRefresh.debug_logs.length > 0) {
        preciousMetalsRefresh.debug_logs.forEach(function (log) {
            console.log(log);
        });
    }

    let isUpdating = false;

    function getCurrentCurrency() {
        let currency = preciousMetalsRefresh.currency;
        if (typeof YayCurrency !== 'undefined' && YayCurrency.currentCurrency) {
            currency = YayCurrency.currentCurrency.code;
        } else if ($('.woocommerce-currency-switcher').length) {
            currency = $('.woocommerce-currency-switcher').val();
        }
        return currency || 'AUD';
    }

    function getCurrencySymbol(currencyCode) {
        const symbols = {
            'AUD': '$',
            'USD': '$',
            'EUR': '€',
            'GBP': '£',
            'CAD': '$'
        };
        return symbols[currencyCode] || '$';
    }

    // For checkout pages, force a full update of the order review.
    function updateCheckoutOrderReview() {
        if (typeof wc_checkout_params !== 'undefined' && $('#order_review').length) {
            $.ajax({
                url: wc_checkout_params.ajax_url,
                type: 'POST',
                data: { action: 'update_order_review' },
                success: function (html) {
                    $('#order_review').html(html);
                    $(document.body).trigger('updated_checkout');
                    console.log('[Precious Metals Refresh] Checkout order review updated.');
                }
            });
        }
    }

    function updatePrices(source = 'manual') {
        if (isUpdating) {
            console.log('[Precious Metals Refresh] Update in progress, skipping. Source:', source);
            return;
        }
        isUpdating = true;
        console.log('[Precious Metals Refresh] Starting price refresh at', new Date().toLocaleTimeString(), 'Source:', source);

        let productIds = new Set();
        let tieredRules = {};
        let singleProductId = null;

        if (preciousMetalsRefresh.is_admin) {
            productIds.add(preciousMetalsRefresh.product_id.toString());
            console.log('[Precious Metals Refresh] Admin product ID:', preciousMetalsRefresh.product_id);
        } else {
            singleProductId = $('input[name="product_id"]').val() ||
                              $('.single_add_to_cart_button').val() ||
                              $('body').attr('class').match(/postid-(\d+)/)?.[1] ||
                              $('.product-details').data('product-id');
            if (singleProductId) {
                productIds.add(singleProductId.toString());
                console.log('[Precious Metals Refresh] Single product ID detected:', singleProductId);
            } else {
                console.warn('[Precious Metals Refresh] No single product ID found on single product page');
            }

            $('.products .product, .fusion-product-wrapper, .fusion-featured-products .product, .products-featured .product').each(function () {
                const pid = $(this).data('product-id') ||
                           $(this).find('.add_to_cart_button').data('product_id') ||
                           $(this).find('.woocommerce-Price-amount, .price .amount').data('product-id') ||
                           $(this).attr('id')?.match(/product-(\d+)/)?.[1];
                if (pid) productIds.add(pid.toString());
            });

            $('.woocommerce-cart-form__cart-item').each(function () {
                const pid = $(this).find('.remove').data('product_id') ||
                           $(this).find('.woocommerce-Price-amount').data('product-id');
                if (pid) productIds.add(pid.toString());
            });

            $('.precious-metals-buyback-price').each(function () {
                const pid = $(this).data('product-id');
                if (pid) productIds.add(pid.toString());
            });

            // Collect tiered pricing rules from plain text and dropdowns.
            $('.tiered-pricing-wrapper ul.tiered-pricing-plain-texts[data-product-id]').each(function () {
                const productId = $(this).data('product-id');
                let rules = $(this).data('price-rules');
                if (rules && typeof rules === "string") {
                    try {
                        rules = JSON.parse(rules.trim());
                    } catch(e) {
                        console.error("Error parsing plain text tiered pricing rules for product " + productId, e);
                    }
                }
                if (productId && rules) {
                    tieredRules[productId] = rules;
                    console.log(`[Precious Metals Refresh] Collected tiered pricing rules (plain text) for Product ID ${productId}:`, rules);
                } else {
                    console.warn(`[Precious Metals Refresh] No valid tiered pricing rules (plain text) found for Product ID ${productId}`);
                }
            });

            $('.tiered-pricing-wrapper div.tiered-pricing-dropdown[data-product-id]').each(function () {
                const productId = $(this).data('product-id');
                let rules = $(this).data('price-rules');
                if (rules && typeof rules === "string") {
                    try {
                        rules = JSON.parse(rules.trim());
                    } catch(e) {
                        console.error("Error parsing dropdown tiered pricing rules for product " + productId, e);
                    }
                }
                if (productId && rules) {
                    tieredRules[productId] = rules;
                    console.log(`[Precious Metals Refresh] Collected tiered pricing rules (dropdown) for Product ID ${productId}:`, rules);
                } else {
                    console.warn(`[Precious Metals Refresh] No valid tiered pricing rules (dropdown) found for Product ID ${productId}`);
                }
            });
        }

        // If no product IDs are found and we're on the checkout page, simply trigger checkout update.
        if (productIds.size === 0) {
            if ($('body').hasClass('woocommerce-checkout')) {
                console.log('[Precious Metals Refresh] No product IDs found on checkout page, triggering update_checkout.');
                $(document.body).trigger('update_checkout');
                setTimeout(updateCheckoutOrderReview, 1000);
            } else {
                console.warn('[Precious Metals Refresh] No product IDs found on page');
            }
            isUpdating = false;
            return;
        }

        const currentCurrency = getCurrentCurrency();
        const currencySymbol = getCurrencySymbol(currentCurrency);

        console.log('[Precious Metals Refresh] Fetching prices for Product IDs:', [...productIds], 'Tiered Rules:', tieredRules);

        $.ajax({
            url: preciousMetalsRefresh.ajax_url,
            type: 'POST',
            data: {
                action: 'get_current_prices',
                nonce: preciousMetalsRefresh.nonce,
                product_ids: [...productIds],
                tiered_rules: tieredRules, // Pass tiered rules to PHP
                currency: currentCurrency
            },
            success: function (response) {
                if (!response.success || !response.data) {
                    console.error('[Precious Metals Refresh] Failed to fetch prices:', response);
                    isUpdating = false;
                    return;
                }

                console.log('[Precious Metals Refresh] AJAX response:', response.data);

                $.each(response.data, function (productId, data) {
                    const displaySymbol = getCurrencySymbol(data.currency);

                    if (preciousMetalsRefresh.is_admin) {
                        $('#_regular_price').val(data.regular_price);
                        $('#current-regular-price').text(`${displaySymbol}${data.regular_price}`);
                        $('#current-buyback-price').text(`${displaySymbol}${data.buyback_price}`);
                    } else {
                        // Single product page update
                        if ($('body').hasClass('single-product') && singleProductId && singleProductId.toString() === productId.toString()) {
                            const $priceEl = $('.product-details .price .woocommerce-Price-amount.amount, .summary.entry-summary .price .amount');
                            if ($priceEl.length && parseFloat(data.regular_price) > 0) {
                                $priceEl.html(`<bdi><span class="woocommerce-Price-currencySymbol">${displaySymbol}</span>${data.regular_price}</bdi>`)
                                        .addClass('price-loaded');
                                console.log(`[Precious Metals Refresh] Updated single product ${productId} base price to ${data.regular_price}`);
                            }
                            if (data.tiered_prices) {
                                console.log(`[Precious Metals Refresh] Tiered prices for product ${productId}:`, data.tiered_prices);
                                const $tieredWrapper = $('.tiered-pricing-plain-texts[data-product-id="' + productId + '"]');
                                if ($tieredWrapper.length) {
                                    $tieredWrapper.find('.tiered-pricing-plain-text').each(function () {
                                        const $item = $(this);
                                        const quantity = $item.data('tiered-quantity');
                                        if (quantity && data.tiered_prices[quantity] !== undefined) {
                                            const $priceEl = $item.find('.woocommerce-Price-amount');
                                            if ($priceEl.length) {
                                                $priceEl.html(`<bdi><span class="woocommerce-Price-currencySymbol">${displaySymbol}</span>${data.tiered_prices[quantity]}</bdi>`)
                                                        .addClass('price-loaded');
                                                $item.data('tiered-price', data.tiered_prices[quantity]);
                                                console.log(`[Precious Metals Refresh] Updated single product tier ${quantity} for ${productId} to ${data.tiered_prices[quantity]}`);
                                            } else {
                                                console.warn(`[Precious Metals Refresh] No price element found for tier ${quantity} in product ${productId}`);
                                            }
                                        } else {
                                            console.warn(`[Precious Metals Refresh] No tiered price data for quantity ${quantity} in product ${productId}`);
                                        }
                                    });
                                } else {
                                    console.warn(`[Precious Metals Refresh] No tiered pricing wrapper found for product ${productId}`);
                                }
                            }
                            if (data.buyback_price && data.buyback_price !== '0.00') {
                                if (!$('.precious-metals-buyback-price.single-product-buyback').length) {
                                    $('<div class="precious-metals-buyback-price single-product-buyback"><span class="buyback-price-label">Buyback Price:</span> <span class="buyback-price-value"></span></div>')
                                      .insertBefore('.product-border.fusion-separator.sep-none');
                                }
                                $('.precious-metals-buyback-price.single-product-buyback .buyback-price-value')
                                    .html(`${displaySymbol}${data.buyback_price}`)
                                    .addClass('price-loaded');
                                console.log(`[Precious Metals Refresh] Inserted/Updated buyback price for single product ${productId} to ${data.buyback_price}`);
                            }
                        }
                        // Shop/category/homepage update
                        if ($('body').hasClass('woocommerce-shop') || $('body').hasClass('tax-product_cat') || $('body').hasClass('home') || $('body').hasClass('front-page')) {
                            $('.products .product, .fusion-product-wrapper, .fusion-featured-products .product, .products-featured .product').each(function () {
                                const $basePriceEl = $(this).find('.woocommerce-Price-amount, .price .amount, .fusion-price .amount').not('.tiered-pricing-dropdown-option .woocommerce-Price-amount');
                                const pid = $(this).data('product-id') ||
                                           $(this).find('.add_to_cart_button').data('product_id') ||
                                           $basePriceEl.data('product-id') ||
                                           $(this).attr('id')?.match(/product-(\d+)/)?.[1];
                                if (pid == productId && parseFloat(data.regular_price) > 0) {
                                    $basePriceEl.html(`<bdi>${data.regular_price}</bdi>`)
                                                .addClass('price-loaded');
                                    console.log(`[Precious Metals Refresh] Updated base price for ${productId} to ${data.regular_price}`);
                                }
                            });
                            if (data.tiered_prices) {
                                $('.tiered-pricing-dropdown[data-product-id="' + productId + '"]').each(function () {
                                    const $dropdown = $(this);
                                    $dropdown.find('.tiered-pricing-dropdown-option').each(function () {
                                        const $option = $(this);
                                        const quantity = $option.data('tiered-quantity');
                                        if (quantity && data.tiered_prices[quantity] !== undefined) {
                                            const $tierPriceEl = $option.find('.tiered-pricing-dropdown-option-price__discounted .woocommerce-Price-amount');
                                            const $originalPriceEl = $option.find('.tiered-pricing-dropdown-option-price__original .woocommerce-Price-amount');
                                            if ($tierPriceEl.length) {
                                                $tierPriceEl.html(`<bdi>${data.tiered_prices[quantity]}</bdi>`)
                                                            .addClass('price-loaded');
                                                $option.data('tiered-price', data.tiered_prices[quantity]);
                                                console.log(`[Precious Metals Refresh] Updated dropdown tier ${quantity} for ${productId} to ${data.tiered_prices[quantity]}`);
                                            }
                                            if ($originalPriceEl.length) {
                                                $originalPriceEl.html(`<bdi>${data.regular_price}</bdi>`)
                                                                .addClass('price-loaded');
                                                console.log(`[Precious Metals Refresh] Updated original price for tier ${quantity} in ${productId} to ${data.regular_price}`);
                                            }
                                            if ($option.hasClass('tiered-pricing-dropdown-option--active')) {
                                                const $selectPriceEl = $dropdown.find('.tiered-pricing-dropdown__select-box .tiered-pricing-dropdown-option-price__discounted .woocommerce-Price-amount');
                                                if ($selectPriceEl.length) {
                                                    $selectPriceEl.html(`<bdi><span class="woocommerce-Price-currencySymbol">${displaySymbol}</span>${data.tiered_prices[quantity]}</bdi>`)
                                                                  .addClass('price-loaded');
                                                    console.log(`[Precious Metals Refresh] Updated selected tier ${quantity} for ${productId} to ${data.tiered_prices[quantity]}`);
                                                }
                                            }
                                        } else {
                                            console.warn(`[Precious Metals Refresh] No tiered price data for quantity ${quantity} in product ${productId}`);
                                        }
                                    });
                                });
                            }
                        }
                        // Cart page update
                        if ($('body').hasClass('woocommerce-cart')) {
                            $('.woocommerce-cart-form__cart-item').each(function () {
                                const $priceEl = $(this).find('.product-price .woocommerce-Price-amount');
                                const pid = $(this).find('.remove').data('product_id') || $priceEl.data('product-id');
                                if (pid == productId && parseFloat(data.regular_price) > 0) {
                                    $priceEl.html(`<bdi>${data.regular_price}</bdi>`)
                                            .addClass('price-loaded');
                                    console.log(`[Precious Metals Refresh] Updated cart item price for ${productId} to ${data.regular_price}`);
                                }
                            });
                        }
                        // Checkout page update: trigger update_checkout and then force update the order review.
                        if ($('body').hasClass('woocommerce-checkout')) {
                            $(document.body).trigger('update_checkout');
                            setTimeout(updateCheckoutOrderReview, 1000);
                        }
                    }
                });

                if (!preciousMetalsRefresh.is_admin && $('body').hasClass('woocommerce-cart')) {
                    $(document.body).trigger('wc_update_cart');
                }

                console.log('[Precious Metals Refresh] Price refresh completed at', new Date().toLocaleTimeString(), 'Source:', source);
                isUpdating = false;
            },
            error: function (xhr, status, error) {
                console.error('[Precious Metals Refresh] AJAX error:', status, error);
                isUpdating = false;
            }
        });
    }

    updatePrices('initial');
    setInterval(function () {
        updatePrices('interval');
    }, 60000);

    $(document).on('yaycurrency.onChange', function (event, currency) {
        preciousMetalsRefresh.currency = currency;
        updatePrices('yaycurrency_change');
    });

    $('.woocommerce-currency-switcher').on('change', function () {
        preciousMetalsRefresh.currency = $(this).val();
        updatePrices('currency_switcher');
    });

    $(document).on('added_to_cart', function () {
        updatePrices('added_to_cart');
    });

    $(document).on('click', '.woocommerce-cart-form :submit', function () {
        setTimeout(() => updatePrices('cart_update'), 500);
    });
});
