<?php
if (!function_exists('wcpcsu_pagination')) {
    /**
     * Prints pagination for custom post
     * @param object|WP_Query $custom_post_query
     * @param int $paged
     *
     * @return string
     */
    function wcpcsu_pagination($custom_post_query, $paged = 1)
    {
        $navigation = '';
        $largeNumber = 999999999; // we need a large number here
        $links = paginate_links( array(
            'base' => str_replace( $largeNumber, '%#%', esc_url( get_pagenum_link( $largeNumber ) ) ),
            'format' => '?paged=%#%',
            'current' => max( 1, $paged ),
            'total' => $custom_post_query->max_num_pages,
            'prev_text' => apply_filters('wcpcsu_pagination_prev_text', '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="6" height="100%" preserveAspectRatio="xMidYMid meet" viewBox="0 0 576 1024" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);"><path d="M528 0q14 0 24 10q4 3 6 7t3 8.5t1 9t-1 8.5t-3 8t-6 8L96 515l450 450q6 6 8.5 15t0 18t-8.5 15q-10 10-24.5 10t-24.5-10L23 539q-10-10-10-24t10-24L504 10q10-10 24-10z"/><rect x="0" y="0" width="576" height="1024" fill="rgba(0, 0, 0, 0)" /></svg>'),
            'next_text' => apply_filters('wcpcsu_pagination_next_text', '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="6" height="100%" preserveAspectRatio="xMidYMid meet" viewBox="0 0 576 1024" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);"><path d="M48 1023q-14 0-24.5-10T13 989t10-24l457-457L30 59q-6-7-8.5-16t0-17.5T30 10Q40 0 54.5 0T79 10l473 474q5 5 7.5 11.5t2.5 13t-2.5 12.5t-7.5 11L72 1013q-5 5-11.5 7.5T48 1023z"/><rect x="0" y="0" width="576" height="1024" fill="rgba(0, 0, 0, 0)" /></svg>'),
        ) );
        if( $links ) {
            $navigation = _navigation_markup($links, 'pagination', ' ');
        }
        return apply_filters('wcpcsu_pagination', $navigation, $links, $custom_post_query, $paged);
    }
}
if (!function_exists('wcpcsu_get_paged_num')) {
    /**
     * Get current page number for the pagination.
     *
     * @since    1.0.0
     *
     * @return    int    $paged    The current page number for the pagination.
     */
    function wcpcsu_get_paged_num()
    {

        global $paged;

        if (get_query_var('paged')) {
            $paged = get_query_var('paged');
        } else if (get_query_var('page')) {
            $paged = get_query_var('page');
        } else {
            $paged = 1;
        }

        return absint($paged);

    }
}

if (!function_exists('wpcu_ratings')) {
    /**
     * Get rating stars markup.
     */
    function wpcu_ratings($ratings)
    {
        ?>
        <div class="wpcu-product__rating__stars" title="<?php echo $ratings; ?>%">
            <div class="wpcu-product__rating__stars__wrap">
                <?php
                    for ($x = 0; $x <= 4; $x++) {
                        echo '<svg  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 32 32"><path d="M 16 2.125 L 15.09375 4.1875 L 11.84375 11.46875 L 3.90625 12.3125 L 1.65625 12.5625 L 3.34375 14.0625 L 9.25 19.40625 L 7.59375 27.21875 L 7.125 29.40625 L 9.09375 28.28125 L 16 24.28125 L 22.90625 28.28125 L 24.875 29.40625 L 24.40625 27.21875 L 22.75 19.40625 L 28.65625 14.0625 L 30.34375 12.5625 L 28.09375 12.3125 L 20.15625 11.46875 L 16.90625 4.1875 Z M 16 7.03125 L 18.5625 12.8125 L 18.8125 13.34375 L 19.375 13.40625 L 25.65625 14.0625 L 20.96875 18.28125 L 20.53125 18.6875 L 20.65625 19.25 L 21.96875 25.40625 L 16.5 22.28125 L 16 21.96875 L 15.5 22.28125 L 10.03125 25.40625 L 11.34375 19.25 L 11.46875 18.6875 L 11.03125 18.28125 L 6.34375 14.0625 L 12.625 13.40625 L 13.1875 13.34375 L 13.4375 12.8125 Z"/></svg>';
                    }
                ?>
            </div>
            <div class="wpcu-product__rating__stars__solid" style="width: <?php echo $ratings; ?>%;">
                <?php
                    for ($x = 0; $x <= 4; $x++) {
                        echo '<svg  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 32 32"><path d="M 30.335938 12.546875 L 20.164063 11.472656 L 16 2.132813 L 11.835938 11.472656 L 1.664063 12.546875 L 9.261719 19.394531 L 7.140625 29.398438 L 16 24.289063 L 24.859375 29.398438 L 22.738281 19.394531 Z"/></svg>';
                    }
                ?>
            </div>
        </div>
        <?php
    }
}


if ( ! function_exists('wpcsu_load_dependencies') ) :
    function wpcsu_load_dependencies( $files = 'all', $directory = WCPCSU_INC_DIR, $ext = '.php' )
    {
        if ( ! file_exists( $directory ) ) return; // vail if the directory does not exist

        switch( $files ) {
            case is_array( $files ) && 'all' !== strtolower( $files[0] ):
                // include one or more file looping through the $files array
                load_some_file( $files, $directory );
                break;
            case ! is_array( $files ) && 'all' !== $files:
                //load a single file here
                ( file_exists( $directory . $files . $ext ) ) ? require_once $directory . $files . $ext : null;
                break;
            case 'all' == $files || 'all' == strtolower( $files[0] ):
                // load all php file here
                load_all_files( $directory );
                break;
        }

        return false;

    }
endif;

if ( ! function_exists('load_all_files') ):
    function load_all_files( $dir = '', $ext = '.php' )
    {
        if ( ! file_exists( $dir ) ) return;
        foreach ( scandir( $dir ) as $file ) {
            // require once all the files with the given ext. eg. .php
            if ( preg_match( "/{$ext}$/i", $file ) ) {
                require_once( $dir . $file );
            }
        }
    }
endif;

if ( ! function_exists('wpcsu_ribbon_badge') ) :
    function wpcsu_ribbon_badge( $ribbon_args, $discount )
    {
        global $product;
        $value = is_array( $ribbon_args ) ? $ribbon_args : array();
        extract( $value );


        if( ( 'yes' == $display_sale_ribbon && 'top_left' == $sale_ribbon_position && $product->is_on_sale() ) || ( 'yes' == $display_featured_ribbon && 'top_left' == $featured_ribbon_position && $product->is_featured() ) || ( 'yes' == $display_sold_out_ribbon && 'top_left' == $sold_out_ribbon_position && ! $product->is_in_stock() ) || ( 'yes' == $display_discount_ribbon && 'top_left' == $discount_ribbon_position && $product->get_sale_price() ) ) { ?>
            <div class="wpcu-product__cover-content wpcu-product__cover-content--top-left">

                <?php if( 'yes' == $display_sale_ribbon && 'top_left' == $sale_ribbon_position && $product->is_on_sale() ) { ?>
                <span class="wpcu-badge wpcu-sale wpcu-badge--primary wpcu-badge--text-lg wpcu-badge--rounded-circle"><?php echo ! empty( $sale_ribbon_text ) ? $sale_ribbon_text : ''; ?></span>
                <?php } ?>

                <?php if( 'yes' == $display_featured_ribbon && 'top_left' == $featured_ribbon_position && $product->is_featured() ) { ?>
                <span class="wpcu-badge wpcu-feature wpcu-badge--primary wpcu-badge--text-lg wpcu-badge--rounded-circle"><?php echo ! empty( $feature_ribbon_text ) ? $feature_ribbon_text : ''; ?></span>
                <?php } ?>

                <?php if( 'yes' == $display_sold_out_ribbon && 'top_left' == $sold_out_ribbon_position && ! $product->is_in_stock() ) { ?>
                <span class="wpcu-badge wpcu-sold_out wpcu-badge--primary wpcu-badge--text-lg wpcu-badge--rounded-circle"><?php echo ! empty( $sold_out_ribbon_text ) ? $sold_out_ribbon_text : ''; ?></span>
                <?php } ?>

                <?php if( 'yes' == $display_discount_ribbon && 'top_left' == $discount_ribbon_position && $product->get_sale_price() ) { ?>
                <span class="wpcu-badge wpcu-discount wpcu-badge--primary wpcu-badge--text-lg wpcu-badge--rounded-circle"><?php echo ! empty( $discount ) ? '-'.$discount : ''; ?></span>
                <?php } ?>

            </div>
            <?php } ?>

            <?php if( ( 'yes' == $display_sale_ribbon && 'top_right' == $sale_ribbon_position && $product->is_on_sale() ) || ( 'yes' == $display_featured_ribbon && 'top_right' == $featured_ribbon_position && $product->is_featured() ) || ( 'yes' == $display_sold_out_ribbon && 'top_right' == $sold_out_ribbon_position && ! $product->is_in_stock() ) || ( 'yes' == $display_discount_ribbon && 'top_right' == $discount_ribbon_position ) && $product->get_sale_price() ) { ?>
            <div class="wpcu-product__cover-content wpcu-product__cover-content--top-right">

                <?php if( 'yes' == $display_sale_ribbon && 'top_right' == $sale_ribbon_position && $product->is_on_sale() ) { ?>
                <span class="wpcu-badge wpcu-sale wpcu-badge--primary wpcu-badge--text-lg wpcu-badge--rounded-circle"><?php echo ! empty( $sale_ribbon_text ) ? $sale_ribbon_text : ''; ?></span>
                <?php } ?>

                <?php if( 'yes' == $display_featured_ribbon && 'top_right' == $featured_ribbon_position && $product->is_featured() ) { ?>
                <span class="wpcu-badge wpcu-feature wpcu-badge--primary wpcu-badge--text-lg wpcu-badge--rounded-circle"><?php echo ! empty( $feature_ribbon_text ) ? $feature_ribbon_text : ''; ?></span>
                <?php } ?>

                <?php if( 'yes' == $display_sold_out_ribbon && 'top_right' == $sold_out_ribbon_position && ! $product->is_in_stock() ) { ?>
                <span class="wpcu-badge wpcu-sold_out wpcu-badge--primary wpcu-badge--text-lg wpcu-badge--rounded-circle"><?php echo ! empty( $sold_out_ribbon_text ) ? $sold_out_ribbon_text : ''; ?></span>
                <?php } ?>

                <?php if( 'yes' == $display_discount_ribbon && 'top_right' == $discount_ribbon_position && $product->get_sale_price() ) { ?>
                <span class="wpcu-badge wpcu-discount wpcu-badge--primary wpcu-badge--text-lg wpcu-badge--rounded-circle"><?php echo ! empty( $discount ) ? '-'.$discount : ''; ?></span>
                <?php } ?>

            </div>
            <?php } ?>

            <?php if( ( 'yes' == $display_sale_ribbon && 'bottom_left' == $sale_ribbon_position && $product->is_on_sale() ) || ( 'yes' == $display_featured_ribbon && 'bottom_left' == $featured_ribbon_position && $product->is_featured() ) || ( 'yes' == $display_sold_out_ribbon && 'bottom_left' == $sold_out_ribbon_position && ! $product->is_in_stock() ) || ( 'yes' == $display_discount_ribbon && 'bottom_left' == $discount_ribbon_position ) && $product->get_sale_price() ) { ?>
            <div class="wpcu-product__cover-content wpcu-product__cover-content--bottom-left">

                <?php if( 'yes' == $display_sale_ribbon && 'bottom_left' == $sale_ribbon_position && $product->is_on_sale() ) { ?>
                <span class="wpcu-badge wpcu-sale wpcu-badge--primary wpcu-badge--text-lg wpcu-badge--rounded-circle"><?php echo ! empty( $sale_ribbon_text ) ? $sale_ribbon_text : ''; ?></span>
                <?php } ?>

                <?php if( 'yes' == $display_featured_ribbon && 'bottom_left' == $featured_ribbon_position && $product->is_featured() ) { ?>
                <span class="wpcu-badge wpcu-feature wpcu-badge--primary wpcu-badge--text-lg wpcu-badge--rounded-circle"><?php echo ! empty( $feature_ribbon_text ) ? $feature_ribbon_text : ''; ?></span>
                <?php } ?>

                <?php if( 'yes' == $display_sold_out_ribbon && 'bottom_left' == $sold_out_ribbon_position && ! $product->is_in_stock() ) { ?>
                <span class="wpcu-badge wpcu-sold_out wpcu-badge--primary wpcu-badge--text-lg wpcu-badge--rounded-circle"><?php echo ! empty( $sold_out_ribbon_text ) ? $sold_out_ribbon_text : ''; ?></span>
                <?php } ?>

                <?php if( 'yes' == $display_discount_ribbon && 'bottom_left' == $discount_ribbon_position && $product->get_sale_price() ) { ?>
                <span class="wpcu-badge wpcu-discount wpcu-badge--primary wpcu-badge--text-lg wpcu-badge--rounded-circle"><?php echo ! empty( $discount ) ? '-'.$discount : ''; ?></span>
                <?php } ?>

            </div>
            <?php } ?>

            <?php if( ( 'yes' == $display_sale_ribbon && 'bottom_right' == $sale_ribbon_position && $product->is_on_sale() ) || ( 'yes' == $display_featured_ribbon && 'bottom_right' == $featured_ribbon_position && $product->is_featured() ) || ( 'yes' == $display_sold_out_ribbon && 'bottom_right' == $sold_out_ribbon_position && ! $product->is_in_stock() ) || ( 'yes' == $display_discount_ribbon && 'bottom_right' == $discount_ribbon_position ) && $product->get_sale_price()) { ?>
            <div class="wpcu-product__cover-content wpcu-product__cover-content--bottom-right">

                <?php if( 'yes' == $display_sale_ribbon && 'bottom_right' == $sale_ribbon_position && $product->is_on_sale() ) { ?>
                <span class="wpcu-badge wpcu-sale wpcu-badge--primary wpcu-badge--text-lg wpcu-badge--rounded-circle"><?php echo ! empty( $sale_ribbon_text ) ? $sale_ribbon_text : ''; ?></span>
                <?php } ?>

                <?php if( 'yes' == $display_featured_ribbon && 'bottom_right' == $featured_ribbon_position && $product->is_featured() ) { ?>
                <span class="wpcu-badge wpcu-feature wpcu-badge--primary wpcu-badge--text-lg wpcu-badge--rounded-circle"><?php echo ! empty( $feature_ribbon_text ) ? $feature_ribbon_text : ''; ?></span>
                <?php } ?>

                <?php if( 'yes' == $display_sold_out_ribbon && 'bottom_right' == $sold_out_ribbon_position && ! $product->is_in_stock() ) { ?>
                <span class="wpcu-badge wpcu-sold_out wpcu-badge--primary wpcu-badge--text-lg wpcu-badge--rounded-circle"><?php echo ! empty( $sold_out_ribbon_text ) ? $sold_out_ribbon_text : ''; ?></span>
                <?php } ?>

                <?php if( 'yes' == $display_discount_ribbon && 'bottom_right' == $discount_ribbon_position && $product->get_sale_price() ) { ?>
                <span class="wpcu-badge wpcu-discount wpcu-badge--primary wpcu-badge--text-lg wpcu-badge--rounded-circle"><?php echo ! empty( $discount ) ? '-'.$discount : ''; ?></span>
                <?php } ?>

            </div>
            <?php }


    }
endif;