<?php

// Define the allowed domain names and expiry date gradualise.com.au
$allowed_domains = array( 'goldcoinmint.com', 'www.goldcoinmint.com' ); // Add new domain names here
$expiry_date = '2029-12-06'; // Change this to your desired expiry date

// Hook into the plugin activation event
register_activation_hook(__FILE__, 'plugin_activation');

function plugin_activation() {
    global $allowed_domains, $expiry_date;

    // Check if the current domain matches any of the allowed domains
    if (!in_array($_SERVER['HTTP_HOST'], $allowed_domains)) {
        deactivate_plugins(plugin_basename(__FILE__));
        wp_die('Sorry, this plugin is only available for ' . implode(' or ', $allowed_domains));
    }

    // Check if the current date is past the expiry date
    if (date('Y-m-d') > $expiry_date) {
        deactivate_plugins(plugin_basename(__FILE__));
        wp_die('Sorry, this plugin has expired.');
    }
}

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

define("GOLDPRICELIVE_DEBUG", 1);

if (in_array('woocommerce/woocommerce.php', apply_filters('active_plugins', get_option('active_plugins')))) {

    class WC_GoldPriceLive
    {
        private $metals = array('gold', 'silver', 'platinum', 'palladium');

        private $options = array(
            "shortcodes_enabled" => TRUE,
            "live_shortcodes_enabled" => TRUE,
            "color_disabled" => FALSE,
            "shortcodes_animation_enabled" => TRUE,
            "live_price_enabled" => TRUE,
            "remove_featured_image_enabled" => FALSE,
            "live_product_shortcodes_enabled" => TRUE,
            "product_shortcodes_animation_enabled" => TRUE,
            "gold_decimal_position" => 2,
            "gold_rounding" => 0.01,
            "silver_decimal_position" => 2,
            "silver_rounding" => 0.01,
            "platinum_decimal_position" => 2,
            "platinum_rounding" => 0.01,
            "palladium_decimal_position" => 2,
            "palladium_rounding" => 0.01,
            "close_store" => FALSE,
            "page_id" => NULL,
            "empty_cart_timeout" => NULL,
            "empty_cart_redirect_to" => NULL
        );

        public function __construct()
        {
            if (GOLDPRICELIVE_DEBUG) $GLOBALS['wp_log_plugins'][] = 'WC_GoldPriceLive';

            add_action('wp_loaded', array($this, 'init'));
        }

        public function init()
        {
            $this->options = array_merge($this->options, get_option('gold_price_live_settings'));

            add_shortcode('woocommerceproduct', array($this, 'get_woocommerceproduct'));

            if (is_admin()) {
                add_action("wp_ajax_goldpricelive_feed", array($this, 'goldpricelive_feed'));
                add_action("wp_ajax_nopriv_goldpricelive_feed", array($this, 'goldpricelive_feed'));
            }

            add_action("add_meta_boxes_product", array($this, "add_meta_box"));
            //add_action("save_post_product", array($this, "save_meta_box"), 9999, 3);
            add_action("woocommerce_process_product_meta", array($this, "save_meta_box"), 9999);
            add_action("wp", array($this, 'shop_closed'));
            add_action("wp_print_scripts", array($this, 'empty_cart_timer'));
            add_action("wp_ajax_empty_cart", array($this, 'empty_cart'));
            add_action("wp_ajax_nopriv_empty_cart", array($this, 'empty_cart'));

            if (isset($this->options['remove_featured_image_enabled']) && $this->options['remove_featured_image_enabled']) {
                add_filter('woocommerce_single_product_image_thumbnail_html', array($this, 'remove_featured_image'), 10, 3);
                add_filter('woocommerce_single_product_image_html', array($this, 'remove_featured_image'), 10, 3);
            }

            if (isset($this->options['live_price_enabled']) && $this->options['live_price_enabled']) {
                add_action('wp_enqueue_scripts', array($this, 'liveprice_custom_js'));
                add_action('wp_enqueue_scripts', array($this, 'liveprice_custom_css'));
                add_action('wp_ajax_liveprice', array($this, 'liveprice_callback'));
                add_action('wp_ajax_nopriv_liveprice', array($this, 'liveprice_callback'));
                add_action('wp_ajax_liveprice_cart', array($this, 'liveprice_cart_callback'));
                add_action('wp_ajax_nopriv_liveprice_cart', array($this, 'liveprice_cart_callback'));
            }

            if (isset($this->options['live_product_shortcodes_enabled']) && $this->options['live_product_shortcodes_enabled']) {
                add_action('wp_enqueue_scripts', array($this, 'live_product_shortcodes_js'));
                add_action('wp_ajax_live_product_shortcodes', array($this, 'live_product_shortcodes_callback'));
                add_action('wp_ajax_nopriv_live_product_shortcodes', array($this, 'live_product_shortcodes_callback'));
            }

            if (isset($this->options['product_shortcodes_animation_enabled']) && $this->options['product_shortcodes_animation_enabled']) {
                add_action('wp_enqueue_scripts', array($this, 'product_shortcodes_animation_js'));
            }

            add_action('wp_enqueue_scripts', array($this, 'product_shortcodes_animation_css'));


            add_action('wp_enqueue_scripts', array($this, 'update_js'));
            add_action('admin_enqueue_scripts', array($this, 'update_js'));
            add_action('wp_ajax_goldpricelive_update', array($this, 'goldpricelive_update_callback'));
            add_action('wp_ajax_nopriv_goldpricelive_update', array($this, 'goldpricelive_update_callback'));

            /* running update when transient expire
            //delete_transient('goldpricelive_update_valid'); //FOR DEBUGGING
            if (get_transient('goldpricelive_update_valid')) return;
            set_transient('goldpricelive_update_valid', 1, 60);
            $this->update_data();
            */
        }

        public function update_js()
        {
            wp_register_script('goldpricelive_update', plugin_dir_url(__FILE__) . '/js/goldpricelive_update.js', array('jquery'));
            wp_localize_script('goldpricelive_update', 'goldpricelive_update_parameters', array('ajaxurl' => admin_url('admin-ajax.php')));
            wp_enqueue_script('goldpricelive_update');
        }

        public function goldpricelive_update_callback()
        {
            $response = array("success" => false);
            if (!get_transient('goldpricelive_update_valid')) {
                set_transient('goldpricelive_update_valid', 1, 60);
                $response["success"] = $this->update_data();
            }

            header("Content-Type: application/json");
            echo json_encode($response);
            exit();
        }

        public function remove_featured_image($html, $attachment_post_id)
        {
            global $post;
            if (has_post_thumbnail($post) && $post->ID == $attachment_post_id)
                //return str_replace("<img ", "<img style=\"display: none !important;\" ", $html);
                return "";
            else
                return $html;
        }

        public function get_woocommerceproduct($atts)
        {
            $a = shortcode_atts(array(
                'id' => 0,
                'entity' => 'title',
                'percentmarkupdown' => 1,
                'fixedmarkupdown' => 0,
                'animation' => false,
                'color' => ''
            ), $atts);

            $entities = array('title', 'price', 'description', 'shortdescription');
            if (!$a['entity'] || !in_array($a['entity'], $entities)) $a['entity'] = 'title';

            if ($a['id'] <= 0) return "";

            $_product = wc_get_product($a['id']);

            if (!$_product) return "";

            switch ($a['entity']) {
                case 'price':
                    $_price = $_product->get_price();

                    if (isset($a['percentmarkupdown']) && is_numeric($a['percentmarkupdown']) && $a['percentmarkupdown'] > 0 && $a['percentmarkupdown'] != 1) {
                        $_price = floatval($_price) * floatval($a['percentmarkupdown']);
                    } elseif (isset($a['fixedmarkupdown']) && is_numeric($a['fixedmarkupdown']) && $a['fixedmarkupdown'] != 0) {
                        $_price = floatval($_price) + floatval($a['fixedmarkupdown']);
                    }

                    $metal = get_post_meta($a['id'], "_goldpricelive_metal", "gold");
                    $price_html = wc_price($_price, array("decimals" => $this->options[$metal . '_decimal_position']));

                    switch ((float)$this->options[$metal . "_rounding"]) {
                        case 0.1:
                            $k = 10;
                            break;
                        case 0.5:
                            $k = 2;
                            break;
                        case 0.05:
                            $k = 20;
                            break;
                        case 0.001:
                            $k = 1000;
                            break;
                        case 0.005:
                            $k = 200;
                            break;
                        case 0.01:
                        default:
                            $k = 100;
                            break;
                    }

                    return '<span class="gpl-product-shortcode'
                        . ((isset($a) && is_array($a) && isset($a['animation']) && $a['animation']) ? ' gpl-product-shortcode-animate' : "") . '" '
                        . ' data-pid="' . $_product->get_id() . '" '
                        . ((isset($a['percentmarkupdown']) && is_numeric($a['percentmarkupdown']) && $a['percentmarkupdown'] > 0 && $a['percentmarkupdown'] != 1) ? ' data-percentmarkupdown="' . floatval($a['percentmarkupdown']) . '" ' : '')
                        . ((isset($a['fixedmarkupdown']) && is_numeric($a['fixedmarkupdown']) && $a['fixedmarkupdown'] != 0) ? ' data-fixedmarkupdown="' . floatval($a['fixedmarkupdown']) . '" ' : '')
                        . 'data-rounding="' . $k . '" '
                        . 'data-decimalplaces="' . $this->options[$metal . "_decimal_position"] . '" '
                        . (!empty($a['color']) ? 'style="color: ' . $a['color'] . ' !important;"' : '')
                        . '>'
                        . ((isset($a) && is_array($a) && isset($a['animation']) && $a['animation'] && isset($this->options['product_shortcodes_animation_enabled']) && $this->options['product_shortcodes_animation_enabled']) ? ('<span>' . $price_html . '</span><span data-new="1">' . $price_html . '</span>') : $price_html)
                        . '</span>';
                    break;
                case 'description':
                    return '<div class="gpl-product-shortcode">' . $_product->post->post_content . '</div>';
                    break;
                case 'shortdescription':
                    return '<div class="gpl-product-shortcode">' . $_product->post->post_excerpt . '</div>';
                    break;
                default:
                    return '<div class="gpl-product-shortcode">' . $_product->get_title() . '</div>';
            }
        }

        public function product_shortcodes_animation_js()
        {
            wp_register_script('product_shortcodes_animation', plugin_dir_url(__FILE__) . '/js/product_animation.js', array('jquery'));
            wp_enqueue_script('product_shortcodes_animation');
            wp_register_script('jquery_cycle', plugin_dir_url(__FILE__) . '/js/jquery.cycle.all.js', array('jquery'));
            wp_enqueue_script('jquery_cycle');
        }

        public function product_shortcodes_animation_css()
        {
            wp_register_style('product_shortcodes_animation', plugin_dir_url(__FILE__) . '/css/product_animation.css', array());
            wp_enqueue_style('product_shortcodes_animation');
        }

        public function live_product_shortcodes_js()
        {
            wp_register_script('live_product_shortcodes', plugin_dir_url(__FILE__) . '/js/live_product_shortcodes.js', array('jquery'));
            wp_localize_script('live_product_shortcodes', 'live_product_shortcodes_parameters', array('ajaxurl' => admin_url('admin-ajax.php')));
            wp_enqueue_script('live_product_shortcodes');
        }

        public function live_product_shortcodes_callback()
        {
            $response = array("error" => false);
            $response['pattern'] = wc_price(7.77);

            if (isset($_GET['pids']) && is_array($_GET['pids'])) {
                foreach ($_GET['pids'] as $item) {
                    $pid = intval($item);
                    if ($pid) {
                        $_product = wc_get_product($pid);
                        if ($_product) {
                            $response[$pid] = $_product->get_price();
                        }
                    }
                }
            }

            echo json_encode($response);

            wp_die();
        }

        function hide_btn_is_purchasable($is_purchasable, $product)
        {
            $hide_add_button = (bool)get_post_meta($product->id, '_goldpricelive_hide_cart_btn', TRUE);

            return ($hide_add_button ? false : $is_purchasable);
        }

        public function hide_price_n_btn($price)
        {
            global $post;
            $hide_price = (bool)get_post_meta($post->ID, '_goldpricelive_hide_price', TRUE);
            $hide_add_button = (bool)get_post_meta($post->ID, '_goldpricelive_hide_cart_btn', TRUE);

            if (!is_single()) {
                if ($hide_add_button) {
                    remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10);
                    remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 30);
                } else {
                    if (!has_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart')) {
                        add_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10);
                    }
                    if (!has_action('woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart')) {
                        add_action('woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 30);
                    }
                }
            }


            if ($hide_price) {
                return null;
            } else {
                return $price;
            }
        }

        public function liveprice_custom_js()
        {
            if (is_product()) {
                global $post;

                wp_register_script('liveprice_single', plugin_dir_url(__FILE__) . '/js/liveprice_single.js', array('jquery'));
                wp_localize_script('liveprice_single', 'liveprice_parameters', array('ajaxurl' => admin_url('admin-ajax.php'), 'product_id' => $post->ID, 'color_disabled' => $this->options['color_disabled']));
                wp_enqueue_script('liveprice_single');
            }
            if (is_shop()) {
                wp_register_script('liveprice_shop', plugin_dir_url(__FILE__) . '/js/liveprice_shop.js', array('jquery'));
                wp_localize_script('liveprice_shop', 'liveprice_parameters', array('ajaxurl' => admin_url('admin-ajax.php'), 'color_disabled' => $this->options['color_disabled']));
                wp_enqueue_script('liveprice_shop');
            }
            if (is_cart()) {
                wp_register_script('liveprice_cart', plugin_dir_url(__FILE__) . '/js/liveprice_cart.js', array('jquery'));
                wp_localize_script('liveprice_cart', 'liveprice_parameters', array('ajaxurl' => admin_url('admin-ajax.php'), 'color_disabled' => $this->options['color_disabled']));
                wp_enqueue_script('liveprice_cart');
            }
            if (is_product_category()) {
                wp_register_script('liveprice_category', plugin_dir_url(__FILE__) . '/js/liveprice_category.js', array('jquery'));
                wp_localize_script('liveprice_category', 'liveprice_parameters', array('ajaxurl' => admin_url('admin-ajax.php'), 'color_disabled' => $this->options['color_disabled']));
                wp_enqueue_script('liveprice_category');
            }
        }

        public function liveprice_custom_css()
        {
            if (is_product() || is_cart() || is_product_category() || is_shop()) {
                wp_register_style('liveprice_style', plugin_dir_url(__FILE__) . '/css/liveprice_style.css', array());
                wp_enqueue_style('liveprice_style');
            }
        }

        public function liveprice_callback()
        {
            $response = array("error" => false);

            $product_id = $_GET['product_id'];
            if ($product_id && !is_array($product_id)) {
                $product_id = intval($product_id);
                if ($product_id) {
                    $_product = wc_get_product($product_id);
                    if ($_product) {
                        $metal = get_post_meta($product_id, "_goldpricelive_metal", "gold");
                        $opt = array();
                        if (isset($this->options[$metal . '_decimal_position'])) {
                            $opt["decimals"] = $this->options[$metal . '_decimal_position'];
                        }
                        $response = array(
                            'product_id' => $product_id,
                            'price' => $_product->get_price(),
                            'price_formatted' => wc_price($_product->get_price(), $opt)
                        );
                    } else {
                        $response['error'] = "Wrong product ID.";
                    }
                } else {
                    $response['error'] = "Wrong product ID.";
                }
            } elseif ($product_id && is_array($product_id)) {
                $response['products'] = array();
                foreach ($product_id as $_product_id) {
                    $_product_id = intval($_product_id);
                    if ($_product_id) {
                        $_product = wc_get_product($_product_id);
                        if ($_product) {
                            $metal = get_post_meta($_product_id, "_goldpricelive_metal", "gold");
                            $opt = array();
                            if (isset($this->options[$metal . '_decimal_position'])) {
                                $opt["decimals"] = $this->options[$metal . '_decimal_position'];
                            }
                            $response['products'][] = array(
                                'product_id' => $_product_id,
                                'price' => $_product->get_price(),
                                'price_formatted' => wc_price($_product->get_price(), $opt)
                            );
                        } else {
                            $response['error'] = "Wrong product ID.";
                        }
                    } else {
                        $response['error'] = "Wrong product ID.";
                    }
                }
            } else {
                $response['error'] = "Wrong product ID.";
            }

            echo json_encode($response);

            wp_die();
        }

        public function liveprice_cart_callback()
        {
            global $woocommerce;
            $response = array("error" => false);

            $cart = $woocommerce->cart->get_cart();
            $response['cart'] = array();
            foreach ($cart as $key => $product) {
                $metal = get_post_meta($product['product_id'], "_goldpricelive_metal", "gold");
                $opt = array();
                if (isset($this->options[$metal . '_decimal_position'])) {
                    $opt["decimals"] = $this->options[$metal . '_decimal_position'];
                }
                $response['cart'][$key] = array(
                    'product_id' => $product['product_id'],
                    'line_total' => $product['line_total'],
                    'line_total_formatted' => wc_price($product['line_total'], array("decimals" => $this->options[$metal . '_decimal_position'])),
                    'line_subtotal' => $product['line_subtotal'],
                    'line_subtotal_formatted' => wc_price($product['line_subtotal'], array("decimals" => $this->options[$metal . '_decimal_position'])),
                    'price' => floatval($product['data']->price),
                    'price_formatted' => wc_price(floatval($product['data']->price), $opt)
                );
                if (isset($product['rp_wcdpd'])) {
                    $response['cart'][$key]['original_price'] = $product['rp_wcdpd']['original_price'];
                    $response['cart'][$key]['original_price_formatted'] = wc_price($product['rp_wcdpd']['original_price'], $opt);
                }
            }

            $response['subtotal'] = $woocommerce->cart->get_cart_subtotal();
            $response['total'] = $woocommerce->cart->get_cart_total();

            echo json_encode($response);

            wp_die();
        }

        function rounding($number, $nearest, $decimals, $dec_point = ".", $thousands_sep = "")
        {
            switch ($nearest) {
                case 0.1:
                    $k = 10;
                    break;
                case 0.5:
                    $k = 2;
                    break;
                case 0.05:
                    $k = 20;
                    break;
                case 0.001:
                    $k = 1000;
                    break;
                case 0.005:
                    $k = 200;
                    break;
                case 0.01:
                default:
                    $k = 100;
                    break;
            }
            return number_format(round($number * $k, 0) / $k, $decimals, $dec_point, $thousands_sep);
        }

        public function update_data()
        {
            $args = array(
                'post_type' => 'product',
                'posts_per_page' => -1,
                'meta_query' => array(
                    array(
                        'key' => '_goldpricelive_units',
                        'value' => '',
                        'compare' => '!='
                    ),
                    array(
                        'key' => '_goldpricelive_metal',
                        'value' => '',
                        'compare' => '!='
                    ),
                    array(
                        'key' => '_goldpricelive_weight',
                        'value' => 0,
                        'compare' => '!='
                    ),
                    array(
                        'key' => '_goldpricelive_purity',
                        'value' => 0,
                        'compare' => '!='
                    )
                )
            );

            $products = new WP_Query($args);
            if (!$products->error && $products->post_count > 0) {
                $supported_currencies = array('usd', 'cad', 'aud', 'chf', 'eur', 'gbp');
                $currency = strtolower(get_option('woocommerce_currency'));
                if (!in_array($currency, $supported_currencies)) $currency = 'usd';

                $prices_cache = get_option("gpl_prices_cache_" . $currency, FALSE);
                if (!$prices_cache || !isset($prices_cache['gpl_load_timestamp'])) return;
                $prices = array(
                    'gold' => floatval($prices_cache["gold_ask_" . $currency . "_toz"]),
                    'silver' => floatval($prices_cache["silver_ask_" . $currency . "_toz"]),
                    'platinum' => floatval($prices_cache["platinum_ask_" . $currency . "_toz"]),
                    'palladium' => floatval($prices_cache["palladium_ask_" . $currency . "_toz"])
                );

                $this->log("[" . date("H:i:m") . "] Start updating job for " . count($products->posts) . " products.");

                foreach ($products->posts as $post) {
                    $post_meta = get_post_meta($post->ID);
                    $fixed_amount = floatval($post_meta['_goldpricelive_fixed_amount'][0]);
                    $weight = floatval($post_meta['_goldpricelive_weight'][0]);
                    $metal = $post_meta['_goldpricelive_metal'][0];
                    $units = $post_meta['_goldpricelive_units'][0];
                    $purity = floatval($post_meta['_goldpricelive_purity'][0]);
                    $markup = floatval($post_meta['_goldpricelive_markup'][0]);
                    $lowest = floatval($post_meta['_goldpricelive_lowest'][0]);
                    $buy_back = floatval($post_meta['_goldpricelive_buy_back'][0]);

                    if ($weight > 0 && $purity > 0 && $markup >= 0 && !empty($metal) && $prices[$metal] && (float)$prices[$metal] > 0) {

                        $price = ($weight * $purity * (1 + ($markup / 100))) * $this->toz_to_unit($prices[$metal], $units) + $fixed_amount;


                        if (isset($lowest) && !is_null($lowest) && $lowest > 0 && $lowest > $price) $price = $lowest;

                        $pattern = "/([BUY BACK PRICE\:]{1,}) ([\d]{1,}[.]{0,}[\d]{0,}) (USD|CAD|EUR|AUD|GBP|CNY|CHF|NZD|JPY|ZAR|CZK|MYR|SGD)/U";


                        if (isset($buy_back) && !is_null($buy_back) && $buy_back > 0) {
                            $buy_back_price = $price - (($buy_back / 100) * $price);

                            if (preg_match($pattern, $post->post_excerpt)) {
                                $short_description = preg_replace($pattern, "$1 " . round($buy_back_price, 2) . " " . strtoupper($currency), $post->post_excerpt);
                            } else {
                                $short_description = "BUY BACK PRICE: " . round($buy_back_price, 2) . " " . strtoupper($currency) . " " . $post->post_excerpt;
                            }
                        } else {
                            $short_description = trim(preg_replace($pattern, "", $post->post_excerpt));
                        }

                        if (
                            $price > 0 && (
                                round($price, 2) != round($post_meta['price'], 2)
                                || round($price, 2) != round($post_meta['regural_price'], 2)
                                || trim($short_description) != trim($post->post_excerpt)
                            )
                        ) {

                            $data = array(
                                "ID" => $post->ID,
                                "post_excerpt" => $short_description
                            );

                            wp_update_post($data);
                            update_post_meta($post->ID, "_price", strval($this->rounding((float)$price, (float)$this->options[$metal . "_rounding"], $this->options[$metal . "_decimal_position"])));
                            update_post_meta($post->ID, "_regular_price", strval($this->rounding((float)$price, (float)$this->options[$metal . "_rounding"], $this->options[$metal . "_decimal_position"])));

                            $this->log("[" . date("H:i:m") . "] new price for #" . $post->ID . ", fa(" . $fixed_amount . "), w(" . $weight . "), m(" . $metal . ").");
                        }

                    }

                    unset($fixed_amount);
                    unset($weight);
                    unset($metal);
                    unset($units);
                    unset($purity);
                    unset($markup);
                    unset($lowest);
                    unset($buy_back);

                }
            }

            return TRUE;
        }

        public function goldpricelive_feed()
        {
            $response = array('error' => false);

            $supported_currencies = array('usd', 'cad', 'aud', 'chf', 'eur', 'gbp');
            $currency = strtolower(get_option('woocommerce_currency'));
            if (!in_array($currency, $supported_currencies)) $currency = 'usd';
            $response['currency'] = $currency;

            $prices_cache = get_option("gpl_prices_cache_" . $currency, FALSE);
            if (!$prices_cache || !isset($prices_cache['gpl_load_timestamp'])) {
                $response['error'] = 'Server Error. Please try again in few minutes.';
            } else {
                $response['ask']['gold'] = floatval($prices_cache["gold_ask_" . $currency . "_toz"]);
                $response['ask']['silver'] = floatval($prices_cache["silver_ask_" . $currency . "_toz"]);
                $response['ask']['platinum'] = floatval($prices_cache["platinum_ask_" . $currency . "_toz"]);
                $response['ask']['palladium'] = floatval($prices_cache["palladium_ask_" . $currency . "_toz"]);
            }

            echo json_encode($response);
            die;
        }

        public function add_meta_box()
        {
            add_meta_box("goldpricelive_metabox", __("Live Price Settings", "wc_goldpricelive"), array($this, "meta_box_markup"), "product", "side", "high", null);
        }

        public function meta_box_markup($post)
        {
            wp_nonce_field(basename(__FILE__), 'goldpricelive_nonce');

            $goldpricelive_fixed_amount = get_post_meta($post->ID, '_goldpricelive_fixed_amount', true);
            $goldpricelive_weight = get_post_meta($post->ID, '_goldpricelive_weight', true);
            $goldpricelive_metal = get_post_meta($post->ID, '_goldpricelive_metal', true);
            $goldpricelive_units = get_post_meta($post->ID, '_goldpricelive_units', true);
            if (is_null($goldpricelive_units) || empty($goldpricelive_units)) $goldpricelive_units = "gram";
            $goldpricelive_purity = get_post_meta($post->ID, '_goldpricelive_purity', true);
            $goldpricelive_markup = get_post_meta($post->ID, '_goldpricelive_markup', true);
            $goldpricelive_lowest = get_post_meta($post->ID, '_goldpricelive_lowest', true);
            $goldpricelive_buy_back = get_post_meta($post->ID, '_goldpricelive_buy_back', true);
            $goldpricelive_hide_price = get_post_meta($post->ID, '_goldpricelive_hide_price', true);
            $goldpricelive_hide_cart_btn = get_post_meta($post->ID, '_goldpricelive_hide_cart_btn', true);

            switch ((float)$this->options["gold_rounding"]) {
                case 0.1:
                    $gold_k = 10;
                    break;
                case 0.5:
                    $gold_k = 2;
                    break;
                case 0.05:
                    $gold_k = 20;
                    break;
                case 0.001:
                    $gold_k = 1000;
                    break;
                case 0.005:
                    $gold_k = 200;
                    break;
                case 0.01:
                default:
                    $gold_k = 100;
                    break;
            }
            switch ((float)$this->options["silver_rounding"]) {
                case 0.1:
                    $silver_k = 10;
                    break;
                case 0.5:
                    $silver_k = 2;
                    break;
                case 0.05:
                    $silver_k = 20;
                    break;
                case 0.001:
                    $silver_k = 1000;
                    break;
                case 0.005:
                    $silver_k = 200;
                    break;
                case 0.01:
                default:
                    $silver_k = 100;
                    break;
            }
            switch ((float)$this->options["platinum_rounding"]) {
                case 0.1:
                    $platinum_k = 10;
                    break;
                case 0.5:
                    $platinum_k = 2;
                    break;
                case 0.05:
                    $platinum_k = 20;
                    break;
                case 0.001:
                    $platinum_k = 1000;
                    break;
                case 0.005:
                    $platinum_k = 200;
                    break;
                case 0.01:
                default:
                    $platinum_k = 100;
                    break;
            }
            switch ((float)$this->options["palladium_rounding"]) {
                case 0.1:
                    $palladium_k = 10;
                    break;
                case 0.5:
                    $palladium_k = 2;
                    break;
                case 0.05:
                    $palladium_k = 20;
                    break;
                case 0.001:
                    $palladium_k = 1000;
                    break;
                case 0.005:
                    $palladium_k = 200;
                    break;
                case 0.01:
                default:
                    $palladium_k = 100;
                    break;
            }

            ?>
            <div class='options_group'>
                <input type="hidden" name="goldpricelive_post_id" value="<?php echo $post->ID; ?>"/>
                <p class="form-field">
                    <label for="_goldpricelive_hide_price"><?php echo __('Hide Price', 'wc_goldpricelive'); ?></label>
                    <input type="checkbox" class="short" onkeyup="update_goldpricelive_metabox_fields();"
                           name="goldpricelive_hide_price" id="_goldpricelive_hide_price"
                           value="1" <?php echo ($goldpricelive_hide_price) ? "checked" : ""; ?> />
                </p>
                <p class="form-field">
                    <label for="_goldpricelive_hide_cart_btn"><?php echo __('Hide "Add to Cart" Button', 'wc_goldpricelive'); ?></label>
                    <input type="checkbox" class="short" onkeyup="update_goldpricelive_metabox_fields();"
                           name="goldpricelive_hide_cart_btn" id="_goldpricelive_hide_cart_btn"
                           value="1" <?php echo ($goldpricelive_hide_cart_btn) ? "checked" : ""; ?> />
                </p>
                <p class="form-field">
                    <label for="_goldpricelive_fixed_amount"><?php echo __('Fixed Dollar Markup', 'wc_goldpricelive'); ?></label>
                    <input type="text" class="short wc_input_decimal" onkeyup="update_goldpricelive_metabox_fields();"
                           name="goldpricelive_fixed_amount" id="_goldpricelive_fixed_amount"
                           value="<?php echo $goldpricelive_fixed_amount; ?>"/>
                </p>
                <p class="form-field">
                    <label for="_goldpricelive_metal"><?php echo __('Metal', 'wc_goldpricelive'); ?></label>
                    <select class="short" name="goldpricelive_metal" id="_goldpricelive_metal"
                            onchange="update_goldpricelive_price();">
                        <option value="gold" <?php echo ($goldpricelive_metal == "gold") ? 'selected="selected"' : ""; ?>>
                            Gold
                        </option>
                        <option value="silver" <?php echo ($goldpricelive_metal == "silver") ? 'selected="selected"' : ""; ?>>
                            Silver
                        </option>
                        <option value="platinum" <?php echo ($goldpricelive_metal == "platinum") ? 'selected="selected"' : ""; ?>>
                            Platinum
                        </option>
                        <option value="palladium" <?php echo ($goldpricelive_metal == "palladium") ? 'selected="selected"' : ""; ?>>
                            Palladium
                        </option>
                    </select><br/>
                <p id="spot-price"></p>
                </p>
                <p class="form-field">
                    <label for="_goldpricelive_weight"><?php echo __('Weight', 'wc_goldpricelive'); ?></label>
                    <input type="text" class="short wc_input_decimal" onkeyup="update_goldpricelive_metabox_fields();"
                           name="goldpricelive_weight" id="_goldpricelive_weight"
                           value="<?php echo $goldpricelive_weight; ?>"/>
                </p>
                <p class="form-field">
                    <label><?php echo __('Units', 'wc_goldpricelive'); ?></label>
                    <input type="radio" class="short" onclick="update_goldpricelive_price();" name="goldpricelive_units"
                           id="_goldpricelive_gram"
                           value="gram" <?php echo ($goldpricelive_units == "gram") ? 'checked="checked"' : ""; ?> />
                    <label for="_goldpricelive_gram">gram</label>
                    <input type="radio" class="short" onclick="update_goldpricelive_price();" name="goldpricelive_units"
                           id="_goldpricelive_toz"
                           value="toz" <?php echo ($goldpricelive_units == "toz") ? 'checked="checked"' : ""; ?> />
                    <label for="_goldpricelive_toz">troy ounce</label>
                    <input type="radio" class="short" onclick="update_goldpricelive_price();" name="goldpricelive_units"
                           id="_goldpricelive_pw"
                           value="pw" <?php echo ($goldpricelive_units == "pw") ? 'checked="checked"' : ""; ?> /> <label
                            for="_goldpricelive_pw">pennyweight</label>
                </p>
                <p class="form-field">
                    <label for="_goldpricelive_purity"><?php echo __('Purity', 'wc_goldpricelive'); ?></label>
                    <input type="text" class="short wc_input_decimal" onkeyup="update_goldpricelive_metabox_fields();"
                           name="goldpricelive_purity" id="_goldpricelive_purity"
                           value="<?php echo $goldpricelive_purity; ?>"/>
                </p>
                <p class="form-field">
                    <label for="_goldpricelive_markup"><?php echo __('Fixed Markup Percentage', 'wc_goldpricelive'); ?></label>
                    <input type="text" class="short wc_input_decimal" onkeyup="update_goldpricelive_metabox_fields();"
                           name="goldpricelive_markup" id="_goldpricelive_markup"
                           value="<?php echo $goldpricelive_markup; ?>"/>
                </p>
                <p class="form-field">
                    <label for="_goldpricelive_lowest"><?php echo __('Lowest allowed price', 'wc_goldpricelive'); ?></label>
                    <input type="text" class="short wc_input_decimal" onkeyup="update_goldpricelive_metabox_fields();"
                           name="goldpricelive_lowest" id="_goldpricelive_lowest"
                           value="<?php echo $goldpricelive_lowest; ?>"/>
                </p>
                <p class="form-field">
                    <label for="_goldpricelive_buy_back"><?php echo __('Buy Back Percentage Below Spot', 'wc_goldpricelive'); ?></label>
                    <input type="text" class="short wc_input_decimal" onkeyup="update_goldpricelive_metabox_fields();"
                           name="goldpricelive_buy_back" id="_goldpricelive_buy_back"
                           value="<?php echo $goldpricelive_buy_back; ?>"/>
                </p>
                <p class="form-field">
                    <label for="_goldpricelive_buy_back"><?php echo __('Total of Precious Metal Adjustement', 'wc_goldpricelive'); ?></label>
                    <input type="text" class="short" id="_goldpricelive_adjustement" value=""/>
                </p>
                <p class="form-field">
                    <label for="_goldpricelive_buy_back"><?php echo __('Total Product Price with Metal Adjustement', 'wc_goldpricelive'); ?></label>
                    <input type="text" class="short" id="_goldpricelive_price" value=""/>
                    <input type="hidden" name="goldpricelive_price" id="_goldpricelive_price_num" value=""/>
                </p>
                <p class="form-field">
                    <label for="_goldpricelive_buy_back"><?php echo __('Buy Back Price (optional)', 'wc_goldpricelive'); ?></label>
                    <input type="text" class="short" id="_goldpricelive_buy_back_price" value=""/>
                    <input type="hidden" name="goldpricelive_buy_back_price" id="_goldpricelive_buy_back_price_num"
                           value=""/>
                </p>
            </div>
            <!-- LIVE PRICE FIELDS UPDATING -->
            <script>
                var goldpricelive_prices = null;
                var goldpricelive_currency = 'usd';
                var goldpricelive_rounding = {
                    'gold': <?php echo $gold_k; ?>,
                    'silver': <?php echo $silver_k; ?>,
                    'platinum': <?php echo $platinum_k; ?>,
                    'palladium': <?php echo $palladium_k; ?>
                };
                var goldpricelive_decimals = {
                    'gold': <?php echo (int)$this->options["gold_decimal_position"]; ?>,
                    'silver': <?php echo (int)$this->options["silver_decimal_position"]; ?>,
                    'platinum': <?php echo (int)$this->options["platinum_decimal_position"]; ?>,
                    'palladium': <?php echo (int)$this->options["palladium_decimal_position"]; ?>
                };

                function priceInCurrentUnits(price) {
                    var goldpricelive_units_array = document.getElementsByName("goldpricelive_units");
                    var goldpricelive_units = "gram";
                    if (goldpricelive_units_array) {
                        for (var i = 0; i < goldpricelive_units_array.length; i++) {
                            if (goldpricelive_units_array[i].checked) {
                                goldpricelive_units = goldpricelive_units_array[i].value;
                            }
                        }
                    }
                    if (goldpricelive_units === 'toz') {
                        return price;
                    } else if (goldpricelive_units === 'pw') {
                        return price / 20;
                    } else if (goldpricelive_units === 'gram') {
                        return price / 31.1035;
                    }
                }

                function update_goldpricelive_metabox_fields() {
                    if (goldpricelive_prices === null || !goldpricelive_prices) {
                        load_goldpricelive_feed_data();
                    }

                    // get fields data
                    var fixed_amount = document.getElementById("_goldpricelive_fixed_amount").value || 0;
                    var metal = document.getElementById("_goldpricelive_metal").value || "gold";
                    var weight = document.getElementById("_goldpricelive_weight").value || 0;
                    var units_array = document.getElementsByName("goldpricelive_units");
                    var units = "gram";
                    if (units_array) {
                        for (var i = 0; i < units_array.length; i++) {
                            if (units_array[i].checked) {
                                units = units_array[i].value;
                            }
                        }
                    }
                    var purity = document.getElementById("_goldpricelive_purity").value || 0;
                    var markup = document.getElementById("_goldpricelive_markup").value || 0;
                    var lowest = document.getElementById("_goldpricelive_lowest").value || 0;
                    var buy_back = document.getElementById("_goldpricelive_buy_back").value || 0;

                    var price = 0;
                    var adjustement = 0;

                    if (goldpricelive_prices && metal !== "" && weight > 0 && units !== "" && purity > 0 && markup >= 0) {
                        var spot_price = priceInCurrentUnits(goldpricelive_prices[metal]);
                        if (spot_price > 0) {

                            adjustement = parseFloat(spot_price * weight * purity * (1 + (markup / 100)));
                            price = parseFloat(spot_price * weight * purity * (1 + (markup / 100))) + parseFloat(fixed_amount);

                            if (price < lowest) price = parseFloat(lowest);

                            document.getElementById("_goldpricelive_adjustement").value = rg(adjustement, goldpricelive_rounding[metal], goldpricelive_decimals[metal]) + ' ' + goldpricelive_currency.toUpperCase();
                            document.getElementById("_goldpricelive_price").value = rg(price, goldpricelive_rounding[metal], goldpricelive_decimals[metal]) + ' ' + goldpricelive_currency.toUpperCase();
                            document.getElementById("_goldpricelive_price_num").value = price;

                            if (buy_back > 0 && buy_back.length > 0 && !isNaN(buy_back)) {
                                var buy_back_price = parseFloat(price - (price * (parseFloat(buy_back) / 100)));
                                document.getElementById("_goldpricelive_buy_back_price").value = rg(buy_back_price, goldpricelive_rounding[metal], goldpricelive_decimals[metal]) + ' ' + goldpricelive_currency.toUpperCase();
                                document.getElementById("_goldpricelive_buy_back_price_num").value = rg(buy_back_price, goldpricelive_rounding[metal], goldpricelive_decimals[metal]);
                            } else {
                                document.getElementById("_goldpricelive_buy_back_price").value = "";
                                document.getElementById("_goldpricelive_buy_back_price_num").value = "";
                            }
                        }
                    } else {
                        document.getElementById("_goldpricelive_adjustement").value = "";
                        document.getElementById("_goldpricelive_price").value = "";
                        document.getElementById("_goldpricelive_buy_back_price").value = "";
                        document.getElementById("_goldpricelive_price_num").value = "";
                        document.getElementById("_goldpricelive_buy_back_price_num").value = "";
                    }
                }

                function update_goldpricelive_price() {
                    var metal = document.getElementById("_goldpricelive_metal").value || "gold";

                    if (goldpricelive_prices) {
                        document.getElementById('spot-price').innerHTML = 'Current Precious Material Market Price: ' + rg(parseFloat(priceInCurrentUnits(goldpricelive_prices[metal])), goldpricelive_rounding[metal], goldpricelive_decimals[metal]) + ' ' + goldpricelive_currency.toUpperCase();
                        update_goldpricelive_metabox_fields();
                    } else {
                        document.getElementById('spot-price').innerHTML = '';
                        load_goldpricelive_feed_data();
                    }
                }

                function load_goldpricelive_feed_data() {
                    jQuery.post(
                        ajaxurl,
                        {'action': 'goldpricelive_feed'},
                        function (response) {
                            var json = JSON.parse(response);
                            if (json && !json.error) {
                                goldpricelive_prices = {
                                    gold: json.ask['gold'],
                                    silver: json.ask['silver'],
                                    platinum: json.ask['platinum'],
                                    palladium: json.ask['palladium']
                                };
                                goldpricelive_currency = json.currency;
                                update_goldpricelive_price();
                            } else {
                                goldpricelive_prices = false;
                            }
                        }
                    );
                }

                function rg(f, n, d) {
                    return (parseFloat((f * n).toFixed(0)) / n).toFixed(d);
                }

                update_goldpricelive_metabox_fields();
            </script>

            <?php

        }

        public function save_meta_box($post_id)
        {
            if (!(
                isset($_POST['goldpricelive_nonce'])
                && wp_verify_nonce($_POST['goldpricelive_nonce'], basename(__FILE__))
                && current_user_can('edit_post', $post_id)
                && isset($_POST['goldpricelive_post_id'])
                && $_POST['goldpricelive_post_id'] == $post_id
            )
            ) {
                $this->log("[" . date("H:i:m") . "] fake updating for " . $post_id . ", stopped");
                return;
            }

            $fields = array(
                "goldpricelive_fixed_amount",
                "goldpricelive_weight",
                "goldpricelive_metal",
                "goldpricelive_units",
                "goldpricelive_purity",
                "goldpricelive_markup",
                "goldpricelive_lowest",
                "goldpricelive_buy_back"
            );

            foreach ($fields as $field) {
                if (isset($_POST[$field]) && !empty($_POST[$field])) {
                    update_post_meta($post_id, '_' . $field, sanitize_text_field($_POST[$field]));
                } else {
                    if ($field != "goldpricelive_metal" || $field != "goldpricelive_units") {
                        update_post_meta($post_id, '_' . $field, 0);
                    } elseif ($field == "goldpricelive_metal") {
                        update_post_meta($post_id, '_' . $field, "gold");
                    } elseif ($field == "goldpricelive_units") {
                        update_post_meta($post_id, '_' . $field, "gram");
                    }
                }
            }

            if (isset($_POST['goldpricelive_hide_price']) && !empty($_POST['goldpricelive_hide_price'])) {
                update_post_meta($post_id, '_goldpricelive_hide_price', true);
            } else {
                update_post_meta($post_id, '_goldpricelive_hide_price', false);
            }

            if (isset($_POST['goldpricelive_hide_cart_btn']) && !empty($_POST['goldpricelive_hide_cart_btn'])) {
                update_post_meta($post_id, '_goldpricelive_hide_cart_btn', true);
            } else {
                update_post_meta($post_id, '_goldpricelive_hide_cart_btn', false);
            }

            $this->log("[" . date("H:i:m") . "] updated live price settings for " . $post_id);

            //delete_transient('goldpricelive_update_valid');

            if (isset($_POST['goldpricelive_price']) && isset($_POST['goldpricelive_buy_back_price'])) {
                $price = floatval($_POST['goldpricelive_price']);
                $buy_back_price = floatval($_POST['goldpricelive_buy_back_price']);

                if ($price > 0) {

                    $post = get_post($post_id);
                    $pattern = "/([BUY BACK PRICE\:]{1,}) ([\d]{1,}[.]{0,}[\d]{0,}) (USD|CAD|EUR|AUD|GBP|CNY|CHF|NZD|JPY|ZAR|CZK|MYR|SGD)/U";


                    if (isset($buy_back_price) && !is_null($buy_back_price) && $buy_back_price > 0) {

                        $supported_currencies = array('usd', 'cad', 'aud', 'chf', 'eur', 'gbp');
                        $currency = strtolower(get_option('woocommerce_currency'));
                        if (!in_array($currency, $supported_currencies)) $currency = 'usd';
                        if (preg_match($pattern, $post->post_excerpt)) {
                            $short_description = preg_replace($pattern, "$1 " . round($buy_back_price, 2) . " " . strtoupper($currency), $post->post_excerpt);
                        } else {
                            $short_description = "BUY BACK PRICE: " . round($buy_back_price, 2) . " " . strtoupper($currency) . " " . $post->post_excerpt;
                        }
                    } else {
                        $short_description = trim(preg_replace($pattern, "", $post->post_excerpt));
                    }


                    $data = array(
                        "ID" => $post->ID,
                        "post_excerpt" => $short_description
                    );

                    $metal = get_post_meta($post_id, "_goldpricelive_metal", "gold");
                    wp_update_post($data);
                    update_post_meta($post->ID, "_price", strval($this->rounding((float)$price, (float)$this->options[$metal . "_rounding"], $this->options[$metal . "_decimal_position"])));
                    update_post_meta($post->ID, "_regular_price", strval($this->rounding((float)$price, (float)$this->options[$metal . "_rounding"], $this->options[$metal . "_decimal_position"])));


                    $this->log("[" . date("H:i:m") . "] new price for #" . $post->ID);
                }
            }
        }

        public function toz_to_unit($price, $unit)
        {
            switch ($unit) {
                case 'gram':
                    return $price / 31.1035;
                    break;
                case 'pw':
                    return $price / 20;
                    break;
                default:
                    return $price;
            }
        }

        private function market_open()
        {
            $timestamp = current_time('timestamp', true);
            return !((date('N', $timestamp) >= 6) && (date('G', $timestamp) < 10 || (date('G', $timestamp) >= 15 && date('i', $timestamp) >= 0)));
        }

        public function shop_closed()
        {
            global $wpdb, $post, $woocommerce;
            if (is_admin() || $this->market_open() || empty($this->options['close_store']) || $this->options['close_store'] == 'no' || $post->ID == $this->options['page_id']) return;

            $pages = $wpdb->get_results("SELECT option_value FROM " . $wpdb->options . " WHERE option_name LIKE 'woocommerce_%_page_id';", ARRAY_A);
            $wc_pages = array();
            if ($pages) {
                foreach ($pages as $p)
                    if (!empty($p['option_value'])) {
                        $wc_pages[] = $p['option_value'];
                    }
            }

            if ($post->post_type === 'product' || in_array($post->ID, $wc_pages)) {
                if (isset($woocommerce->cart) && !empty($woocommerce->cart)) $woocommerce->cart->empty_cart();
                wp_redirect(get_permalink($this->options['page_id']));
                die;
            }

        }

        public function empty_cart()
        {
            global $woocommerce;
            if (!empty($woocommerce->cart) || count($woocommerce->cart) > 0) $woocommerce->cart->empty_cart();
            die;
        }

        public function empty_cart_timer()
        {
            global $woocommerce;
            $items = $woocommerce->cart->cart_contents;
            if (empty($this->options['empty_cart_timeout']) || empty($this->options['empty_cart_redirect_to']) || empty($items)) return;
            $must_be_empty = false;
            foreach ($items as $item) {
                $metal = get_post_meta($item['data']->post->ID, '_goldpricelive_metal', true);
                if ($metal && in_array($metal, $this->metals)) $must_be_empty = true;
            }
            if (!$must_be_empty) return;
            ?>
            <script>
                var empty_cart_timeout;
                document.addEventListener("DOMContentLoaded", function (event) {
                    empty_cart_timeout = setTimeout(function () {
                        jQuery.post('<?php echo admin_url('admin-ajax.php'); ?>', {action: 'empty_cart'}, function () {
                            window.location = '<?php echo get_permalink($this->options['empty_cart_redirect_to']); ?>';
                        })
                    }, <?php echo(absint($this->options['empty_cart_timeout']) * MINUTE_IN_SECONDS * 1000); ?> )
                });
            </script>
            <?php

        }

        private function log($message)
        {
            if (defined('WP_DEBUG_LOG') && GOLDPRICELIVE_DEBUG)
                $GLOBALS['wp_log']['WC_GoldPriceLive'][] = $message;
        }

    }

    $WC_GoldPriceLive = new WC_GoldPriceLive();

}

class GoldPriceLive
{
    private $realtime_prices = "http://gold-feed.com/paid/zzshdh23klfdl23ldfl234zz/all_metals_json_{currency}.php";
    private $realtime_prices_var = "{currency}";

    private $currencies = array(
        'usd',
        'cad',
        'eur',
        'chf',
        'gbp',
        'nzd',
        'aud',
        'jpy',
        'cny'
    );
    private $shortcodes = array(
        'gold' => array(
            'bid',
            'ask',
            'high',
            'low',
            'dollar_change',
            'percent_change',
            'londonfix_am',
            'londonfix_pm'
        ),
        'silver' => array(
            'bid',
            'ask',
            'high',
            'low',
            'dollar_change',
            'percent_change',
            'londonfix'
        ),
        'platinum' => array(
            'bid',
            'ask',
            'high',
            'low',
            'dollar_change',
            'percent_change',
            'londonfix_am',
            'londonfix_pm'
        ),
        'palladium' => array(
            'bid',
            'ask',
            'high',
            'low',
            'dollar_change',
            'percent_change',
            'londonfix_am',
            'londonfix_pm'
        )
    );
    private $exchange_shortcodes = array(
        'gold' => array(
            'bid',
            'ask',
            'high',
            'low'
        ),
        'silver' => array(
            'bid',
            'ask',
            'high',
            'low'
        ),
        'platinum' => array(
            'bid',
            'ask',
            'high',
            'low'
        ),
        'palladium' => array(
            'bid',
            'ask',
            'high',
            'low'
        )
    );
    private $currency_pairs = array(
        'usdcad',
        'usdeur',
        'usdchf',
        'usdgbp',
        'usdnzd',
        'usdeur',
        'usdaud',
        'usdjpy',
        'usdcny'
    );

    private $gplc_settings = null;
    private $gplc_tabs = array(
        'global' => 'Global Settings',
        'colors' => 'Colors Settings',
        'ff' => 'Font Family Settings',
        'fs' => 'Font Size Settings'
    );
    private $gplc_metals = array(
        'gold',
        'silver',
        'platinum',
        'palladium'
    );
    private $gplc_defaults = array(
        'default_currency' => 'cad',
        'rows' => 5,
        'live' => 1,
        'recaptcha_enabled' => 0,
        'recaptcha_key' => "",
        'recaptcha_secret' => "",
        'main_color' => '#C7A400',
        'footer_color' => '#A38600',
        'text_color' => '#FFFFFF',
        'ff_currency_dropdown' => 'Lato',
        'ff_table_header' => 'Lato',
        'ff_form' => 'Lato',
        'ff_footer' => 'Lato',
        'fs_currency_dropdown' => 14,
        'fs_table_header' => 14,
        'fs_form' => 14,
        'fs_footer' => 14
    );
    private $gplc_fonts = array(
        'Lato',
        'Open Sans',
        'Roboto',
        'Slabo 27px',
        'Oswald',
        'Roboto Condensed',
        'Montserrat',
        'Source Sans Pro',
        'Raleway',
        'Lora',
        'PT Sans',
        'Droid Sans',
        'Open Sans Condensed',
        'Roboto Slab',
        'Ubuntu',
        'Droid Serif',
        'Arimo',
        'Merriweather',
        'Fjalla One',
        'PT Sans Narrow',
        'Noto Sans',
        'PT Serif',
        'Titillium Web',
        'Playfair Display',
        'Alegreya Sans',
        'Poiret One',
        'Indie Flower',
        'Passion One',
        'Candal',
        'Bitter',
        'Cabin',
        'Yanone Kaffeesatz',
        'Dosis',
        'Oxygen',
        'Arvo',
        'Lobster',
        'Inconsolata',
        'Hind',
        'Abel',
        'Anton',
        'Noto Serif',
        'Nunito',
        'Muli',
        'Bree Serif',
        'Josefin Sans',
        'Ubuntu Condensed',
        'Exo 2',
        'Libre Baskerville',
        'Pacifico',
        'Shadows Into Light'
    );
    private $gplc_currencies = array(
        'usd',
        'cad',
        'eur',
        'chf',
        'gbp'
    );

    public $options = array(
        "shortcodes_enabled" => TRUE,
        "live_shortcodes_enabled" => TRUE,
        "color_disabled" => FALSE,
        "shortcodes_animation_enabled" => TRUE,
        "live_price_enabled" => TRUE,
        "remove_featured_image_enabled" => FALSE,
        "live_product_shortcodes_enabled" => TRUE,
        "product_shortcodes_animation_enabled" => TRUE,
        "gold_decimal_position" => 2,
        "gold_rounding" => 0.01,
        "silver_decimal_position" => 2,
        "silver_rounding" => 0.01,
        "platinum_decimal_position" => 2,
        "platinum_rounding" => 0.01,
        "palladium_decimal_position" => 2,
        "palladium_rounding" => 0.01,
        "close_store" => FALSE,
        "page_id" => NULL,
        "empty_cart_timeout" => NULL,
        "empty_cart_redirect_to" => NULL
    );
    public $defaults = array(
        'shortcodes_enabled' => 1,
        'live_shortcodes_enabled' => 1,
        'color_disabled' => 0,
        'shortcodes_animation_enabled' => 1,
        'live_price_enabled' => 1,
        'remove_featured_image_enabled' => 0,
        'live_product_shortcodes_enabled' => 1,
        'product_shortcodes_animation_enabled' => 1
    );

    public $prices_json = array();

    public function __construct()
    {
        add_action('wp_loaded', array($this, 'init'));
    }

    public function init()
    {
        $this->options = array_merge($this->options, get_option('gold_price_live_settings'));

        add_action('admin_notices', array($this, 'gold_price_live_activation_notice'));
        add_action('admin_init', array($this, 'gold_price_live_plugin_redirect'));
        add_action('admin_menu', array($this, 'gold_price_live_admin_actions'));
        add_action('admin_menu', array($this, 'gplc_admin_actions'));

        add_shortcode('gpl_calculator', array($this, 'gplc_shortcode'));
        add_action('wp_ajax_gplc', array($this, 'gplc_ajax'));
        add_action('wp_ajax_nopriv_gplc', array($this, 'gplc_ajax'));
        add_action('wp_ajax_gplc_data', array($this, 'gplc_data_ajax'));
        add_action('wp_ajax_nopriv_gplc_data', array($this, 'gplc_data_ajax'));

        if (isset($this->options['shortcodes_enabled']) && $this->options['shortcodes_enabled']) {
            foreach ($this->shortcodes as $metal => $types) {
                foreach ($types as $type) {
                    add_shortcode($metal . '_' . $type, array($this, 'get_simple_shortcode'));
                }
            }
            foreach ($this->exchange_shortcodes as $metal => $types) {
                foreach ($types as $type) {
                    foreach ($this->currencies as $currency) {
                        add_shortcode($metal . '_' . $type . '_' . $currency, array($this, 'get_exchange_shortcode'));
                    }
                }
            }
            add_filter('widget_text', 'do_shortcode');
        }

        if (isset($this->options['live_shortcodes_enabled']) && $this->options['live_shortcodes_enabled']) {
            add_action('wp_enqueue_scripts', array($this, 'live_shortcodes_js'));
            add_action('wp_ajax_live_shortcodes', array($this, 'live_shortcodes_callback'));
            add_action('wp_ajax_nopriv_live_shortcodes', array($this, 'live_shortcodes_callback'));
            add_action('wp_ajax_live_ex_shortcodes', array($this, 'live_ex_shortcodes_callback'));
            add_action('wp_ajax_nopriv_live_ex_shortcodes', array($this, 'live_ex_shortcodes_callback'));
        }

        if (isset($this->options['shortcodes_animation_enabled']) && $this->options['shortcodes_animation_enabled']) {
            add_action('wp_enqueue_scripts', array($this, 'shortcodes_animation_js'));
        }
        add_action('wp_enqueue_scripts', array($this, 'shortcodes_animation_css'));

        add_action('wp_enqueue_scripts', array($this, 'update_cache_js'));
        add_action('admin_enqueue_scripts', array($this, 'update_cache_js'));
        add_action('wp_ajax_goldpricelive_update_cache', array($this, 'goldpricelive_update_cache_callback'));
        add_action('wp_ajax_nopriv_goldpricelive_update_cache', array($this, 'goldpricelive_update_cache_callback'));


        /* running prices cache when transient expire
        //delete_transient('goldpricelive_price_cache_valid'); //FOR DEBUGGING
        if (get_transient('goldpricelive_price_cache_valid')) return;
        set_transient('goldpricelive_price_cache_valid', 1, 30);
        $this->update_prices_cache();
        */
    }

    public function update_cache_js()
    {
        wp_register_script('goldpricelive_update_cache', plugin_dir_url(__FILE__) . '/js/goldpricelive_update_cache.js', array('jquery'));
        wp_localize_script('goldpricelive_update_cache', 'goldpricelive_update_cache_parameters', array('ajaxurl' => admin_url('admin-ajax.php')));
        wp_enqueue_script('goldpricelive_update_cache');
    }

    public function goldpricelive_update_cache_callback()
    {
        $response = array(
            "success" => FALSE
        );
        if (!get_transient('goldpricelive_price_cache_valid') || (int)get_transient('goldpricelive_price_cache_valid') < (time() - 300)) {
            set_transient('goldpricelive_price_cache_valid', time(), 30);
            $response["success"] = $this->update_prices_cache();
            $response['message'] = "Data Reloaded";
        } else
            $response['message'] = "Data Still Valid: " . get_transient('goldpricelive_price_cache_valid');

        header("Content-Type: application/json");
        echo json_encode($response);
        exit();
    }

    public function update_prices_cache()
    {
        $pending = array();
        foreach ($this->currencies as $currency) {

            $prices_cache = get_option("gpl_prices_cache_" . $currency, FALSE);
            if ($prices_cache && isset($prices_cache['gpl_load_timestamp']) && $prices_cache['gpl_load_timestamp'] > (time() - 60)) {
                $pending[$currency] = time() - $prices_cache['gpl_load_timestamp'];
            } elseif ($prices_cache && isset($prices_cache['gpl_load_timestamp'])) {
                $pending[$currency] = 2;
            } else {
                $pending[$currency] = 1;
            }
        }

        asort($pending);
        $updated = 0;

        foreach ($pending as $currency => $priority) {
            if ($priority > 2 && $updated >= 1)
                break;

            if (get_transient('goldpricelive_price_cache_updating_' . $currency))
                continue;


            set_transient('goldpricelive_price_cache_updating_' . $currency, 1, 30);

            if (in_array($currency, $this->currencies)) {
                $raw = $this->get_contents(str_replace($this->realtime_prices_var, $currency, $this->realtime_prices));
                if ($raw) {
                    $json = json_decode($raw, TRUE);
                    if ($json) {

                        $this->log("Updating price for " . $currency);
                        $json['gpl_load_timestamp'] = time();
                        update_option("gpl_prices_cache_" . $currency, $json);
                        $updated++;
                    }
                }
            }
        }

        return TRUE;
    }

    public function shortcodes_animation_js()
    {
        wp_register_script('shortcodes_animation', plugin_dir_url(__FILE__) . '/js/shortcodes_animation.js', array('jquery'));
        wp_enqueue_script('shortcodes_animation');
        wp_register_script('jquery_cycle', plugin_dir_url(__FILE__) . '/js/jquery.cycle.all.js', array('jquery'));
        wp_enqueue_script('jquery_cycle');
    }

    public function shortcodes_animation_css()
    {
        wp_register_style('shortcodes_animation', plugin_dir_url(__FILE__) . '/css/shortcodes_animation.css', array());
        wp_enqueue_style('shortcodes_animation');
    }

    public function live_shortcodes_js()
    {
        wp_register_script('live_shortcodes', plugin_dir_url(__FILE__) . '/js/live_shortcodes.js', array('jquery'));
        wp_localize_script('live_shortcodes', 'live_shortcodes_parameters', array('ajaxurl' => admin_url('admin-ajax.php')));
        wp_enqueue_script('live_shortcodes');
    }

    public function live_shortcodes_callback()
    {
        $response = array("error" => false);
        $supported_currencies = array('usd', 'cad', 'aud', 'chf', 'eur', 'gbp');
        $required_currencies = array();
        if (isset($_GET['currencies']) && is_array($_GET['currencies']) && count(array_intersect($_GET['currencies'], $supported_currencies)) == count($_GET['currencies'])) {
            $required_currencies = $_GET['currencies'];
        }

        if (count($required_currencies) == 0) {
            $currency = strtolower(get_option('woocommerce_currency'));
            if (!in_array($currency, $supported_currencies)) $currency = 'usd';
            $required_currencies[] = $currency;
        }

        foreach ($required_currencies as $currency) {

            $prices_cache = get_option("gpl_prices_cache_" . $currency, FALSE);
            if (!$prices_cache || !isset($prices_cache['gpl_load_timestamp'])) {
                $response['error'] = 'Server Error. Please try again in few minutes.';
            } else {
                $response[$currency]['bid']['gold'] = floatval($prices_cache["gold_bid_" . $currency . "_toz"]);
                $response[$currency]['bid']['silver'] = floatval($prices_cache["silver_bid_" . $currency . "_toz"]);
                $response[$currency]['bid']['platinum'] = floatval($prices_cache["platinum_bid_" . $currency . "_toz"]);
                $response[$currency]['bid']['palladium'] = floatval($prices_cache["palladium_bid_" . $currency . "_toz"]);

                $response[$currency]['ask']['gold'] = floatval($prices_cache["gold_ask_" . $currency . "_toz"]);
                $response[$currency]['ask']['silver'] = floatval($prices_cache["silver_ask_" . $currency . "_toz"]);
                $response[$currency]['ask']['platinum'] = floatval($prices_cache["platinum_ask_" . $currency . "_toz"]);
                $response[$currency]['ask']['palladium'] = floatval($prices_cache["palladium_ask_" . $currency . "_toz"]);

                $response[$currency]['change_dollar']['gold'] = floatval($prices_cache["gold_change_dollar_" . $currency . "_toz"]);
                $response[$currency]['change_dollar']['silver'] = floatval($prices_cache["silver_change_dollar_" . $currency . "_toz"]);
                $response[$currency]['change_dollar']['platinum'] = floatval($prices_cache["platinum_change_dollar_" . $currency . "_toz"]);
                $response[$currency]['change_dollar']['palladium'] = floatval($prices_cache["palladium_change_dollar_" . $currency . "_toz"]);

                $response[$currency]['change_percent']['gold'] = floatval($prices_cache["gold_change_percent_" . $currency . "_toz"]);
                $response[$currency]['change_percent']['silver'] = floatval($prices_cache["silver_change_percent_" . $currency . "_toz"]);
                $response[$currency]['change_percent']['platinum'] = floatval($prices_cache["platinum_change_percent_" . $currency . "_toz"]);
                $response[$currency]['change_percent']['palladium'] = floatval($prices_cache["palladium_change_percent_" . $currency . "_toz"]);

                $response[$currency]['high']['gold'] = floatval($prices_cache["gold_high_" . $currency . "_toz"]);
                $response[$currency]['high']['silver'] = floatval($prices_cache["silver_high_" . $currency . "_toz"]);
                $response[$currency]['high']['platinum'] = floatval($prices_cache["platinum_high_" . $currency . "_toz"]);
                $response[$currency]['high']['palladium'] = floatval($prices_cache["palladium_high_" . $currency . "_toz"]);

                $response[$currency]['low']['gold'] = floatval($prices_cache["gold_low_" . $currency . "_toz"]);
                $response[$currency]['low']['silver'] = floatval($prices_cache["silver_low_" . $currency . "_toz"]);
                $response[$currency]['low']['platinum'] = floatval($prices_cache["platinum_low_" . $currency . "_toz"]);
                $response[$currency]['low']['palladium'] = floatval($prices_cache["palladium_low_" . $currency . "_toz"]);

                $response[$currency]['londonfix_am']['gold'] = floatval($prices_cache["gold_londonfix_am"]);
                $response[$currency]['londonfix_am']['platinum'] = floatval($prices_cache["platinum_londonfix_am"]);
                $response[$currency]['londonfix_am']['palladium'] = floatval($prices_cache["palladium_londonfix_am"]);

                $response[$currency]['londonfix_pm']['gold'] = floatval($prices_cache["gold_londonfix_pm"]);
                $response[$currency]['londonfix_pm']['platinum'] = floatval($prices_cache["platinum_londonfix_pm"]);
                $response[$currency]['londonfix_pm']['palladium'] = floatval($prices_cache["palladium_londonfix_pm"]);

                $response[$currency]['londonfix']['silver'] = floatval($prices_cache["silver_londonfix"]);
            }
        }


        echo json_encode($response);

        wp_die();
    }

    public function live_ex_shortcodes_callback()
    {
        $response = array("error" => false);
        $required_currencies = array();
        if (isset($_GET['currencies']) && is_array($_GET['currencies']) && count(array_intersect($_GET['currencies'], $this->currencies)) == count($_GET['currencies'])) {
            $required_currencies = $_GET['currencies'];
        }

        if (count($required_currencies) == 0) {
            $currency = strtolower(get_option('woocommerce_currency'));
            if (!in_array($currency, $this->currencies)) $currency = 'usd';
            $required_currencies[] = $currency;
        }

        foreach ($required_currencies as $currency) {
            $prices_cache = get_option("gpl_prices_cache_" . $currency, FALSE);
            if (!$prices_cache || !isset($prices_cache['gpl_load_timestamp'])) {
                $response['error'] = 'Server Error. Please try again in few minutes.';
            } else {
                $response[$currency]['bid']['gold'] = floatval($prices_cache["gold_bid_" . $currency . "_toz"]);
                $response[$currency]['bid']['silver'] = floatval($prices_cache["silver_bid_" . $currency . "_toz"]);
                $response[$currency]['bid']['platinum'] = floatval($prices_cache["platinum_bid_" . $currency . "_toz"]);
                $response[$currency]['bid']['palladium'] = floatval($prices_cache["palladium_bid_" . $currency . "_toz"]);

                $response[$currency]['ask']['gold'] = floatval($prices_cache["gold_ask_" . $currency . "_toz"]);
                $response[$currency]['ask']['silver'] = floatval($prices_cache["silver_ask_" . $currency . "_toz"]);
                $response[$currency]['ask']['platinum'] = floatval($prices_cache["platinum_ask_" . $currency . "_toz"]);
                $response[$currency]['ask']['palladium'] = floatval($prices_cache["palladium_ask_" . $currency . "_toz"]);

                $response[$currency]['high']['gold'] = floatval($prices_cache["gold_high_" . $currency . "_toz"]);
                $response[$currency]['high']['silver'] = floatval($prices_cache["silver_high_" . $currency . "_toz"]);
                $response[$currency]['high']['platinum'] = floatval($prices_cache["platinum_high_" . $currency . "_toz"]);
                $response[$currency]['high']['palladium'] = floatval($prices_cache["palladium_high_" . $currency . "_toz"]);

                $response[$currency]['low']['gold'] = floatval($prices_cache["gold_low_" . $currency . "_toz"]);
                $response[$currency]['low']['silver'] = floatval($prices_cache["silver_low_" . $currency . "_toz"]);
                $response[$currency]['low']['platinum'] = floatval($prices_cache["platinum_low_" . $currency . "_toz"]);
                $response[$currency]['low']['palladium'] = floatval($prices_cache["palladium_low_" . $currency . "_toz"]);

                if ($currency == "usd") {
                    foreach ($this->currency_pairs as $pair) {
                        $response[$pair] = $prices_cache[$pair];
                    }
                }
            }
        }


        echo json_encode($response);

        wp_die();
    }

    public function gplc_ajax()
    {
        $response = array("error" => false);

        if (isset($_GET['currency']) && in_array($_GET['currency'], $this->gplc_currencies)) {
            $currency = $_GET['currency'];
        } else {
            $currency = 'usd';
        }

        $prices_cache = get_option("gpl_prices_cache_" . $currency, FALSE);
        if (!$prices_cache || !isset($prices_cache['gpl_load_timestamp'])) {
            $response['error'] = 'Server Error. Please try again in few minutes.';
        } else {
            $response[$currency]['gold'] = floatval($prices_cache["gold_bid_" . $currency . "_toz"]);
            $response[$currency]['silver'] = floatval($prices_cache["silver_bid_" . $currency . "_toz"]);
            $response[$currency]['platinum'] = floatval($prices_cache["platinum_bid_" . $currency . "_toz"]);
            $response[$currency]['palladium'] = floatval($prices_cache["palladium_bid_" . $currency . "_toz"]);
        }

        echo json_encode($response);

        wp_die();
    }

    public function gplc_data_ajax()
    {
        $response = array("error" => false);

        if (isset($_POST['form']) && is_array($_POST['form']) && isset($_POST['form']['rows']) && count($_POST['form']['rows']) > 0) {
            $form = array();
            $form['name'] = trim(htmlspecialchars($_POST['form']['name']));
            $form['company'] = trim(htmlspecialchars($_POST['form']['company']));
            $form['email'] = trim(htmlspecialchars($_POST['form']['email']));
            $form['phone'] = trim(htmlspecialchars($_POST['form']['phone']));
            $form['currency'] = trim(htmlspecialchars($_POST['form']['currency']));
            $form['rows'] = array();

            include plugin_dir_path(__FILE__) . 'src/autoload.php';
            $options = (get_option('gplc_settings')) ? array_merge($this->gplc_defaults, get_option('gplc_settings')) : $this->gplc_defaults;

            $recaptcha = new \ReCaptcha\ReCaptcha($options['recaptcha_secret']);
            $resp = $recaptcha->verify($_POST['form']['captcha'], $_SERVER['REMOTE_ADDR']);
            if (!$options['recaptcha_enabled'] || empty($options['recaptcha_secret']) || $resp->isSuccess()) {


                foreach ($_POST['form']['rows'] as $row) {
                    if (!empty($row['weight']) && $row['weight'] > 0) {
                        if ($row['unit'] == 'g') {
                            $row['metal_price'] = $row['metal_price'] / 31.1035;
                        } elseif ($row['unit'] == 'pw') {
                            $row['metal_price'] = $row['metal_price'] / 20;
                        }

                        $form['rows'][] = array(
                            'metal' => trim(htmlspecialchars($row['metal'])),
                            'metal_price' => floatval($row['metal_price']),
                            'weight' => floatval($row['weight']),
                            'unit' => trim(htmlspecialchars($row['unit'])),
                            'purity' => floatval($row['purity']),
                            'purity100' => floatval($row['purity100'])
                        );
                    }
                }

                /* Email to Customer */
                $email_body = "<html>" .
                    "<header>" .
                    "<style>" .
                    "table { border-collapse: collapse; border: 1px solid black; width: 100%}" .
                    "table td {border: 1px solid black;}" .
                    "</style>" .
                    "</header>" .
                    "<body>" .
                    "<h3>Dear customer,</h3>" .
                    "<div>Your data from calculator successfully received.</div>" .
                    "<hr/><div><table>" .
                    "<tr><td colspan='3'>Name</td><td colspan='3'>" . $form['name'] . "</td></tr>" .
                    "<tr><td colspan='3'>Company</td><td colspan='3'>" . $form['company'] . "</td></tr>" .
                    "<tr><td colspan='3'>Email</td><td colspan='3'>" . $form['email'] . "</td></tr>" .
                    "<tr><td colspan='3'>Phone</td><td colspan='3'>" . $form['phone'] . "</td></tr>" .
                    "<tr><td>Metal</td><td>Metal Price</td><td>Weight</td><td>Unit</td><td>Purity</td><td>Value</td></tr>";

                foreach ($form['rows'] as $row) {
                    $email_body .= "<tr><td>" .
                        ucfirst($row['metal']) .
                        "</td><td>" .
                        round($row['metal_price'], 2) . " " . strtoupper($form['currency']) .
                        "</td><td>" .
                        $row['weight'] .
                        "</td><td>" .
                        $row['unit'] .
                        "</td><td>" .
                        $row['purity'] .
                        "</td><td>" .
                        round(($row['metal_price'] * $row['weight'] * ($row['purity'] / $row['purity100'])), 2) . " " . strtoupper($form['currency']) .
                        "</td></tr>";
                }

                $email_body .= "</table></div><hr/>" .
                    "<div>Thank you for using our services</div>" .
                    "</body>" .
                    "</html>";
                $headers = array('From: ' . get_bloginfo('name') . ' <' . get_option('admin_email') . '>');

                add_filter('wp_mail_content_type', array($this, 'wpdocs_set_html_mail_content_type'));
                wp_mail($form['email'], "Your data successfully received", $email_body, $headers);
                remove_filter('wp_mail_content_type', array($this, 'wpdocs_set_html_mail_content_type'));

                /* Email to admin */

                $email_body = "<html>" .
                    "<header>" .
                    "<style>" .
                    "table { border-collapse: collapse; border: 1px solid black; width: 100%}" .
                    "table td {border: 1px solid black;}" .
                    "</style>" .
                    "</header>" .
                    "<body>" .
                    "<h3>Dear Administrator,</h3>" .
                    "<div>New data received from GPL Calculator.</div>" .
                    "<hr/><div><table>" .
                    "<tr><td colspan='3'>Name</td><td colspan='3'>" . $form['name'] . "</td></tr>" .
                    "<tr><td colspan='3'>Company</td><td colspan='3'>" . $form['company'] . "</td></tr>" .
                    "<tr><td colspan='3'>Email</td><td colspan='3'>" . $form['email'] . "</td></tr>" .
                    "<tr><td colspan='3'>Phone</td><td colspan='3'>" . $form['phone'] . "</td></tr>" .
                    "<tr><td>Metal</td><td>Metal Price</td><td>Weight</td><td>Unit</td><td>Purity</td><td>Value</td></tr>";

                foreach ($form['rows'] as $row) {
                    $email_body .= "<tr><td>" .
                        ucfirst($row['metal']) .
                        "</td><td>" .
                        round($row['metal_price'], 2) . " " . strtoupper($form['currency']) .
                        "</td><td>" .
                        $row['weight'] .
                        "</td><td>" .
                        $row['unit'] .
                        "</td><td>" .
                        $row['purity'] .
                        "</td><td>" .
                        round(($row['metal_price'] * $row['weight'] * ($row['purity'] / $row['purity100'])), 2) . " " . strtoupper($form['currency']) .
                        "</td></tr>";
                }

                $email_body .= "</table></div><hr/>" .
                    "<div>Thank you for using our services</div>" .
                    "</body>" .
                    "</html>";
                $headers = array('From: ' . get_bloginfo('name') . ' <' . get_option('admin_email') . '>');

                add_filter('wp_mail_content_type', array($this, 'wpdocs_set_html_mail_content_type'));
                wp_mail(get_option('admin_email'), "New data received from GPL Calculator", $email_body, $headers);
                remove_filter('wp_mail_content_type', array($this, 'wpdocs_set_html_mail_content_type'));

                $response['success'] = "Your inquiry has been successfully received";
            } else {
                $response['error'] = "Invalid request";
            }
        } else {
            $response['error'] = "Wrong data received";
        }

        echo json_encode($response);

        wp_die();
    }

    public function wpdocs_set_html_mail_content_type()
    {
        return 'text/html';
    }

    private function get_price($type, $currency)
    {
        if (!array_key_exists($currency, $this->prices_json) || !$this->prices_json[$currency]) {
            $this->prices_json[$currency] = get_option("gpl_prices_cache_" . $currency, FALSE);
        }
        return $this->prices_json[$currency][(preg_match("/\_londonfix/", $type) || in_array($type, $this->currency_pairs)) ? $type : $type . '_' . $currency . '_toz'];
    }

    private function toz_to_grams($toz_price)
    {
        return $toz_price / 31.1035;
    }

    private function toz_to_pw($toz_price)
    {
        return $toz_price / 20;
    }

    function rounding($number, $nearest, $decimals, $dec_point = ".", $thousands_sep = "")
    {
        switch ($nearest) {
            case 0.1:
                $k = 10;
                break;
            case 0.5:
                $k = 2;
                break;
            case 0.05:
                $k = 20;
                break;
            case 0.001:
                $k = 1000;
                break;
            case 0.005:
                $k = 200;
                break;
            case 0.01:
            default:
                $k = 100;
                break;
        }
        return number_format(round($number * $k, 0) / $k, $decimals, $dec_point, $thousands_sep);
    }

    private function decimals($price, $metal, $symbol = "")
    {

        return $this->rounding((float)$price, (float)$this->options[$metal . "_rounding"], $this->options[$metal . "_decimal_position"]) . $symbol;
    }

    public function gold_price_live_plugin_activate()
    {
        $options = get_option('gold_price_live_settings');
        if (!$options) {
            add_option('gold_price_live_settings', $this->defaults);
        } else {
            update_option('gold_price_live_settings', $this->defaults);
        }
        set_transient('gold_price_live_notice', true, 5);
    }

    public function gold_price_live_activation_notice()
    {
        if (get_transient('gold_price_live_notice')) {
            ?>
            <div class="updated notice is-dismissible">
                <p>Thank you for activating <strong>Gold Price Live</strong>. Please <a
                            href="<?php echo admin_url("options-general.php?page=Gold+Price+Live"); ?>">click here</a>
                    to go to the settings page to enable/disable live pricing and shortcodes.</p>
            </div>
            <?php
            delete_transient('gold_price_live_notice');
        }
    }

    public function gold_price_live_plugin_redirect()
    {
        register_setting(
            'gold_price_live_group',
            'gold_price_live_settings',
            array($this, 'sanitize')
        );

        add_settings_section(
            'gold_price_live_settings_section_id',
            'Plugin Settings',
            array($this, 'print_section_info'),
            'gold_price_live_settings_section'
        );

        add_settings_field(
            'shortcodes_enabled',
            'Shortcodes Enabled',
            array($this, 'shortcodes_enabled_callback'),
            'gold_price_live_settings_section',
            'gold_price_live_settings_section_id'
        );

        add_settings_field(
            'live_shortcodes_enabled',
            'Live Shortcodes Enabled',
            array($this, 'live_shortcodes_enabled_callback'),
            'gold_price_live_settings_section',
            'gold_price_live_settings_section_id'
        );

        add_settings_field(
            'color_disabled',
            'Disable Color Change in Animations',
            array($this, 'color_disabled_callback'),
            'gold_price_live_settings_section',
            'gold_price_live_settings_section_id'
        );

        add_settings_field(
            'shortcodes_animation_enabled',
            'Shortcodes Animation Enabled',
            array($this, 'shortcodes_animation_enabled_callback'),
            'gold_price_live_settings_section',
            'gold_price_live_settings_section_id'
        );

        if (in_array('woocommerce/woocommerce.php', apply_filters('active_plugins', get_option('active_plugins')))) {
            add_settings_field(
                'live_price_enabled',
                'Live Price Enabled',
                array($this, 'live_price_enabled_callback'),
                'gold_price_live_settings_section',
                'gold_price_live_settings_section_id'
            );

            add_settings_field(
                'remove_featured_image_enabled',
                'Remove Featured Image',
                array($this, 'remove_featured_image_enabled_callback'),
                'gold_price_live_settings_section',
                'gold_price_live_settings_section_id'
            );

            add_settings_field(
                'live_product_shortcodes_enabled',
                'Live Product Shortcodes Enabled',
                array($this, 'live_product_shortcodes_enabled_callback'),
                'gold_price_live_settings_section',
                'gold_price_live_settings_section_id'
            );

            add_settings_field(
                'product_shortcodes_animation_enabled',
                'Product Shortcodes Animation Enabled',
                array($this, 'product_shortcodes_animation_enabled_callback'),
                'gold_price_live_settings_section',
                'gold_price_live_settings_section_id'
            );
        }

        add_settings_field(
            'gold_decimal_position',
            'Decimal Position for Gold',
            array($this, 'gold_decimal_position_callback'),
            'gold_price_live_settings_section',
            'gold_price_live_settings_section_id'
        );

        add_settings_field(
            'gold_rounding',
            'Rounding to Nearest for Gold',
            array($this, 'gold_rounding_callback'),
            'gold_price_live_settings_section',
            'gold_price_live_settings_section_id'
        );

        add_settings_field(
            'silver_decimal_position',
            'Decimal Position for Silver',
            array($this, 'silver_decimal_position_callback'),
            'gold_price_live_settings_section',
            'gold_price_live_settings_section_id'
        );

        add_settings_field(
            'silver_rounding',
            'Rounding to Nearest for Silver',
            array($this, 'silver_rounding_callback'),
            'gold_price_live_settings_section',
            'gold_price_live_settings_section_id'
        );

        add_settings_field(
            'platinum_decimal_position',
            'Decimal Position for Platinum',
            array($this, 'platinum_decimal_position_callback'),
            'gold_price_live_settings_section',
            'gold_price_live_settings_section_id'
        );

        add_settings_field(
            'platinum_rounding',
            'Rounding to Nearest for Platinum',
            array($this, 'platinum_rounding_callback'),
            'gold_price_live_settings_section',
            'gold_price_live_settings_section_id'
        );

        add_settings_field(
            'palladium_decimal_position',
            'Decimal Position for Palladium',
            array($this, 'palladium_decimal_position_callback'),
            'gold_price_live_settings_section',
            'gold_price_live_settings_section_id'
        );

        add_settings_field(
            'palladium_rounding',
            'Rounding to Nearest for Palladium',
            array($this, 'palladium_rounding_callback'),
            'gold_price_live_settings_section',
            'gold_price_live_settings_section_id'
        );

        add_settings_field(
            'close_store',
            'Market Closed',
            array($this, 'close_store_callback'),
            'gold_price_live_settings_section',
            'gold_price_live_settings_section_id'
        );

        add_settings_field(
            'close_store',
            'Market Closed',
            array($this, 'close_store_callback'),
            'gold_price_live_settings_section',
            'gold_price_live_settings_section_id'
        );

        add_settings_field(
            'page_id',
            'Default Shop Closed Redirect',
            array($this, 'page_id_callback'),
            'gold_price_live_settings_section',
            'gold_price_live_settings_section_id'
        );

        add_settings_field(
            'empty_cart_timeout',
            'Empty Cart Timer (minutes)',
            array($this, 'empty_cart_timeout_callback'),
            'gold_price_live_settings_section',
            'gold_price_live_settings_section_id'
        );

        add_settings_field(
            'empty_cart_redirect_to',
            'Empty Cart Redirect',
            array($this, 'empty_cart_redirect_to_callback'),
            'gold_price_live_settings_section',
            'gold_price_live_settings_section_id'
        );

        /* Calculator */

        register_setting(
            'gpl_calculator',
            'gplc_settings',
            array($this, 'gplc_sanitize')
        );

        /* Global */
        add_settings_section(
            'gplc_global',
            'Global Settings',
            array($this, 'gplc_global_info'),
            'gplc_global_section'
        );

        add_settings_field(
            'default_currency',
            'Default Currency',
            array($this, 'gplc_default_currency'),
            'gplc_global_section',
            'gplc_global'
        );

        add_settings_field(
            'live',
            'Enable Live Refreshing',
            array($this, 'gplc_live'),
            'gplc_global_section',
            'gplc_global'
        );

        add_settings_field(
            'rows',
            'Number of Rows',
            array($this, 'gplc_rows'),
            'gplc_global_section',
            'gplc_global'
        );

        add_settings_field(
            'recaptcha_enabled',
            'Enable reCaptcha',
            array($this, 'gplc_recaptcha_enabled'),
            'gplc_global_section',
            'gplc_global'
        );

        add_settings_field(
            'recaptcha_key',
            'reCaptcha Key',
            array($this, 'gplc_recaptcha_key'),
            'gplc_global_section',
            'gplc_global'
        );

        add_settings_field(
            'recaptcha_secret',
            'reCaptcha Secret',
            array($this, 'gplc_recaptcha_secret'),
            'gplc_global_section',
            'gplc_global'
        );

        /* Colors */
        add_settings_section(
            'gplc_colors',
            'Color Settings',
            array($this, 'gplc_colors_info'),
            'gplc_colors_section'
        );

        add_settings_field(
            'main_color',
            'Main Color',
            array($this, 'gplc_main_color'),
            'gplc_colors_section',
            'gplc_colors'
        );

        add_settings_field(
            'footer_color',
            'Footer Color',
            array($this, 'gplc_footer_color'),
            'gplc_colors_section',
            'gplc_colors'
        );

        add_settings_field(
            'text_color',
            'Text Color',
            array($this, 'gplc_text_color'),
            'gplc_colors_section',
            'gplc_colors'
        );

        /* Font families */

        add_settings_section(
            'gplc_ff',
            'Font Family Settings',
            array($this, 'gplc_ff_info'),
            'gplc_ff_section'
        );

        add_settings_field(
            'ff_currency_dropdown',
            'Currency Dropdown',
            array($this, 'gplc_ff_currency_dropdown'),
            'gplc_ff_section',
            'gplc_ff'
        );

        add_settings_field(
            'ff_table_header',
            'Table Header',
            array($this, 'gplc_ff_table_header'),
            'gplc_ff_section',
            'gplc_ff'
        );

        add_settings_field(
            'ff_form',
            'Form',
            array($this, 'gplc_ff_form'),
            'gplc_ff_section',
            'gplc_ff'
        );

        add_settings_field(
            'ff_footer',
            'Footer',
            array($this, 'gplc_ff_footer'),
            'gplc_ff_section',
            'gplc_ff'
        );

        /* Font sizes */

        add_settings_section(
            'gplc_fs',
            'Font Family Settings',
            array($this, 'gplc_fs_info'),
            'gplc_fs_section'
        );

        add_settings_field(
            'fs_currency_dropdown',
            'Currency Dropdown',
            array($this, 'gplc_fs_currency_dropdown'),
            'gplc_fs_section',
            'gplc_fs'
        );

        add_settings_field(
            'fs_table_header',
            'Table Header',
            array($this, 'gplc_fs_table_header'),
            'gplc_fs_section',
            'gplc_fs'
        );

        add_settings_field(
            'fs_form',
            'Form',
            array($this, 'gplc_fs_form'),
            'gplc_fs_section',
            'gplc_fs'
        );

        add_settings_field(
            'fs_footer',
            'Footer',
            array($this, 'gplc_fs_footer'),
            'gplc_fs_section',
            'gplc_fs'
        );

        /*
        if (get_option('gold_price_live_do_activation_redirect', false)) {
            delete_option('gold_price_live_do_activation_redirect');

            wp_redirect( 'options-general.php?page=Gold_Price_Live');
        }
        */
    }


    public function sanitize($input)
    {
        $new_input = array();
        if (isset($input['shortcodes_enabled']))
            $new_input['shortcodes_enabled'] = absint($input['shortcodes_enabled']);
        else
            $new_input['shortcodes_enabled'] = 0;

        if (isset($input['live_shortcodes_enabled']))
            $new_input['live_shortcodes_enabled'] = absint($input['live_shortcodes_enabled']);
        else
            $new_input['live_shortcodes_enabled'] = 0;

        if (isset($input['color_disabled']))
            $new_input['color_disabled'] = absint($input['color_disabled']);
        else
            $new_input['color_disabled'] = 0;

        if (isset($input['shortcodes_animation_enabled']))
            $new_input['shortcodes_animation_enabled'] = absint($input['shortcodes_animation_enabled']);
        else
            $new_input['shortcodes_animation_enabled'] = 0;

        if (in_array('woocommerce/woocommerce.php', apply_filters('active_plugins', get_option('active_plugins')))) {
            if (isset($input['live_price_enabled']))
                $new_input['live_price_enabled'] = absint($input['live_price_enabled']);
            else
                $new_input['live_price_enabled'] = 0;
        }
        if (in_array('woocommerce/woocommerce.php', apply_filters('active_plugins', get_option('active_plugins')))) {
            if (isset($input['remove_featured_image_enabled']))
                $new_input['remove_featured_image_enabled'] = absint($input['remove_featured_image_enabled']);
            else
                $new_input['remove_featured_image_enabled'] = 0;
        }
        if (in_array('woocommerce/woocommerce.php', apply_filters('active_plugins', get_option('active_plugins')))) {
            if (isset($input['live_product_shortcodes_enabled']))
                $new_input['live_product_shortcodes_enabled'] = absint($input['live_product_shortcodes_enabled']);
            else
                $new_input['live_product_shortcodes_enabled'] = 0;
        }
        if (in_array('woocommerce/woocommerce.php', apply_filters('active_plugins', get_option('active_plugins')))) {
            if (isset($input['product_shortcodes_animation_enabled']))
                $new_input['product_shortcodes_animation_enabled'] = absint($input['product_shortcodes_animation_enabled']);
            else
                $new_input['product_shortcodes_animation_enabled'] = 0;
        }

        if (isset($input['gold_decimal_position']))
            $new_input['gold_decimal_position'] = intval($input['gold_decimal_position']);
        else
            $new_input['gold_decimal_position'] = 2;

        if (isset($input['gold_rounding']))
            $new_input['gold_rounding'] = floatval($input['gold_rounding']);
        else
            $new_input['gold_rounding'] = "0.01";

        if (isset($input['silver_decimal_position']))
            $new_input['silver_decimal_position'] = intval($input['silver_decimal_position']);
        else
            $new_input['silver_decimal_position'] = 2;

        if (isset($input['silver_rounding']))
            $new_input['silver_rounding'] = floatval($input['silver_rounding']);
        else
            $new_input['silver_rounding'] = "0.01";

        if (isset($input['platinum_decimal_position']))
            $new_input['platinum_decimal_position'] = intval($input['platinum_decimal_position']);
        else
            $new_input['platinum_decimal_position'] = 2;

        if (isset($input['platinum_rounding']))
            $new_input['platinum_rounding'] = floatval($input['platinum_rounding']);
        else
            $new_input['platinum_rounding'] = "0.01";

        if (isset($input['palladium_decimal_position']))
            $new_input['palladium_decimal_position'] = intval($input['palladium_decimal_position']);
        else
            $new_input['palladium_decimal_position'] = 2;

        if (isset($input['palladium_rounding']))
            $new_input['palladium_rounding'] = floatval($input['palladium_rounding']);
        else
            $new_input['palladium_rounding'] = "0.01";

        if (isset($input['close_store']))
            $new_input['close_store'] = (bool)$input['close_store'];
        else
            $new_input['close_store'] = FALSE;

        if (isset($input['page_id']))
            $new_input['page_id'] = intval($input['page_id']);
        else
            $new_input['page_id'] = NULL;

        if (isset($input['empty_cart_timeout']))
            $new_input['empty_cart_timeout'] = intval($input['empty_cart_timeout']);
        else
            $new_input['empty_cart_timeout'] = NULL;

        if (isset($input['empty_cart_redirect_to']))
            $new_input['empty_cart_redirect_to'] = intval($input['empty_cart_redirect_to']);
        else
            $new_input['empty_cart_redirect_to'] = NULL;

        return $new_input;
    }


    public function gplc_sanitize($input)
    {
        if (!$this->gplc_settings) $this->gplc_settings = (get_option('gplc_settings')) ? array_merge($this->gplc_defaults, get_option('gplc_settings')) : $this->gplc_defaults;
        $new_input = $this->gplc_settings;

        $active_tab = (isset($_POST['tab']) && in_array($_POST['tab'], array_keys($this->gplc_tabs))) ? $_POST['tab'] : 'global';

        if ($active_tab == 'global') {
            /* Global */
            if (isset($input['default_currency']) && !empty($input['default_currency']) && in_array($input['default_currency'], $this->gplc_currencies))
                $new_input['default_currency'] = $input['default_currency'];
            else
                $new_input['default_currency'] = 'usd';
            if (isset($input['live']))
                $new_input['live'] = absint($input['live']);
            else
                $new_input['live'] = 0;
            if (isset($input['rows']))
                $new_input['rows'] = absint($input['rows']);
            else
                $new_input['rows'] = 0;
            if (isset($input['recaptcha_enabled']))
                $new_input['recaptcha_enabled'] = absint($input['recaptcha_enabled']);
            else
                $new_input['recaptcha_enabled'] = 0;
            if (isset($input['recaptcha_key']))
                $new_input['recaptcha_key'] = $input['recaptcha_key'];
            else
                $new_input['recaptcha_enabled'] = "";
            if (isset($input['recaptcha_secret']))
                $new_input['recaptcha_secret'] = $input['recaptcha_secret'];
            else
                $new_input['recaptcha_enabled'] = "";
        }

        if ($active_tab == 'colors') {
            /* Colors */
            if (isset($input['main_color']))
                $new_input['main_color'] = sanitize_text_field($input['main_color']);
            else
                $new_input['main_color'] = '#C7A400';
            if (isset($input['footer_color']))
                $new_input['footer_color'] = sanitize_text_field($input['footer_color']);
            else
                $new_input['footer_color'] = '#A38600';
            if (isset($input['text_color']))
                $new_input['text_color'] = sanitize_text_field($input['text_color']);
            else
                $new_input['text_color'] = '#FFFFFF';
        }

        if ($active_tab == 'ff') {
            /* Font Families */
            if (isset($input['ff_currency_dropdown']) && !empty($input['ff_currency_dropdown']) && in_array($input['ff_currency_dropdown'], $this->gplc_fonts))
                $new_input['ff_currency_dropdown'] = $input['ff_currency_dropdown'];
            else
                $new_input['ff_currency_dropdown'] = 'Lato';
            if (isset($input['ff_table_header']) && !empty($input['ff_table_header']) && in_array($input['ff_table_header'], $this->gplc_fonts))
                $new_input['ff_table_header'] = $input['ff_table_header'];
            else
                $new_input['ff_table_header'] = 'Lato';
            if (isset($input['ff_form']) && !empty($input['ff_form']) && in_array($input['ff_form'], $this->gplc_fonts))
                $new_input['ff_form'] = $input['ff_form'];
            else
                $new_input['ff_form'] = 'Lato';
            if (isset($input['ff_footer']) && !empty($input['ff_footer']) && in_array($input['ff_footer'], $this->gplc_fonts))
                $new_input['ff_footer'] = $input['ff_footer'];
            else
                $new_input['ff_footer'] = 'Lato';
        }

        if ($active_tab == 'fs') {
            /* Font Sizes */
            if (isset($input['fs_currency_dropdown']))
                $new_input['fs_currency_dropdown'] = absint($input['fs_currency_dropdown']);
            else
                $new_input['fs_currency_dropdown'] = 14;
            if (isset($input['fs_table_header']))
                $new_input['fs_table_header'] = absint($input['fs_table_header']);
            else
                $new_input['fs_table_header'] = 14;
            if (isset($input['fs_form']))
                $new_input['fs_form'] = absint($input['fs_form']);
            else
                $new_input['fs_form'] = 14;
            if (isset($input['fs_footer']))
                $new_input['fs_footer'] = absint($input['fs_footer']);
            else
                $new_input['fs_footer'] = 14;
        }

        return $new_input;
    }

    public function print_section_info()
    {
        print 'Enable or disable plugin functionality:';
    }

    public function shortcodes_enabled_callback()
    {
        printf(
            '<input type="checkbox" id="shortcodes_enabled" name="gold_price_live_settings[shortcodes_enabled]" value="1" %s />',
            (isset($this->options['shortcodes_enabled'])) ? (($this->options['shortcodes_enabled']) ? "checked=\"checked\"" : '') : ""
        );
    }

    public function live_shortcodes_enabled_callback()
    {
        printf(
            '<input type="checkbox" id="live_shortcodes_enabled" name="gold_price_live_settings[live_shortcodes_enabled]" value="1" %s />',
            (isset($this->options['live_shortcodes_enabled'])) ? (($this->options['live_shortcodes_enabled']) ? "checked=\"checked\"" : '') : ""
        );
    }

    public function color_disabled_callback()
    {
        printf(
            '<input type="checkbox" id="color_disabled" name="gold_price_live_settings[color_disabled]" value="1" %s />',
            (isset($this->options['color_disabled'])) ? (($this->options['color_disabled']) ? "checked=\"checked\"" : '') : ""
        );
    }

    public function shortcodes_animation_enabled_callback()
    {
        printf(
            '<input type="checkbox" id="shortcodes_animation_enabled" name="gold_price_live_settings[shortcodes_animation_enabled]" value="1" %s />',
            (isset($this->options['shortcodes_animation_enabled'])) ? (($this->options['shortcodes_animation_enabled']) ? "checked=\"checked\"" : '') : ""
        );
    }

    public function live_price_enabled_callback()
    {
        printf(
            '<input type="checkbox" id="live_price_enabled" name="gold_price_live_settings[live_price_enabled]" value="1" %s />',
            (isset($this->options['live_price_enabled'])) ? (($this->options['live_price_enabled']) ? "checked=\"checked\"" : '') : ""
        );
    }

    public function remove_featured_image_enabled_callback()
    {
        printf(
            '<input type="checkbox" id="remove_featured_image_enabled" name="gold_price_live_settings[remove_featured_image_enabled]" value="1" %s />',
            (isset($this->options['remove_featured_image_enabled'])) ? (($this->options['remove_featured_image_enabled']) ? "checked=\"checked\"" : '') : ""
        );
    }

    public function live_product_shortcodes_enabled_callback()
    {
        printf(
            '<input type="checkbox" id="live_product_shortcodes_enabled" name="gold_price_live_settings[live_product_shortcodes_enabled]" value="1" %s />',
            (isset($this->options['live_product_shortcodes_enabled'])) ? (($this->options['live_product_shortcodes_enabled']) ? "checked=\"checked\"" : '') : ""
        );
    }

    public function product_shortcodes_animation_enabled_callback()
    {
        printf(
            '<input type="checkbox" id="product_shortcodes_animation_enabled" name="gold_price_live_settings[product_shortcodes_animation_enabled]" value="1" %s />',
            (isset($this->options['product_shortcodes_animation_enabled'])) ? (($this->options['product_shortcodes_animation_enabled']) ? "checked=\"checked\"" : '') : ""
        );
    }

    public function gold_decimal_position_callback()
    {
        printf(
            '<input type="number" min="0" id="gold_decimal_position" name="gold_price_live_settings[gold_decimal_position]" value="%s" />',
            (isset($this->options['gold_decimal_position'])) ? $this->options['gold_decimal_position'] : 2
        );
    }

    public function gold_rounding_callback()
    {
        $selected = (isset($this->options['gold_rounding'])) ? (float)$this->options['gold_rounding'] : 0.01;
        ?>
        <select id="gold_rounding" name="gold_price_live_settings[gold_rounding]">
            <option value="0.1" <?php echo ($selected == 0.1) ? "selected" : ""; ?>>0.1</option>
            <option value="0.5" <?php echo ($selected == 0.5) ? "selected" : ""; ?>>0.5</option>
            <option value="0.01" <?php echo ($selected == 0.01) ? "selected" : ""; ?>>0.01</option>
            <option value="0.05" <?php echo ($selected == 0.05) ? "selected" : ""; ?>>0.05</option>
            <option value="0.001" <?php echo ($selected == 0.001) ? "selected" : ""; ?>>0.001</option>
            <option value="0.005" <?php echo ($selected == 0.005) ? "selected" : ""; ?>>0.005</option>
        </select>
        <?php
    }

    public function silver_decimal_position_callback()
    {
        printf(
            '<input type="number" min="0" id="silver_decimal_position" name="gold_price_live_settings[silver_decimal_position]" value="%s" />',
            (isset($this->options['silver_decimal_position'])) ? $this->options['silver_decimal_position'] : 2
        );
    }

    public function silver_rounding_callback()
    {
        $selected = (isset($this->options['silver_rounding'])) ? (float)$this->options['silver_rounding'] : 0.01;
        ?>
        <select id="silver_rounding" name="gold_price_live_settings[silver_rounding]">
            <option value="0.1" <?php echo ($selected == 0.1) ? "selected" : ""; ?>>0.1</option>
            <option value="0.5" <?php echo ($selected == 0.5) ? "selected" : ""; ?>>0.5</option>
            <option value="0.01" <?php echo ($selected == 0.01) ? "selected" : ""; ?>>0.01</option>
            <option value="0.05" <?php echo ($selected == 0.05) ? "selected" : ""; ?>>0.05</option>
            <option value="0.001" <?php echo ($selected == 0.001) ? "selected" : ""; ?>>0.001</option>
            <option value="0.005" <?php echo ($selected == 0.005) ? "selected" : ""; ?>>0.005</option>
        </select>
        <?php
    }

    public function platinum_decimal_position_callback()
    {
        printf(
            '<input type="number" min="0" id="platinum_decimal_position" name="gold_price_live_settings[platinum_decimal_position]" value="%s" />',
            (isset($this->options['platinum_decimal_position'])) ? $this->options['platinum_decimal_position'] : 2
        );
    }

    public function platinum_rounding_callback()
    {
        $selected = (isset($this->options['platinum_rounding'])) ? (float)$this->options['platinum_rounding'] : 0.01;
        ?>
        <select id="platinum_rounding" name="gold_price_live_settings[platinum_rounding]">
            <option value="0.1" <?php echo ($selected == 0.1) ? "selected" : ""; ?>>0.1</option>
            <option value="0.5" <?php echo ($selected == 0.5) ? "selected" : ""; ?>>0.5</option>
            <option value="0.01" <?php echo ($selected == 0.01) ? "selected" : ""; ?>>0.01</option>
            <option value="0.05" <?php echo ($selected == 0.05) ? "selected" : ""; ?>>0.05</option>
            <option value="0.001" <?php echo ($selected == 0.001) ? "selected" : ""; ?>>0.001</option>
            <option value="0.005" <?php echo ($selected == 0.005) ? "selected" : ""; ?>>0.005</option>
        </select>
        <?php
    }

    public function palladium_decimal_position_callback()
    {
        printf(
            '<input type="number" min="0" id="palladium_decimal_position" name="gold_price_live_settings[palladium_decimal_position]" value="%s" />',
            (isset($this->options['palladium_decimal_position'])) ? $this->options['palladium_decimal_position'] : 2
        );
    }

    public function palladium_rounding_callback()
    {
        $selected = (isset($this->options['palladium_rounding'])) ? (float)$this->options['palladium_rounding'] : 0.01;
        ?>
        <select id="palladium_rounding" name="gold_price_live_settings[palladium_rounding]">
            <option value="0.1" <?php echo ($selected == 0.1) ? "selected" : ""; ?>>0.1</option>
            <option value="0.5" <?php echo ($selected == 0.5) ? "selected" : ""; ?>>0.5</option>
            <option value="0.01" <?php echo ($selected == 0.01) ? "selected" : ""; ?>>0.01</option>
            <option value="0.05" <?php echo ($selected == 0.05) ? "selected" : ""; ?>>0.05</option>
            <option value="0.001" <?php echo ($selected == 0.001) ? "selected" : ""; ?>>0.001</option>
            <option value="0.005" <?php echo ($selected == 0.005) ? "selected" : ""; ?>>0.005</option>
        </select>
        <?php
    }

    public function close_store_callback()
    {
        $checked = (isset($this->options['close_store']) && $this->options['close_store']) ? 'checked' : '';
        ?>
        <input type="checkbox" id="close_store"
               name="gold_price_live_settings[close_store]" <?php echo $checked; ?>>
        <br/>
        <small>
            Market is closed from Sunday at 4pm MST until Fridays at 3:15 MST.
        </small>
        <?php
    }

    public function page_id_callback()
    {
        $pages_defaults = array(
            'depth' => 0, 'child_of' => 0,
            'selected' => 0, 'echo' => 1,
            'name' => 'page_id', 'id' => '',
            'class' => '',
            'show_option_none' => '', 'show_option_no_change' => '',
            'option_none_value' => '',
            'value_field' => 'ID',
        );
        $pages = get_pages($pages_defaults);
        if (!empty($pages)) {
            $walker = new Walker_Page_Integration;
            $pages_array = call_user_func_array(array($walker, 'walk'), array($pages, $pages_defaults['depth'], $pages_defaults));
        } else {
            $pages_array = array("" => __('No data found', 'goldpricelive_plugin'));
        }
        ?>
        <select id="page_id" name="gold_price_live_settings[page_id]">
            <?php foreach ($pages_array as $id => $page) { ?>
                <option value="<?php echo $id; ?>" <?php echo ($id === $this->options['page_id']) ? "selected" : ""; ?>><?php echo $page; ?></option>
            <?php } ?>
        </select>
        <br/>
        <small>
            Redirect to specific page when the market is closed and remove all items from shopping cart.
        </small>
        <?php
    }

    public function empty_cart_timeout_callback()
    {
        ?>
        <input type="number" id="empty_cart_timeout" name="gold_price_live_settings[empty_cart_timeout]"
               value="<?php echo $this->options['empty_cart_timeout']; ?>">
        <br/>
        <small>
            Remove items from the shopping cart after needed time. Leave empty if disable
        </small>
        <?php
    }

    public function empty_cart_redirect_to_callback()
    {
        $pages_defaults = array(
            'depth' => 0, 'child_of' => 0,
            'selected' => 0, 'echo' => 1,
            'name' => 'page_id', 'id' => '',
            'class' => '',
            'show_option_none' => '', 'show_option_no_change' => '',
            'option_none_value' => '',
            'value_field' => 'ID',
        );
        $pages = get_pages($pages_defaults);
        if (!empty($pages)) {
            $walker = new Walker_Page_Integration;
            $pages_array = call_user_func_array(array($walker, 'walk'), array($pages, $pages_defaults['depth'], $pages_defaults));
        } else {
            $pages_array = array("" => __('No data found', 'goldpricelive_plugin'));
        }

        ?>
        <select id="empty_cart_redirect_to" name="gold_price_live_settings[empty_cart_redirect_to]">
            <?php foreach ($pages_array as $id => $page) { ?>
                <option value="<?php echo $id; ?>" <?php echo ($id === $this->options['empty_cart_redirect_to']) ? "selected" : ""; ?>><?php echo $page; ?></option>
            <?php } ?>
        </select>
        <br/>
        <small>
            Redirect the user to needed page when the cart was cleared due to timeout.
        </small>
        <?php
    }

    public function gold_price_live_admin()
    {

        echo "<h2>" . __('Gold Price Live') . "</h2>";

        $this->options = get_option('gold_price_live_settings');

        ?>

        <style type="text/css">
            <!--
            .style1 {
                color: #C00
            }

            .style2 {
                color: #000099
            }

            .style3 {
                color: #000000;
                font-style: italic;
                font-weight: bold;
            }

            .style4 {
                font-weight: bold
            }

            .style5 {
                color: #FF0000
            }

            -->
        </style>
        <hr/>
        <h1 align="center" class="style1 style4"><span>THANK YOU FOR INSTALLING </span></h1>
        <h1 align="center" class="style1"><span style="color: #C00">Gold Price Live!</span></h1>
        <p align="center" class="style2">Brought to you by www.gold-feed.com</p>

        <hr/>

        <div class="wrap">
            <form method="post" action="options.php">
                <?php
                settings_fields('gold_price_live_group');
                do_settings_sections('gold_price_live_settings_section');
                submit_button();
                ?>
            </form>
        </div>

        <hr/>
        <h2 align="center"><u>USAGE INSTRUCTIONS</u></h2>
        <h2 align="center">To add the value of Gold, Silver, Platinum and Palladium just write: </h2>
        <div align="center" style=" font-weight:bold; font-size:11px;">
            [gold_bid]<br/>[gold_ask]<br/>[gold_high]<br/>[gold_low]<br/>[gold_dollar_change]<br/>[gold_percent_change]<br>
            [silver_bid]<br/>[silver_ask]<br/>[silver_high]<br/>[silver_low]<br/>[silver_dollar_change]<br/>[silver_percent_change]<br>
            [platinum_bid]<br/>[platinum_ask]<br/>[platinum_high]<br/>[platinum_low]<br/>[platinum_dollar_change]<br/>[platinum_percent_change]<br>
            [palladium_bid]<br/>[palladium_ask]<br/>[palladium_high]<br/>[palladium_low]<br/>[palladium_dollar_change]<br/>[palladium_percent_change]<br>
            [gold_londonfix_am]<br>
            [gold_londonfix_pm]<br>
            [silver_londonfix]<br>
            [platinum_londonfix_am]<br>
            [platinum_londonfix_pm]<br>
            [palladium_londonfix_am]<br>
            [palladium_londonfix_pm]
        </div>
        <div style="text-align: center;">
            <h4>Here are all of the working parameters of our Precious Metals Shortcodes. </h4>
            <p>currency="usd" unit="toz" weight="0.1" purity="0.999" fixedamount="0.99" payout="0.85" animation="yes"
                exchange="cad" multiplyby="1.01" </p>
            <h4>Supported Currencies: </h4>
            <p>aed, aud, cad, chf, cny, czk, eur, gbp, hkd, jpy, lkr, myr, sgd, twd, usd, zar </p>
            <h4>Supported Weights: </h4>
            <p>toz - troy ounce </p>
            <p>pw - pennyweight </p>
            <p>g - gram </p>
            <h4>Supported Exchanges: </h4>
            <p>usd, aud, eur, chf, gbp, nzd, aud, jpy, and cny </p>
            <h2>To add WooCommerce product information just write: </h2>
            <p>[woocommerceproduct id="598" entity="price"] <br>
                [woocommerceproduct id="598" entity="title"] <br>
                [woocommerceproduct id="598" entity="shortdescription"] </p>
            <h2>To add a calculator to a page just write: </h2>
            <p>[gpl_calculator] <br>
            <h4>How are all of the working parameters of our WooCommerce Price Entity Shortcode. </h4>
            <p>woocommerceproduct id="598" entity="price" percentmarkupdown="0.91" fixedmarkupdown="1.99"
                color="#ffffff"
                animation="yes" </p></div>
        <center>
            <div align="center" style="margin-top:15px; margin-bottom:15px;">&copy; <?php echo date("Y"); ?> Gold Feed
                Inc. | <a href="http://gold-feed.com" target="_blank">www.gold-feed.com</a> | <a
                        href="mailto:info@gold-feed.com" style="color:#000000;">info@gold-feed.com</a> | <a
                        href="tel:7804780870" style="color:#000000;">780-467-0852</a></div>
        </center>

        <hr>

        <?php

    }

    public function gplc_global_info()
    {
        print 'Calculator Global Settings:';
    }

    public function gplc_colors_info()
    {
        print 'Choose calculator colors:';
    }

    public function gplc_ff_info()
    {
        print 'Choose font families:';
    }

    public function gplc_fs_info()
    {
        print 'Choose font sizes:';
    }

    public function gplc_default_currency()
    {
        if (!$this->gplc_settings) $this->gplc_settings = (get_option('gplc_settings')) ? array_merge($this->gplc_defaults, get_option('gplc_settings')) : $this->gplc_defaults;
        ?>
        <select id="default_currency" class="large-text" name="gplc_settings[default_currency]">
            <?php foreach ($this->gplc_currencies as $currency) { ?>
                <option value="<?php echo $currency; ?>" <?php echo (isset($this->gplc_settings['default_currency']) && !empty($this->gplc_settings['default_currency']) && $this->gplc_settings['default_currency'] == $currency) ? 'selected="selected"' : ""; ?>><?php echo strtoupper($currency); ?></option>
            <?php } ?>
        </select>
        <?php
    }


    public function gplc_live()
    {
        if (!$this->gplc_settings) $this->gplc_settings = (get_option('gplc_settings')) ? array_merge($this->gplc_defaults, get_option('gplc_settings')) : $this->gplc_defaults;

        printf(
            '<input type="checkbox" id="live" name="gplc_settings[live]" value="1" %s />',
            (isset($this->gplc_settings['live']) && !empty($this->gplc_settings['live']) && $this->gplc_settings['live']) ? 'checked="checked"' : ''
        );
    }


    public function gplc_rows()
    {
        if (!$this->gplc_settings) $this->gplc_settings = (get_option('gplc_settings')) ? array_merge($this->gplc_defaults, get_option('gplc_settings')) : $this->gplc_defaults;

        printf(
            '<input type="number" class="large-text" id="rows" name="gplc_settings[rows]" value="%s" />',
            (isset($this->gplc_settings['rows']) && !empty($this->gplc_settings['rows']) && $this->gplc_settings['rows']) ? $this->gplc_settings['rows'] : 1
        );
    }


    public function gplc_recaptcha_enabled()
    {
        if (!$this->gplc_settings) $this->gplc_settings = (get_option('gplc_settings')) ? array_merge($this->gplc_defaults, get_option('gplc_settings')) : $this->gplc_defaults;

        printf(
            '<input type="checkbox" id="recaptcha_enabled" name="gplc_settings[recaptcha_enabled]" value="1" %s />',
            (isset($this->gplc_settings['recaptcha_enabled']) && !empty($this->gplc_settings['recaptcha_enabled']) && $this->gplc_settings['recaptcha_enabled']) ? 'checked="checked"' : ''
        );
    }


    public function gplc_recaptcha_key()
    {
        if (!$this->gplc_settings) $this->gplc_settings = (get_option('gplc_settings')) ? array_merge($this->gplc_defaults, get_option('gplc_settings')) : $this->gplc_defaults;

        printf(
            '<input type="text" class="large-text" id="recaptcha_key" name="gplc_settings[recaptcha_key]" value="%s" />',
            (isset($this->gplc_settings['recaptcha_key']) && !empty($this->gplc_settings['recaptcha_key']) && $this->gplc_settings['recaptcha_key']) ? $this->gplc_settings['recaptcha_key'] : ""
        );
    }


    public function gplc_recaptcha_secret()
    {
        if (!$this->gplc_settings) $this->gplc_settings = (get_option('gplc_settings')) ? array_merge($this->gplc_defaults, get_option('gplc_settings')) : $this->gplc_defaults;

        printf(
            '<input type="text" class="large-text" id="recaptcha_secret" name="gplc_settings[recaptcha_secret]" value="%s" />',
            (isset($this->gplc_settings['recaptcha_secret']) && !empty($this->gplc_settings['recaptcha_secret']) && $this->gplc_settings['recaptcha_secret']) ? $this->gplc_settings['recaptcha_secret'] : ""
        );
    }

    public function gplc_main_color()
    {
        if (!$this->gplc_settings) $this->gplc_settings = (get_option('gplc_settings')) ? array_merge($this->gplc_defaults, get_option('gplc_settings')) : $this->gplc_defaults;

        printf(
            '<input type="text" class="large-text" id="main_color" name="gplc_settings[main_color]" value="%s" />',
            (isset($this->gplc_settings['main_color']) && $this->gplc_settings['main_color']) ? $this->gplc_settings['main_color'] : '#C7A400'
        );
    }

    public function gplc_footer_color()
    {
        if (!$this->gplc_settings) $this->gplc_settings = (get_option('gplc_settings')) ? array_merge($this->gplc_defaults, get_option('gplc_settings')) : $this->gplc_defaults;

        printf(
            '<input type="text" class="large-text" class="large-text" id="footer_color" name="gplc_settings[footer_color]" value="%s" />',
            (isset($this->gplc_settings['footer_color']) && $this->gplc_settings['footer_color']) ? $this->gplc_settings['footer_color'] : '#A38600'
        );
    }

    public function gplc_text_color()
    {
        if (!$this->gplc_settings) $this->gplc_settings = (get_option('gplc_settings')) ? array_merge($this->gplc_defaults, get_option('gplc_settings')) : $this->gplc_defaults;

        printf(
            '<input type="text" class="large-text" id="text_color" name="gplc_settings[text_color]" value="%s" />',
            (isset($this->gplc_settings['text_color']) && $this->gplc_settings['text_color']) ? $this->gplc_settings['text_color'] : '#A38600'
        );
    }

    public function gplc_ff_currency_dropdown()
    {
        if (!$this->gplc_settings) $this->gplc_settings = (get_option('gplc_settings')) ? array_merge($this->gplc_defaults, get_option('gplc_settings')) : $this->gplc_defaults;
        ?>
        <select id="ff_currency_dropdown" class="large-text" name="gplc_settings[ff_currency_dropdown]">
            <?php foreach ($this->gplc_fonts as $font) { ?>
                <option value="<?php echo $font; ?>" <?php echo (isset($this->gplc_settings['ff_currency_dropdown']) && !empty($this->gplc_settings['ff_currency_dropdown']) && $this->gplc_settings['ff_currency_dropdown'] == $font) ? 'selected="selected"' : ""; ?>><?php echo $font; ?></option>
            <?php } ?>
        </select>
        <?php
    }

    public function gplc_ff_table_header()
    {
        if (!$this->gplc_settings) $this->gplc_settings = (get_option('gplc_settings')) ? array_merge($this->gplc_defaults, get_option('gplc_settings')) : $this->gplc_defaults;
        ?>
        <select id="ff_table_header" class="large-text" name="gplc_settings[ff_table_header]">
            <?php foreach ($this->gplc_fonts as $font) { ?>
                <option value="<?php echo $font; ?>" <?php echo (isset($this->gplc_settings['ff_table_header']) && !empty($this->gplc_settings['ff_table_header']) && $this->gplc_settings['ff_table_header'] == $font) ? 'selected="selected"' : ""; ?>><?php echo $font; ?></option>
            <?php } ?>
        </select>
        <?php
    }

    public function gplc_ff_form()
    {
        if (!$this->gplc_settings) $this->gplc_settings = (get_option('gplc_settings')) ? array_merge($this->gplc_defaults, get_option('gplc_settings')) : $this->gplc_defaults;
        ?>
        <select id="ff_form" class="large-text" name="gplc_settings[ff_form]">
            <?php foreach ($this->gplc_fonts as $font) { ?>
                <option value="<?php echo $font; ?>" <?php echo (isset($this->gplc_settings['ff_form']) && !empty($this->gplc_settings['ff_form']) && $this->gplc_settings['ff_form'] == $font) ? 'selected="selected"' : ""; ?>><?php echo $font; ?></option>
            <?php } ?>
        </select>
        <?php
    }

    public function gplc_ff_footer()
    {
        if (!$this->gplc_settings) $this->gplc_settings = (get_option('gplc_settings')) ? array_merge($this->gplc_defaults, get_option('gplc_settings')) : $this->gplc_defaults;
        ?>
        <select id="ff_footer" class="large-text" name="gplc_settings[ff_footer]">
            <?php foreach ($this->gplc_fonts as $font) { ?>
                <option value="<?php echo $font; ?>" <?php echo (isset($this->gplc_settings['ff_footer']) && !empty($this->gplc_settings['ff_footer']) && $this->gplc_settings['ff_footer'] == $font) ? 'selected="selected"' : ""; ?>><?php echo $font; ?></option>
            <?php } ?>
        </select>
        <?php
    }

    public function gplc_fs_currency_dropdown()
    {
        if (!$this->gplc_settings) $this->gplc_settings = (get_option('gplc_settings')) ? array_merge($this->gplc_defaults, get_option('gplc_settings')) : $this->gplc_defaults;

        printf(
            '<input type="number" class="large-text" id="fs_currency_dropdown" name="gplc_settings[fs_currency_dropdown]" value="%s" />',
            (isset($this->gplc_settings['fs_currency_dropdown']) && $this->gplc_settings['fs_currency_dropdown']) ? $this->gplc_settings['fs_currency_dropdown'] : 14
        );
    }

    public function gplc_fs_table_header()
    {
        if (!$this->gplc_settings) $this->gplc_settings = (get_option('gplc_settings')) ? array_merge($this->gplc_defaults, get_option('gplc_settings')) : $this->gplc_defaults;

        printf(
            '<input type="number" class="large-text" id="gplc_fs_table_header" name="gplc_settings[fs_table_header]" value="%s" />',
            (isset($this->gplc_settings['fs_table_header']) && $this->gplc_settings['fs_table_header']) ? $this->gplc_settings['fs_table_header'] : 14
        );
    }

    public function gplc_fs_form()
    {
        if (!$this->gplc_settings) $this->gplc_settings = (get_option('gplc_settings')) ? array_merge($this->gplc_defaults, get_option('gplc_settings')) : $this->gplc_defaults;

        printf(
            '<input type="number" class="large-text" id="gplc_fs_form" name="gplc_settings[fs_form]" value="%s" />',
            (isset($this->gplc_settings['fs_form']) && $this->gplc_settings['fs_form']) ? $this->gplc_settings['fs_form'] : 14
        );
    }

    public function gplc_fs_footer()
    {
        if (!$this->gplc_settings) $this->gplc_settings = (get_option('gplc_settings')) ? array_merge($this->gplc_defaults, get_option('gplc_settings')) : $this->gplc_defaults;

        printf(
            '<input type="number" class="large-text" id="gplc_fs_footer" name="gplc_settings[fs_footer]" value="%s" />',
            (isset($this->gplc_settings['fs_footer']) && $this->gplc_settings['fs_footer']) ? $this->gplc_settings['fs_footer'] : 14
        );
    }

    public function gplc_admin()
    {
        ?>

        <div class="wrap">
            <div id="icon-themes" class="icon32"></div>
            <h2>Gold Price Live Calculator Settings</h2>

            <?php
            $active_tab = (isset($_GET['tab']) && in_array($_GET['tab'], array_keys($this->gplc_tabs))) ? $_GET['tab'] : 'global';
            ?>

            <h2 class="nav-tab-wrapper">
                <?php foreach ($this->gplc_tabs as $key => $tab) { ?>
                    <a href="?page=GPL+Calculator&tab=<?php echo $key; ?>"
                       class="nav-tab <?php echo $active_tab == $key ? 'nav-tab-active' : ''; ?>"><?php echo $tab; ?></a>
                <?php } ?>
            </h2>

            <form method="post" action="options.php">
                <input type="hidden" name="tab" value="<?php echo $active_tab; ?>"/>
                <?php
                settings_fields('gpl_calculator');
                do_settings_sections('gplc_' . $active_tab . '_section');
                submit_button();
                ?>
            </form>
        </div>

        <?php
    }


    public function gold_price_live_admin_actions()
    {
        add_options_page('Gold Price Live', 'Gold Price Live', 'manage_options', 'Gold Price Live', array($this, 'gold_price_live_admin'));

    }

    public function gplc_admin_actions()
    {
        add_options_page('GPL Table Calculator', 'GPL Table Calculator', 'manage_options', 'GPL Table Calculator', array($this, 'gplc_admin'));
    }

    public function process($metal, $type, $price, $a)
    {
        $currencies = array('aed', 'aud', 'cad', 'chf', 'cny', 'czk', 'eur', 'gbp', 'hkd', 'jpy', 'lkr', 'myr', 'sgd', 'twd', 'usd', 'zar');
        $units = array('toz', 'grams', 'g', 'pennyweight', 'pw', 'oz');
        $metals = array('gold', 'silver', 'platinum', 'palladium');
        $types = array('bid', 'ask', 'high', 'low', 'change_dollar', 'change_percent', 'londonfix_am', 'londonfix_pm', 'londonfix');

        switch ((float)$this->options[$metal . "_rounding"]) {
            case 0.1:
                $k = 10;
                break;
            case 0.5:
                $k = 2;
                break;
            case 0.05:
                $k = 20;
                break;
            case 0.001:
                $k = 1000;
                break;
            case 0.005:
                $k = 200;
                break;
            case 0.01:
            default:
                $k = 100;
                break;
        }

        $price = number_format(floatval($price), 2);

        return '<span class="gpl-shortcode' . ((isset($a) && is_array($a) && isset($a['animation']) && $a['animation']) ? ' gpl-shortcode-animate' : "") . '" '
            . ((isset($metal) && in_array($metal, $metals)) ? 'data-metal="' . $metal . '" ' : "")
            . ((isset($type) && in_array($type, $types)) ? 'data-type="' . $type . '" ' : "")
            . ((isset($a) && is_array($a) && isset($a['currency']) && in_array($a['currency'], $currencies)) ? 'data-currency="' . $a['currency'] . '" ' : "")
            . ((isset($a) && is_array($a) && isset($a['unit']) && in_array($a['unit'], $units)) ? 'data-unit="' . $a['unit'] . '" ' : "")
            . ((isset($a) && is_array($a) && isset($a['payout']) && $a['payout'] > 0) ? 'data-payout="' . floatval($a['payout']) . '" ' : "")
            . ((isset($a) && is_array($a) && isset($a['purity']) && $a['purity'] > 0) ? 'data-purity="' . floatval($a['purity']) . '" ' : "")
            . ((isset($a) && is_array($a) && isset($a['weight']) && $a['weight'] > 0) ? 'data-weight="' . floatval($a['weight']) . '" ' : "")
            . ((isset($a) && is_array($a) && isset($a['fixedamount']) && $a['fixedamount'] > 0) ? 'data-fixedamount="' . floatval($a['fixedamount']) . '" ' : "")
            . 'data-rounding="' . $k . '" '
            . 'data-decimalplaces="' . $this->options[$metal . "_decimal_position"] . '" '
            . ($type === "change_dollar" || $type === "change_percent" ? (floatval($price) > 0 ? ' style="color: #00FF00 !important;" ' : (floatval($price) < 0 ? ' style="color: #FF0000 !important;"  ' : "")) : "")
            . '>'
            . ((isset($a) && is_array($a) && isset($a['animation']) && $a['animation'] && isset($this->options['shortcodes_animation_enabled']) && $this->options['shortcodes_animation_enabled']) ? ('<span>' . $price . '</span><span data-new="1">' . $price . '</span>') : $price)
            . '</span>';
    }

    public function exchange_process($metal, $type, $price, $a)
    {
        switch ((float)$this->options[$metal . "_rounding"]) {
            case 0.1:
                $k = 10;
                break;
            case 0.5:
                $k = 2;
                break;
            case 0.05:
                $k = 20;
                break;
            case 0.001:
                $k = 1000;
                break;
            case 0.005:
                $k = 200;
                break;
            case 0.01:
            default:
                $k = 100;
                break;
        }

        $price = number_format(floatval($price), 2);

        return '<span class="gpl-exchange-shortcode' . ((isset($a) && is_array($a) && isset($a['animation']) && $a['animation']) ? ' gpl-shortcode-animate' : "") . '" '
            . ((isset($metal) && in_array($metal, array_keys($this->exchange_shortcodes))) ? 'data-metal="' . $metal . '" ' : "")
            . ((isset($type) && in_array($type, $this->exchange_shortcodes[$metal])) ? 'data-type="' . $type . '" ' : "")
            . ((isset($a) && is_array($a) && isset($a['currency']) && in_array($a['currency'], $this->currencies)) ? 'data-currency="' . $a['currency'] . '" ' : "")
            . ((isset($a) && is_array($a) && isset($a['exchange']) && in_array($a['exchange'], $this->currencies)) ? 'data-exchange="' . $a['exchange'] . '" ' : "")
            . ((isset($a) && is_array($a) && isset($a['fixedmarkupdown_' . $a['fixed_currency']]) && $a['fixedmarkupdown_' . $a['fixed_currency']] > 0) ? 'data-fixedmarkupdown="' . floatval($a['fixedmarkupdown_' . $a['fixed_currency']]) . '" ' : "")
            . ((isset($a) && is_array($a) && isset($a['fixed_currency']) && $a['fixed_currency']) ? 'data-fixedcurrency="' . $a['fixed_currency'] . '" ' : "")
            . ((isset($a) && is_array($a) && isset($a['multiplyby']) && $a['multiplyby']) ? 'data-multiplyby="' . $a['multiplyby'] . '" ' : "")
            . 'data-rounding="' . $k . '" '
            . 'data-decimalplaces="' . $this->options[$metal . "_decimal_position"] . '" '
            . ($type === "change_dollar" || $type === "change_percent" ? (floatval($price) > 0 ? ' style="color: #00FF00 !important;" ' : (floatval($price) < 0 ? ' style="color: #FF0000 !important;"  ' : "")) : "")
            . '>'
            . ((isset($a) && is_array($a) && isset($a['animation']) && $a['animation'] && isset($this->options['shortcodes_animation_enabled']) && $this->options['shortcodes_animation_enabled']) ? ('<span>' . $price . '</span><span data-new="1">' . $price . '</span>') : $price)
            . '</span>';
    }

    public function gplc_shortcode()
    {
        $uuid = str_replace("-", "_", wp_generate_uuid4());

        $options = (get_option('gplc_settings')) ? array_merge($this->gplc_defaults, get_option('gplc_settings')) : $this->gplc_defaults;

        wp_register_script('gplc', plugin_dir_url(__FILE__) . '/js/gplc.js', array('jquery'));
        wp_localize_script('gplc', 'gplc_params', array('rce' => $options['recaptcha_enabled'], 'rck' => $options['recaptcha_key'], 'ajaxurl' => admin_url('admin-ajax.php')));
        wp_enqueue_script('gplc');

        wp_register_script('recaptcha', 'https://www.google.com/recaptcha/api.js', array());
        wp_enqueue_script('recaptcha');

        wp_register_script('tomloprodModal', plugin_dir_url(__FILE__) . '/js/tomloprodModal.js', array());
        wp_enqueue_script('tomloprodModal');

        $fonts = array(
            urlencode($options['ff_currency_dropdown']),
            urlencode($options['ff_table_header']),
            urlencode($options['ff_form']),
            urlencode($options['ff_footer'])
        );

        wp_enqueue_style('gplc-google-fonts', 'https://fonts.googleapis.com/css?family=' . implode("|", array_unique($fonts)), false);
        wp_enqueue_style('tomloprodModal', plugin_dir_url(__FILE__) . '/css/tomloprodModal.css', false);

        ob_start();
        ?>

        <style>
            .gplc_container_<?php echo $uuid; ?> {
                width: 100%;
            }

            .gplc_container_<?php echo $uuid; ?> .gplc_currency {
                padding: 10px 0;
            }

            .gplc_container_<?php echo $uuid; ?> .gplc_header {
                font-size: <?php echo $options['fs_currency_dropdown'].'px'; ?>;
                font-family: '<?php echo $options['ff_currency_dropdown']; ?>', serif;
            }

            .gplc_container_<?php echo $uuid; ?> .gplc_body table,
            .gplc_container_<?php echo $uuid; ?> .gplc_body table select {
                width: 100%;
            }

            .gplc_container_<?php echo $uuid; ?> .gplc_body .gplc_price {
                text-align: center;
            }

            .gplc_container_<?php echo $uuid; ?> .gplc_body table thead {
                font-size: <?php echo $options['fs_table_header'].'px'; ?>;
            }

            .gplc_container_<?php echo $uuid; ?> .gplc_body table thead th {
                font-family: '<?php echo $options['ff_table_header']; ?>', serif;
                text-align: center;
                font-weight: bold;
                padding: 10px 15px;
                color: <?php echo $options['text_color']; ?>;
                border: 1px solid #fff;
                background-color: <?php echo $options['main_color']; ?>;
            }

            .gplc_container_<?php echo $uuid; ?> .gplc_body table tbody {
                font-family: '<?php echo $options['ff_form']; ?>', serif;
                font-size: <?php echo $options['fs_form'].'px'; ?>;
            }

            .gplc_container_<?php echo $uuid; ?> .gplc_body td {
                padding: 5px;
            }

            .gplc_container_<?php echo $uuid; ?> .gplc_footer {
                font-family: '<?php echo $options['ff_footer']; ?>', serif;
                font-size: <?php echo $options['fs_footer'].'px'; ?>;
                color: <?php echo $options['footer_color']; ?>;
            }

            .gplc_container_<?php echo $uuid; ?> .gplc_total {
                float: right;
                padding: 10px 0;
            }

            .gplc_container_<?php echo $uuid; ?> .clear {
                clear: both;
            }

            .gplc_container_<?php echo $uuid; ?> .gplc_footer .gplc_form table {
                width: 100%;
            }

            .gplc_container_<?php echo $uuid; ?> .gplc_footer .gplc_form table td {
                padding: 10px;
            }

            .gplc_container_<?php echo $uuid; ?> .gplc_footer .gplc_form input[type=submit] {
                padding: 5px 20px;
                border: 0;
                color: <?php echo $options['text_color']; ?>;
                background-color: <?php echo $options['main_color']; ?>;
            }

            .gplc_container_<?php echo $uuid; ?> .gplc_footer .gplc_form input[type=submit]:hover {
                opacity: 0.8;
            }

            .g-recaptcha div:first-child {
                margin: 0 auto;
            }

            .gplc_container_<?php echo $uuid; ?> button {
                padding: 5px 20px;
                border: 0;
                color: <?php echo $options['text_color']; ?>;
                background-color: <?php echo $options['main_color']; ?>;
            }

        </style>

        <div class="gplc_container gplc_container_<?php echo $uuid; ?> <?php echo ($options['live']) ? "gplc_live_container" : ""; ?>">
            <div class="gplc_header">
                <div class="gplc_currency">
                    <label>Currency</label>
                    <select onkeyup="gplc_update();" onchange="gplc_update();" onselect="gplc_update();">
                        <?php foreach ($this->gplc_currencies as $currency) { ?>
                            <option value="<?php echo $currency; ?>" <?php echo ($options['default_currency'] == $currency) ? 'selected="selected"' : ""; ?>><?php echo strtoupper($currency); ?></option>
                        <?php } ?>
                    </select>
                </div>
            </div>
            <div class="gplc_body">
                <table>
                    <thead>
                    <tr>
                        <th>Metal</th>
                        <th>Metal Price</th>
                        <th>Weight</th>
                        <th>Unit</th>
                        <th>Purity(%)</th>
                        <th>Value</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php for ($i = 0; $i < $options['rows']; $i++) { ?>
                        <tr>
                            <td>
                                <select onkeyup="gplc_update();" onchange="gplc_update();" onselect="gplc_update();"
                                        class="gplc_metal">
                                    <?php foreach ($this->gplc_metals as $metal) { ?>
                                        <option value="<?php echo $metal; ?>"><?php echo ucfirst($metal); ?></option>
                                    <?php } ?>
                                </select>
                            </td>
                            <td class="gplc_price"><input type="hidden" name="gplc_metal_price"
                                                          value="0.00">0.00 <?php echo strtoupper($options['default_currency']); ?>
                            </td>
                            <td>
                                <input onkeyup="gplc_update();" onchange="gplc_update();" type="text"
                                       class="gplc_weight" value=""/>
                            </td>
                            <td>
                                <select onkeyup="gplc_update();" onchange="gplc_update();" onselect="gplc_update();"
                                        class="gplc_unit">
                                    <option value="g">g</option>
                                    <option value="toz">toz</option>
                                    <option value="pw">pennyweight</option>
                                </select>
                            </td>
                            <td>
                                <select onkeyup="gplc_update();" onchange="gplc_update();" onselect="gplc_update();"
                                        class="gplc_purity">
                                    <option value="999">999</option>
                                </select>
                            </td>
                            <td>
                                <input onkeyup="gplc_update();" onchange="gplc_update();" type="text" class="gplc_value"
                                       value=""/>
                            </td>
                        </tr>
                    <?php } ?>
                    </tbody>
                </table>
            </div>
            <div class="gplc_footer">
                <div class="gplc_total">
                    Total value: <span class="gplc_total_val">0.00</span> (<span
                            class="gplc_total_currency"><?php echo strtoupper($options['default_currency']); ?></span>)
                </div>
                <div class="clear"></div>
                <div class="gplc_form">
                    <table>
                        <tr>
                            <td>
                                <input type="text" name="name" placeholder="First &amp; Last Name:*">
                            </td>
                            <td>
                                <input type="text" name="company" placeholder="Company:">
                            </td>
                            <td>
                                <input type="text" name="email" placeholder="Email:*">
                            </td>
                            <td>
                                <input type="text" name="phone" placeholder="Contact Phone:*">
                            </td>
                            <td>
                                <input type="submit" onclick="gplc_submit('<?php echo $uuid; ?>');" value="SUBMIT">
                            </td>
                        </tr>
                    </table>
                </div>
            </div>

            <div class="tm-modal tm-effect tm-draggable" id="recaptcha-popup">
                <div class="tm-wrapper">
                    <div class="tm-title">
                        <span class="tm-XButton tm-closeButton"></span>
                        <h3 class="tm-title-text">Confirm Submission</h3>
                    </div>
                    <div class="tm-content">
                        <p>
                        <div class="g-recaptcha" data-sitekey="<?php echo $options['recaptcha_key']; ?>"></div>
                        </p>
                        <p>
                            <button onclick="gplc_submit('<?php echo $uuid; ?>');">SUBMIT</button>
                        </p>
                    </div>
                </div>
            </div>
        </div>

        <?php
        $data = ob_get_clean();
        return $data;
    }

    public function get_simple_shortcode($atts, $content, $tag)
    {
        list($metal, $type) = explode("_", $tag, 2);
        if (!in_array($metal, array_keys($this->shortcodes))) $metal = 'gold';
        if (!in_array($type, $this->shortcodes[$metal])) $type = 'bid';
        if ($type == "dollar_change" || $type == "percent_change") {
            $a = shortcode_atts(array(
                'currency' => 'usd',
                'animation' => false
            ), $atts);

            $currencies = array('aed', 'aud', 'cad', 'chf', 'cny', 'czk', 'eur', 'gbp', 'hkd', 'jpy', 'lkr', 'myr', 'sgd', 'twd', 'usd', 'zar');
            if (!$a['currency'] || !in_array($a['currency'], $currencies)) $a['currency'] = 'usd';

            switch ($type) {
                case "dollar_change":
                    return $this->process($metal, "change_dollar", $this->decimals($this->get_price($metal . "_change_dollar", $a['currency']), $metal), $a);
                    break;
                case "percent_change":
                default:
                    return $this->process($metal, "change_percent", $this->get_price($metal . "_change_percent", $a['currency']), $a);
            }
        } else {
            $a = shortcode_atts(array(
                'currency' => 'usd',
                'unit' => 'toz',
                'payout' => 0,
                'purity' => 0,
                'weight' => 0,
                'fixedamount' => 0,
                'animation' => false
            ), $atts);

            $currencies = array('aed', 'aud', 'cad', 'chf', 'cny', 'czk', 'eur', 'gbp', 'hkd', 'jpy', 'lkr', 'myr', 'sgd', 'twd', 'usd', 'zar');
            if (!$a['currency'] || !in_array($a['currency'], $currencies)) $a['currency'] = 'usd';
            $price = $this->get_price($metal . "_" . $type, $a['currency']);
            if ($a['unit'] == 'grams' || $a['unit'] == 'g') {
                $price = $this->toz_to_grams($price);
            }
            if ($a['unit'] == 'pennyweight' || $a['unit'] == 'pw') {
                $price = $this->toz_to_pw($price);
            }
            if ($a['payout'] > 0) {
                $price = $price * floatval($a['payout']);
            }
            if ($a['purity'] > 0) {
                $price = $price * floatval($a['purity']);
            }
            if ($a['weight'] > 0) {
                $price = $price * floatval($a['weight']);
            }
            if ($a['fixedamount'] > 0) {
                $price = $price + floatval($a['fixedamount']);
            }

            return $this->process($metal, $type, $this->decimals($price, $metal), $a);
        }
    }

    public function get_exchange_shortcode($atts, $content, $tag)
    {
        list($metal, $type, $currency) = explode("_", $tag, 3);

        if (!in_array($metal, array_keys($this->shortcodes))) $metal = 'gold';
        if (!in_array($type, $this->shortcodes[$metal])) $type = 'bid';

        if (!$currency || !in_array($currency, $this->currencies)) $currency = 'usd';

        $currency_atts = array();

        foreach ($this->currencies as $available_currency) {
            $currency_atts['fixedmarkupdown_' . $available_currency] = 0;
        }

        $a = shortcode_atts(array_merge($currency_atts, array(
            'exchange' => $currency,
            'multiplyby' => '1',
            'animation' => false
        )), $atts);

        if (!$a['exchange'] || !in_array($a['exchange'], $this->currencies)) $a['exchange'] = 'usd';

        $price = $this->get_price($metal . "_" . $type, $currency);

        if ($currency != $a['exchange']) {
            if ($currency == 'usd') {
                $price = $price * $this->get_price($currency . $a['exchange'], 'usd');
            } elseif ($a['exchange'] == 'usd') {
                $price = $price / $this->get_price($a['exchange'] . $currency, 'usd');
            } else {
                $usd_cr = $this->get_price("usd" . $currency, 'usd');
                $usd_ex = $this->get_price("usd" . $a['exchange'], 'usd');

                $price = ($price / $usd_cr) * $usd_ex;
            }
        }

        $fixed_currency = 'usd';
        $fixed_amount = 0;

        foreach ($this->currencies as $available_currency) {
            if ($a['fixedmarkupdown_' . $available_currency] != 0) {
                $fixed_currency = $available_currency;
                $fixed_amount = $a['fixedmarkupdown_' . $available_currency];
                break;
            }
        }

        if ($fixed_currency != $a['exchange']) {
            if ($fixed_currency == 'usd') {
                $fixed_amount = $fixed_amount * $this->get_price($fixed_currency . $a['exchange'], 'usd');
            } elseif ($a['exchange'] == 'usd') {
                $fixed_amount = $fixed_amount / $this->get_price($a['exchange'] . $fixed_currency, 'usd');
            } else {
                $usd_cr = $this->get_price("usd" . $fixed_currency, 'usd');
                $usd_ex = $this->get_price("usd" . $a['exchange'], 'usd');

                $fixed_amount = ($fixed_amount / $usd_cr) * $usd_ex;
            }
        }

        $price += $fixed_amount;

        if ($a['multiplyby'] && floatval($a['multiplyby']) != 1 && floatval($a['multiplyby']) > 0) {
            $price *= floatval($a['multiplyby']);
        }

        $a['currency'] = $currency;
        $a['fixed_currency'] = $fixed_currency;
        return $this->exchange_process($metal, $type, $this->decimals($price, $metal), $a);
    }

    private function get_contents($url, $get = FALSE, $post = FALSE, $header = array(), $headers = FALSE)
    {
        $ch = curl_init();
        if ($get) {
            $url .= "?" . http_build_query($get);
        }

        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (X11; Linux x86_64; rv:47.0) Gecko/20100101 Firefox/47.0');
        if ($headers && is_array($headers)) {
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        }

        if ($post) {
            curl_setopt($ch, CURLOPT_POST, true);
            if (is_array($post)) $post = http_build_query($post);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
        }

        curl_setopt($ch, CURLOPT_HEADER, $header);
        try {
            $output = curl_exec($ch);
            $info = curl_getinfo($ch);
        } catch (Exception $ex) {
            return $ex;
        }
        if ($ch) curl_close($ch);

        if ($info['http_code'] == 301 || $info['http_code'] == 302) {
            $url = $info['redirect_url'];
            $url_parsed = parse_url($url);
            return (isset($url_parsed)) ? $this->get_contents($url, $get, $post, $header, $headers) : '';
        }

        return $output;
    }

    private function log($message)
    {
        if (defined('WP_DEBUG_LOG') && GOLDPRICELIVE_DEBUG)
            $GLOBALS['wp_log']['WC_GoldPriceLive'][] = $message;
    }

}

/**
 * Post API: Walker_Page_Integration class
 */
class Walker_Page_Integration extends Walker
{
    public $tree_type = 'page';
    public $db_fields = array('parent' => 'post_parent', 'id' => 'ID');

    public function start_el(&$output, $page, $depth = 0, $args = array(), $id = 0)
    {

        if ($output == '') $output = array();

        $title = $page->post_title;
        if ('' === $title) {
            $title = sprintf(__('#%d (no title)'), $page->ID);
        }
        $title = apply_filters('list_pages', $title, $page);

        $output[esc_attr($page->{$args['value_field']})] = __($title, $args['integration_key']);
    }
}

$GoldPriceLive = new GoldPriceLive();
register_activation_hook(__DIR__ . '/welcome.php', array($GoldPriceLive, 'gold_price_live_plugin_activate'));