function liveprice_do() {
    var IDs = [];

    var $products = jQuery('.product');

    if($products && $products.length > 0) {
        for(var i = 0; i < $products.length; i++) {
            var $product = $products.eq(i);
            if($product.length > 0) {
                var product_id = parseInt($product.prop("class").match(/post\-([\d]{1,})/)[1]);
                if(!isNaN(product_id)) {
                    IDs.push(product_id);
                }

            }
        }
    }
    if(IDs.length > 0) {

        var data = {
            action: 'liveprice',
            product_id: IDs
        };

        jQuery.get(liveprice_parameters.ajaxurl, data, function(response) {
            try {
                var json = JSON.parse(response);
                if (json && !json.error && json.products.length > 0) {
                    for(var i = 0; i < json.products.length; i++) {
                        var $amount = jQuery('.post-'+json.products[i].product_id+' .woocommerce-Price-amount');
                        if(typeof $amount != 'undefined' && $amount.length > 0) {
                            var old_price = parseFloat(strip($amount.eq(0).html()).replace(/[^\d.-]/g, ''));

                            $amount.eq(0).parent().html(json.products[i].price_formatted);

                            if (!isNaN(old_price)) {
                                $amount = jQuery('.post-'+json.products[i].product_id+' .woocommerce-Price-amount');

                                if (!liveprice_parameters.color_disabled && parseFloat(json.products[i].price) > old_price) {
                                    if (!$amount.eq(0).hasClass('lp_green')) {
                                        $amount.eq(0).addClass('lp_green');
                                    }
                                    if ($amount.eq(0).hasClass('lp_red')) {
                                        $amount.eq(0).removeClass('lp_red');
                                    }
                                } else if (!liveprice_parameters.color_disabled && parseFloat(json.products[i].price) < old_price) {
                                    if (!$amount.eq(0).hasClass('lp_red')) {
                                        $amount.eq(0).addClass('lp_red');
                                    }
                                    if ($amount.eq(0).hasClass('lp_green')) {
                                        $amount.eq(0).removeClass('lp_green');
                                    }
                                } else {
                                    if ($amount.eq(0).hasClass('lp_red')) {
                                        $amount.eq(0).removeClass('lp_red');
                                    }
                                    if ($amount.eq(0).hasClass('lp_green')) {
                                        $amount.eq(0).removeClass('lp_green');
                                    }
                                }
                            }
                        }
                    }
                }
            } catch (e) {
                console.log(e);
            }
        });

    }
}

function strip(html)
{
    var tmp = document.createElement("div");
    tmp.innerHTML = html;
    return tmp.textContent || tmp.innerText || "";
}

jQuery(document).ready(function($){
    liveprice_do();
    setInterval(liveprice_do, 15000);
});