function live_shortcodes_do() {
    var shortcodes = jQuery('.gpl-shortcode');
    var currencies = [];
    jQuery(shortcodes).each(function (i, row) {
        var currency = (jQuery(row)[0].hasAttribute('data-currency')) ? jQuery(row)[0].getAttribute('data-currency') : null;
        if (currency !== null && currencies.indexOf(currency) === -1) {
            currencies.push(currency);
        }
    });
    var data = {
        action: 'live_shortcodes',
        currencies: currencies
    };

    jQuery.get(live_shortcodes_parameters.ajaxurl, data, function (response) {
        var json = JSON.parse(response);
        if (json && !json.error) {
            shortcodes = jQuery('.gpl-shortcode');
            jQuery(shortcodes).each(function (i, row) {
                var metal = (jQuery(row)[0].hasAttribute('data-metal')) ? jQuery(row)[0].getAttribute('data-metal') : null;
                var type = (jQuery(row)[0].hasAttribute('data-type')) ? jQuery(row)[0].getAttribute('data-type') : null;
                var currency = (jQuery(row)[0].hasAttribute('data-currency')) ? jQuery(row)[0].getAttribute('data-currency') : null;
                var unit = (jQuery(row)[0].hasAttribute('data-unit')) ? jQuery(row)[0].getAttribute('data-unit') : null;
                var payout = (jQuery(row)[0].hasAttribute('data-payout')) ? jQuery(row)[0].getAttribute('data-payout') : null;
                var purity = (jQuery(row)[0].hasAttribute('data-purity')) ? jQuery(row)[0].getAttribute('data-purity') : null;
                var weight = (jQuery(row)[0].hasAttribute('data-weight')) ? jQuery(row)[0].getAttribute('data-weight') : null;
                var fixedamount = (jQuery(row)[0].hasAttribute('data-fixedamount')) ? jQuery(row)[0].getAttribute('data-fixedamount') : null;
                var animation = jQuery(row).hasClass('gpl-shortcode-animate');
                var decimalplaces = (jQuery(row)[0].hasAttribute('data-decimalplaces')) ? parseInt(jQuery(row)[0].getAttribute('data-decimalplaces')) : 2;
                var rounding = (jQuery(row)[0].hasAttribute('data-rounding')) ? parseInt(jQuery(row)[0].getAttribute('data-rounding')) : 100;

                if (currency && type && metal) {
                    var price = json[currency][type][metal];
                    if (price) {
                        price = parseFloat(price);

                        if (unit && (unit === 'grams' || unit === 'g')) price = tg(price);
                        if (unit && (unit === 'pennyweight' || unit === 'pw')) price = tp(price);
                        if (payout && payout !== null && payout > 0) price *= parseFloat(payout);
                        if (purity && purity !== null && purity > 0) price *= parseFloat(purity);
                        if (weight && weight !== null && weight > 0) price *= parseFloat(weight);
                        if (fixedamount && fixedamount !== null && fixedamount > 0) price += parseFloat(fixedamount);

                        if (price) {
                            if (type === "change_dollar" || type === "change_percent") {
                                if (price > 0) {
                                    jQuery(row)[0].style = "color: #00FF00 !important;";
                                } else if (price < 0) {
                                    jQuery(row)[0].style = "color: #FF0000 !important;";
                                }
                            }

                            if (animation) {
                                jQuery(row).width(jQuery(row).find('div[style*="display: block"]').width());

                                jQuery(row).find('div[style*="display: none"]').html(rg(price, rounding, decimalplaces));
                            } else {
                                jQuery(row).html(rg(price, rounding, decimalplaces));
                            }
                        }
                    }
                }
            });
        }
    });
}

function live_ex_shortcodes_do() {
    var shortcodes = jQuery('.gpl-exchange-shortcode');
    var currencies = ['usd'];
    jQuery(shortcodes).each(function (i, row) {
        var currency = (jQuery(row)[0].hasAttribute('data-currency')) ? jQuery(row)[0].getAttribute('data-currency') : null;
        if (currency !== null && currencies.indexOf(currency) === -1) {
            currencies.push(currency);
        }
    });
    var data = {
        action: 'live_ex_shortcodes',
        currencies: currencies
    };

    jQuery.get(live_shortcodes_parameters.ajaxurl, data, function (response) {
        var json = JSON.parse(response);
        if (json && !json.error) {
            shortcodes = jQuery('.gpl-exchange-shortcode');
            jQuery(shortcodes).each(function (i, row) {
                var metal = (jQuery(row)[0].hasAttribute('data-metal')) ? jQuery(row)[0].getAttribute('data-metal') : null;
                var type = (jQuery(row)[0].hasAttribute('data-type')) ? jQuery(row)[0].getAttribute('data-type') : null;
                var currency = (jQuery(row)[0].hasAttribute('data-currency')) ? jQuery(row)[0].getAttribute('data-currency') : null;
                var exchange = (jQuery(row)[0].hasAttribute('data-exchange')) ? jQuery(row)[0].getAttribute('data-exchange') : null;
                var fixedcurrency = (jQuery(row)[0].hasAttribute('data-fixedcurrency')) ? jQuery(row)[0].getAttribute('data-fixedcurrency') : null;
                var fixedmarkupdown = (jQuery(row)[0].hasAttribute('data-fixedmarkupdown')) ? parseFloat(jQuery(row)[0].getAttribute('data-fixedmarkupdown')) : null;
                var multiplyby = (jQuery(row)[0].hasAttribute('data-multiplyby')) ? parseFloat(jQuery(row)[0].getAttribute('data-multiplyby')) : null;
                var animation = jQuery(row).hasClass('gpl-shortcode-animate');
                var decimalplaces = (jQuery(row)[0].hasAttribute('data-decimalplaces')) ? parseInt(jQuery(row)[0].getAttribute('data-decimalplaces')) : 2;
                var rounding = (jQuery(row)[0].hasAttribute('data-rounding')) ? parseInt(jQuery(row)[0].getAttribute('data-rounding')) : 100;

                if (currency && type && metal) {
                    var price = json[currency][type][metal];
                    if (price) {
                        price = parseFloat(price);
                        if (currency != exchange) {
                            if (currency == 'usd') {
                                price = price * parseFloat(json[currency + exchange]);
                            } else {
                                if (exchange == 'usd') {
                                    price = price / parseFloat(json[exchange + currency]);
                                } else {
                                    var usd_cr = parseFloat(json["usd" + currency]);
                                    var usd_ex = parseFloat(json["usd" + exchange]);

                                    price = (price / usd_cr) * usd_ex;
                                }
                            }
                        }

                        if (fixedcurrency != exchange) {
                            if (fixedcurrency == 'usd') {
                                fixedmarkupdown = parseFloat(fixedmarkupdown) * parseFloat(json[fixedcurrency + exchange]);
                            } else {
                                if (exchange == 'usd') {
                                    fixedmarkupdown = parseFloat(fixedmarkupdown) / parseFloat(json[exchange + fixedcurrency]);
                                } else {
                                    var fx_usd_cr = parseFloat(json["usd" + fixedcurrency]);
                                    var fx_usd_ex = parseFloat(json["usd" + exchange]);

                                    fixedmarkupdown = (parseFloat(fixedmarkupdown) / fx_usd_cr) * fx_usd_ex;
                                }
                            }
                        }
                        if (fixedmarkupdown) price += fixedmarkupdown;

                        if (!isNaN(multiplyby) && multiplyby > 0 && multiplyby != 1) {
                            price *= multiplyby;
                        }

                        if (price) {
                            if (animation) {
                                jQuery(row).width(jQuery(row).find('div[style*="display: block"]').width());

                                jQuery(row).find('div[style*="display: none"]').html(rg(price, rounding, decimalplaces));
                            } else {
                                jQuery(row).html(rg(price, rounding, decimalplaces));
                            }
                        }
                    }
                }
            });
        }
    });
}

function tg(n) {
    return n / 31.1035;
}

function tp(n) {
    return n / 20;
}

function rg(f, n, d) {
    return (parseFloat((f * n).toFixed(0)) / n).toFixed(d).replace(/(\d)(?=(\d{3})+\.)/g, '$1,');
}

jQuery(document).ready(function ($) {
    var shortcodes = jQuery('.gpl-shortcode');
    if (shortcodes.length > 0) {
        live_shortcodes_do();
        setInterval(live_shortcodes_do, 60000);
    }
    var ex_shortcodes = jQuery('.gpl-exchange-shortcode');
    if (ex_shortcodes.length > 0) {
        live_ex_shortcodes_do();
        setInterval(live_ex_shortcodes_do, 65000);
    }
});