function live_product_shortcodes_do() {
    var shortcodes = jQuery('.gpl-product-shortcode');
    var PIDs = [];
    jQuery(shortcodes).each(function (i, row) {
        var pid = (jQuery(row)[0].hasAttribute('data-pid')) ? jQuery(row)[0].getAttribute('data-pid') : null;
        if (pid !== null && PIDs.indexOf(pid) === -1) {
            PIDs.push(pid);
        }
    });
    var data = {
        action: 'live_product_shortcodes',
        pids: PIDs
    };

    jQuery.get(live_product_shortcodes_parameters.ajaxurl, data, function (response) {
        var json = JSON.parse(response);
        if (json && !json.error) {
            shortcodes = jQuery('.gpl-product-shortcode');
            jQuery(shortcodes).each(function (i, row) {
                var pid = (jQuery(row)[0].hasAttribute('data-pid')) ? jQuery(row)[0].getAttribute('data-pid') : null;
                var percentmarkupdown = (jQuery(row)[0].hasAttribute('data-percentmarkupdown')) ? jQuery(row)[0].getAttribute('data-percentmarkupdown') : null;
                var fixedmarkupdown = (jQuery(row)[0].hasAttribute('data-fixedmarkupdown')) ? jQuery(row)[0].getAttribute('data-fixedmarkupdown') : null;
                var animation = jQuery(row).hasClass('gpl-product-shortcode-animate');
                var decimalplaces = (jQuery(row)[0].hasAttribute('data-decimalplaces')) ? parseInt(jQuery(row)[0].getAttribute('data-decimalplaces')) : 2;
                var rounding = (jQuery(row)[0].hasAttribute('data-rounding')) ? parseInt(jQuery(row)[0].getAttribute('data-rounding')) : 100;

                if (pid && typeof json[pid] !== 'undefined') {
                    var show_price = parseFloat(json[pid]);

                    if (percentmarkupdown && percentmarkupdown > 0 && percentmarkupdown != 1) {
                        show_price *= parseFloat(percentmarkupdown);
                    } else if (fixedmarkupdown && fixedmarkupdown != 0) {
                        show_price += parseFloat(fixedmarkupdown);
                    }

                    if (animation) {
                        jQuery(row).width(jQuery(row).find('span[style*="display: block"]').width());

                        jQuery(row).find('span[style*="display: none"]').html(json.pattern.replace('7.77', rg(show_price, rounding, decimalplaces)));
                    } else {
                        jQuery(row).html(json.pattern.replace('7.77', rg(show_price, rounding, decimalplaces)));
                    }
                }
            });
        }
    });
}

function tg(n) {
    return n / 31.1035;
}
function tp(n) {
    return n / 20;
}
function rg(f, n, d) {
    return (parseFloat((f * n).toFixed(0)) / n).toFixed(d).replace(/(\d)(?=(\d{3})+\.)/g, '$1,');
}

jQuery(document).ready(function ($) {
    var product_shortcodes = jQuery('.gpl-product-shortcode');
    if (product_shortcodes.length > 0) {
        live_product_shortcodes_do();
        setInterval(live_product_shortcodes_do, 60000);
    }
});