var gplc_ps = null;
var gplc_cy = 'usd';
var gplc_lcy = 'usd';
var gplc_pt = {
    'gold' : [999.99, 999.9, 999, 995, 990, 916, 833, 750, 625, 585, 417, 373],
    'silver': [999.9, 999, 958, 950, 925, 900, 830, 800],
    'platinum': [999, 995, 950, 850],
    'palladium': [999, 950, 500]
};

function gplc_prices() {
    jQuery.get(gplc_params.ajaxurl, {
        action: 'gplc',
        currency: gplc_cy
    }, function(response) {
        var json = JSON.parse(response);
        if (json && !json.error) {
            gplc_ps = json[gplc_cy];
            gplc_update();
        }
    });
}

function gplc_update() {
    jQuery.each(jQuery('.gplc_container'), function (i, row) {
        var $header = jQuery(row).find('.gplc_header');
        var $body = jQuery(row).find('.gplc_body');
        var $footer = jQuery(row).find('.gplc_footer');

        var total = 0;

        gplc_cy = $header.find('.gplc_currency').find('select').val();
        if(gplc_lcy != gplc_cy) gplc_ps = null;
        gplc_lcy = gplc_cy;

        $footer.find('.gplc_total_currency').html(gplc_cy.toUpperCase());

        if(!gplc_ps){
            return gplc_prices();
        } else {
            jQuery.each($body.find('tbody').find('tr'), function(i, r){
                var $row = jQuery(r);

                var metal = $row.find('.gplc_metal').val() || 'gold';
                if(!$row.find('.gplc_purity').attr('data-metal') || $row.find('.gplc_purity').attr('data-metal') != metal) {
                    up($row.find('.gplc_purity'), metal);
                }

                $row.find('.gplc_price').html('<input type="hidden" name="gplc_metal_price" value="' + gplc_ps[metal] + '">' + gplc_ps[metal] + " " + gplc_cy.toUpperCase());

                var weight = $row.find('.gplc_weight').val() || 0;
                var unit = $row.find('.gplc_unit').val() || 'g';
                var purity = $row.find('.gplc_purity').val() || 1;

                var price = (tu(unit, parseFloat(gplc_ps[metal])) * parseFloat(weight) * (parseFloat(purity)/parseFloat(gplc_pt[metal][0]))).toFixed(2);
                total += parseFloat(price);

                $row.find('.gplc_value').val(price + " " + gplc_cy.toUpperCase());
            });
        }

        $footer.find('.gplc_total_val').html(total.toFixed(2));
    });

}
function gplc_live_update()
{
    if(jQuery('.gplc_live_container').length > 0) {
        if(gplc_ps != null) {
            gplc_ps = null;
            gplc_update();
        }
    }
}

function up(e,m) {
    var h='';
    jQuery.each(gplc_pt[m], function(i,r){h+='<option value="'+r+'">'+r+'</option>'});
    e.attr('data-metal', m);
    e.html(h);
}

function tu(u, n) { if(u=='g') return n/31.1035; else if(u=='pw') return n/20; else return n; }

function gplc_submit(uuid) {
    var row = jQuery('.gplc_container_'+uuid);
    if(row.length) {
        var rows = [];
        var total = 0;
        var $header = jQuery(row).find('.gplc_header');
        var $body = jQuery(row).find('.gplc_body');
        var $footer = jQuery(row).find('.gplc_footer');

        gplc_cy = $header.find('.gplc_currency').find('select').val();
        if (gplc_lcy != gplc_cy) gplc_ps = null;
        gplc_lcy = gplc_cy;

        $footer.find('.gplc_total_currency').html(gplc_cy.toUpperCase());

        if (!gplc_ps) {
            return gplc_prices();
        } else {
            jQuery.each($body.find('tbody').find('tr'), function (i, r) {
                var $row = jQuery(r);
                var metal = $row.find('.gplc_metal').val() || 'gold';
                var metal_price = $row.find('input[name=gplc_metal_price]').val() || 1;
                var weight = $row.find('.gplc_weight').val() || 0;
                var unit = $row.find('.gplc_unit').val() || 'g';
                var purity = $row.find('.gplc_purity').val() || 999;
                var purity100 = parseFloat(gplc_pt[metal][0]) || 999;

                if(weight > 0) {
                    var price = (tu(unit, parseFloat(gplc_ps[metal])) * parseFloat(weight) * (parseFloat(purity) / parseFloat(gplc_pt[metal][0]))).toFixed(2);
                    total += parseFloat(price);

                    rows.push({
                        'metal': metal,
                        'metal_price': metal_price,
                        'weight': weight,
                        'unit': unit,
                        'purity': purity,
                        'purity100': purity100
                    });
                }
            });
        }

        var name = $footer.find('.gplc_form').find('input[name=name]').val();
        var company = $footer.find('.gplc_form').find('input[name=company]').val();
        var email = $footer.find('.gplc_form').find('input[name=email]').val();
        var phone = $footer.find('.gplc_form').find('input[name=phone]').val();

        if(name.trim().length > 0 && email.trim().length > 0 && validateEmail(email) && phone.trim().length > 0 && rows.length > 0) {

            if(gplc_params.rce && gplc_params.rck.length > 0) {
                var captcha = jQuery('.gplc_container_'+uuid+' *[name=g-recaptcha-response]').val();
                if(captcha.length <= 0) {
                    if (!TomloprodModal.isOpen) {
                        TomloprodModal.openModal("recaptcha-popup",{
                            bgColor: "#FFFFFF",
                            textColor: "#333333"
                        });
                    } else {
                        TomloprodModal.closeModal();
                        grecaptcha.reset();
                        TomloprodModal.create({
                            bgColor: "#FFFFFF",
                            textColor: "#333333",
                            title: "System Message",
                            content: 'You must check captcha before submitting',
                            closeTimer: 3000
                        });
                    }
                } else {
                    TomloprodModal.closeModal();
                    grecaptcha.reset();

                    var form = {
                        'name': name,
                        'company': company,
                        'email': email,
                        'phone': phone,
                        'currency': gplc_cy,
                        'rows': rows,
                        'captcha': captcha
                    };

                    jQuery.post(gplc_params.ajaxurl, {
                        action: 'gplc_data',
                        form: form
                    }, function (raw) {
                        var json = JSON.parse(raw);
                        if(!json || json.error) {
                            TomloprodModal.create({
                                bgColor: "#FFFFFF",
                                textColor: "#333333",
                                title: "System Message",
                                content: json.error,
                                closeTimer: 3000
                            });
                        } else {
                            TomloprodModal.create({
                                bgColor: "#FFFFFF",
                                textColor: "#333333",
                                title: "System Message",
                                content: json.success,
                                closeTimer: 3000
                            });
                        }
                    });
                }
            } else {
                var form = {
                    'name': name,
                    'company': company,
                    'email': email,
                    'phone': phone,
                    'currency': gplc_cy,
                    'rows': rows
                };

                jQuery.post(gplc_params.ajaxurl, {
                    action: 'gplc_data',
                    form: form
                }, function (raw) {
                    var json = JSON.parse(raw);
                    if(!json || json.error) {
                        TomloprodModal.create({
                            bgColor: "#FFFFFF",
                            textColor: "#333333",
                            title: "System Message",
                            content: json.error,
                            closeTimer: 3000
                        });
                    } else {
                        TomloprodModal.create({
                            bgColor: "#FFFFFF",
                            textColor: "#333333",
                            title: "System Message",
                            content: json.success,
                            closeTimer: 3000
                        });
                        location.reload();
                    }
                });
            }
        } else {
            TomloprodModal.create({
                bgColor: "#FFFFFF",
                textColor: "#333333",
                title: "System Message",
                content: 'You must fill with valid data all required fields and at least one row in calculator',
                closeTimer: 3000
            });
        }
    }
}

function validateEmail(email) {
    var re = /^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
    return re.test(email);
}

jQuery(function(){
    TomloprodModal.start({
        closeOnOverlay: true
    });

    jQuery.each(jQuery('.gplc_container'), function (i, row) {
        jQuery.each(jQuery(row).find('.gplc_body').find('tbody').find('tr'), function(i, r) {
            var metal = jQuery(r).find('.gplc_metal').val() || 'gold';
            up(jQuery(r).find('.gplc_purity'), metal);
        });
    });

    gplc_update();
    if(jQuery('.gplc_live_container').length > 0) {
        setInterval(gplc_live_update, 60000);
    }
});