<?php


defined( 'ABSPATH' ) || exit();



class Af_Pgbf_Front {

	public function __construct() {
		add_action( 'wp_enqueue_scripts', array( $this, 'afpgbf_front_scripts' ) );
		add_action( 'woocommerce_cart_calculate_fees', array( $this, 'custom_fee_based_on_cart_total' ), 10, 1 );
	}

	public function afpgbf_front_scripts() {
		wp_enqueue_script( 'afpgbf_front_js', AFPGBF_DIR_URL . 'assets/js/front.js', array( 'jquery' ), '1.0.0', true );
	}

	public function custom_fee_based_on_cart_total( $cart ) {

		if ( wc()->cart->is_empty() ) {
			return;
		}

		$posts = get_posts(
			array(
				'post_type'   => 'afpgbf_rules',
				'post_status' => 'publish',
				'numberposts' => -1,
				'fields'      => 'ids',
				'order_by'    => 'menu_order',
			)
		);

		$current_user   = is_user_logged_in() ? current( wp_get_current_user()->roles ) : 'guest';
		$location       = WC_Geolocation::geolocate_ip();
		$country[]      = $location['country'];
		$cart_total     = $cart->get_subtotal();
		$chosen_gateway = WC()->session->get( 'chosen_payment_method' );

		foreach ( $posts as $key => $rule_id ) {
			$payment_methods               = (array) get_post_meta( $rule_id, 'afpgbf_payment_method', true );
			$payment_methods               = array_filter( $payment_methods );
			$tax_class                     = get_post_meta( $rule_id, 'afpgbf_tax_classes', true );
			$user_roles                    = (array) get_post_meta( $rule_id, 'afpgbf_user_roles', true );
			$user_roles                    = array_filter( $user_roles );
			$incl_excl_countries_radio_btn = get_post_meta( $rule_id, 'incl_excl_countries_radio_btn', true );
			$min_cart_amount               = get_post_meta( $rule_id, 'min_cart_amount', true );
			$max_cart_amount               = get_post_meta( $rule_id, 'max_cart_amount', true );
			$countries                     = (array) get_post_meta( $rule_id, 'include_exclude_countries', true );
			$countries                     = array_filter( $countries );
			$taxable                       = get_post_meta( $rule_id, 'afpgbf_taxable', true );
			$fee_discount                  = get_post_meta( $rule_id, 'afpgbf_fee_discount', true );
			$fixed_percentage              = get_post_meta( $rule_id, 'afpgbf_fixed_percentage', true );
			$fee_discount_value            = get_post_meta( $rule_id, 'afpgbf_fee_discount_value', true );
			$checkout_label                = get_post_meta( $rule_id, 'afpgbf_checkout_title', true );
			$min_amt_for_percent           = get_post_meta( $rule_id, 'afpgbf_min_fee', true );
			$max_amt_for_percent           = get_post_meta( $rule_id, 'afpgbf_max_fee', true );

			if ( empty( $fee_discount_value ) || 0 == $fee_discount_value ) {
				continue;
			}

			if ( count( $user_roles ) >= 1 && ! in_array( $current_user, $user_roles ) ) {
				continue;
			}

			if ( 'include' == $incl_excl_countries_radio_btn ) {
				if ( count( $countries ) >= 1 && ! array_intersect( $countries, $country ) ) {
					continue;
				}
			}

			if ( 'exclude' == $incl_excl_countries_radio_btn ) {
				if ( count( $countries ) >= 1 && array_intersect( $countries, $country ) ) {
					continue;
				}
			}

			if ( ! empty( $min_cart_amount ) && ! empty( $max_cart_amount ) ) {
				if ( $cart_total < $min_cart_amount || $cart_total > $max_cart_amount ) {
					continue;
				}
			} elseif ( ! empty( $min_cart_amount ) ) {
				if ( $cart_total < $min_cart_amount ) {
					continue;
				}
			} elseif ( ! empty( $max_cart_amount ) ) {
				if ( $cart_total > $max_cart_amount ) {
					continue;
				}
			}

			$gateway1 = count( $payment_methods ) >= 1 ? $payment_methods : array( $chosen_gateway );

			if ( in_array( $chosen_gateway, $gateway1 ) ) {

				$this->afpgbf_calculations( $fixed_percentage, $fee_discount_value, $min_amt_for_percent, $max_amt_for_percent, $fee_discount, $taxable, $checkout_label, $cart, $tax_class );

				break;

			}
		}
	}


	public function afpgbf_calculations( $fixed_percentage, $fee_discount_value, $min_amt_for_percent, $max_amt_for_percent, $fee_discount, $taxable, $checkout_label, $cart, $tax_class ) {

		// if no nimum fee/discount value empty fee/Discount value apply

		if ( 'percentage' == $fixed_percentage ) {
			$percent_value = ( $fee_discount_value / 100 ) * $cart->get_subtotal();
			if ( $percent_value <= $min_amt_for_percent ) {
				$amount = $min_amt_for_percent;
			} elseif ( $percent_value >= $max_amt_for_percent ) {
				$amount = $max_amt_for_percent;
			} else {
				$amount = $percent_value;
			}
		}

		$amount      = 'fixed' == $fixed_percentage ? $fee_discount_value : $amount;
		$total_amont = 'fee' == $fee_discount ? $amount : $amount * -1;

		$is_taxable = 'true' == $taxable ? true : false;

		wc()->cart->add_fee( $checkout_label, $total_amont, $is_taxable, $tax_class );
	}
}

new Af_Pgbf_Front();
