<?php


defined( 'ABSPATH' ) || exit;



class Af_PGBF_Admin {

	public function __construct() {
		// meta boxes
		add_action( 'admin_init', array( $this, 'afpgbf_custom_meta_boxes' ), 10 );
		add_action( 'save_post_afpgbf_rules', array( $this, 'afpgbf_mata_box_save' ), 10, 1 );
		add_action( 'admin_enqueue_scripts', array( $this, 'afpgbf_admin_scripts' ) );
		add_filter( 'manage_afpgbf_rules_posts_columns', array( $this, 'afpgbf_columns' ) );
		add_action( 'manage_afpgbf_rules_posts_custom_column', array( $this, 'afpgbf_custom_column' ), 10, 2 );
	}

	public function afpgbf_admin_scripts() {
		wp_enqueue_style( 'afpgbf_admin_css', AFPGBF_DIR_URL . 'assets/css/admin.css', false, '1.0.0' );
		wp_enqueue_script( 'afpgbf_admin_js', AFPGBF_DIR_URL . 'assets/js/admin.js', array( 'jquery' ), '1.0.0', true );
		wp_enqueue_script( 'afpgbf_select2js', AFPGBF_DIR_URL . 'assets/js/select2.js', array( 'jquery' ), '1.0.0', true );
		wp_enqueue_style( 'afpgbf_select2', AFPGBF_DIR_URL . 'assets/css/select2.css', false, '1.0.0' );
	}

	public function afpgbf_columns( $columns ) {

		$columns['priority'] = esc_html__( 'Priority', 'Addify_pgbf' );
		$columns['status']   = esc_html__( 'Status', 'Addify_pgbf' );
		return $columns;
	}

	public function afpgbf_custom_column( $columns, $post_id ) {

		$post = get_post( $post_id );

		switch ( $columns ) {
			case 'priority':
				echo esc_attr( $post->menu_order );
				break;

			case 'status':
				if ( 'publish' == $post->post_status ) {
					echo esc_html__( 'Active', 'Addify_pgbf' );
				} else {
					echo esc_html__( 'In Active', 'Addify_pgbf' );
				}
				break;

			default:
				// code...
				break;
		}
	}

	public function afpgbf_custom_meta_boxes() {

		add_meta_box(
			'pgbf_fees', // id
			esc_html__( 'Fee/Discount Settings', 'Addify_pgbf' ),
			array( $this, 'afpgbf_fees_discount_callback' ),
			'afpgbf_rules',
			'normal',
			'high'
		);

		add_meta_box(
			'pgbf_user_roles', // id
			esc_html__( 'General Options', 'Addify_pgbf' ),
			array( $this, 'afpgbf_user_roles_callback' ),
			'afpgbf_rules',
			'normal',
			'default'
		);

		add_meta_box(
			'pgbf_restriction', // id
			esc_html__( 'Restrictions', 'Addify_pgbf' ),
			array( $this, 'afpgbf_restrictions_callback' ),
			'afpgbf_rules',
			'normal',
			'default'
		);
	}

	public function afpgbf_fees_discount_callback() {

		global $post;
		wp_nonce_field( 'afpgbf_nonce_action', 'afpgbf_nonce_field' );
		$fee_discount           = get_post_meta( $post->ID, 'afpgbf_fee_discount', true );
		$fixed_percentage       = get_post_meta( $post->ID, 'afpgbf_fixed_percentage', true );
		$checkout_title         = get_post_meta( $post->ID, 'afpgbf_checkout_title', true );
		$fee_and_discount_value = get_post_meta( $post->ID, 'afpgbf_fee_discount_value', true );
		$min_amt_for_percent    = get_post_meta( $post->ID, 'afpgbf_min_fee', true );
		$max_amt_for_percent    = get_post_meta( $post->ID, 'afpgbf_max_fee', true );

		?>
		<table class="afpgbf_table afpgbf_table_fee_or_discount">
			<tbody class="afpgbf_tbody">

				<tr>
					<th>
						<label><?php echo esc_html__( 'Select Fee/Discount', 'Addify_pgbf' ); ?></label>
					</th>
					<td>
						<select class='afpgbf_fee_discount' name="afpgbf_fee_discount">
							<option value="fee"
							<?php echo selected( 'fee', $fee_discount ); ?>
							><?php echo esc_html__( 'Fee', 'Addify_pgbf' ); ?></option>
							<option value="discount"
							<?php echo selected( 'discount', $fee_discount ); ?>								
							><?php echo esc_html__( 'Discount', 'Addify_pgbf' ); ?></option>
						</select>
						<p><?php echo esc_html__( 'Choose the option to add Fee/Discount on the value of the entire cart.', 'Addify_pgbf' ); ?></p>						
					</td>
				</tr>				

				<tr>
					<th>
						<label class="fee_discount_label"><?php echo esc_html__( 'Fee/Discount title', 'Addify_pgbf' ); ?></label>
					</th>
					<td>
						<input type="text" name="afpgbf_checkout_title" required value="<?php echo esc_attr( $checkout_title ); ?>" >
						<p class="fee_discount_label" ><?php echo esc_html__( 'Add custom title here, this will appear on checkout page as line item to explain why this additional fee has been added.', 'Addify_pgbf' ); ?></p>
					</td>
				</tr>

				<tr>
					<th>
						<label class="fee_discount_label"><?php echo esc_html__( 'Fee/Discount type', 'Addify_pgbf' ); ?></label>
					</th>
					<td>
						<select name="afpgbf_fixed_percentage" class="afpgbf_fixed_percentage">
							<option value="fixed"
							<?php echo selected( $fixed_percentage, 'fixed' ); ?> 	
							><?php echo esc_html__( 'Fixed', 'Addify_pgbf' ); ?></option>
							<option value="percentage"
							<?php echo selected( $fixed_percentage, 'percentage' ); ?> 	
							><?php echo esc_html__( 'Percentage', 'Addify_pgbf' ); ?></option>
						</select>
					</td>
				</tr>	

				<tr>
					<th>
						<label class="fee_discount_label"><?php echo esc_html__( 'Fee/Discount value', 'Addify_pgbf' ); ?></label>
					</th>
					<td>
						<input type="number" required name="afpgbf_fee_discount_value" min="0.1" step="any" value="<?php echo esc_attr( $fee_and_discount_value ); ?>">
					</td>
				</tr>

				<tr class="min_max_amount">
					<th>
						<label class="fee_discount_label"><?php echo esc_html__( 'Minimum Fee/Discount value', 'Addify_pgbf' ); ?></label>
					</th>
					<td>
						<input type="number" class="afpgbf_required" name="afpgbf_min_fee" value="<?php echo esc_attr( $min_amt_for_percent ); ?>" min="0">	
						<p><?php echo esc_html__( 'Minimum fee(or discount) value.', 'Addify_pgbf' ); ?></p>
					</td>
				</tr>

				<tr class="min_max_amount">
					<th>
						<label class="fee_discount_label"><?php echo esc_html__( 'Maximum Fee/Discount value', 'Addify_pgbf' ); ?></label>							
					</th>
					<td>
						<input type="number" class="afpgbf_required" name="afpgbf_max_fee" value="<?php echo esc_attr( $max_amt_for_percent ); ?>" min="0">	
						<p><?php echo esc_html__( 'Maximum fee(or discount) value.', 'Addify_pgbf' ); ?></p>					
					</td>
				</tr>											

			</tbody>
		</table>	

		<?php
	}

	public function afpgbf_user_roles_callback() {

		global $post;
		wp_nonce_field( 'afpgbf_nonce_action', 'afpgbf_nonce_field' );
		$methods   = (array) get_post_meta( $post->ID, 'afpgbf_payment_method', true );
		$tax_class = get_post_meta( $post->ID, 'afpgbf_tax_classes', true );
		$taxable   = get_post_meta( $post->ID, 'afpgbf_taxable', true );
		$gateways  = WC()->payment_gateways->payment_gateways();
		$wc_tax    = (array) WC_Tax::get_tax_rate_classes();
		?>

		<table class="afpgbf_table">
			<tbody class="afpgbf_tbody">

				<tr>
					<th>
						<label><?php echo esc_html__( 'Payment methods', 'Addify_pgbf' ); ?></label>
					</th>
					<td>
						<select name="afpgbf_payment_methods[]" class="afpgbf_payment_methods" multiple>
							<?php foreach ( $gateways as $gateway_key => $obj ) : ?>
								<option value="<?php echo esc_attr( $gateway_key ); ?>"
									<?php if ( in_array( $gateway_key, $methods ) ) : ?>
										selected
									<?php endif ?>
									> <?php echo esc_attr( $obj->title ); ?> </option>
							<?php endforeach ?>
						</select>
						<p><?php echo esc_html__( 'Select payment gateways to apply this rule to.', 'Addify_pgbf' ); ?></p>
					</td>
				</tr>

				<tr>
					<th>
						<label><?php echo esc_html__( 'Taxes', 'Addify_pgbf' ); ?></label>
					</th>
					<td>
						<input type="checkbox" name="afpgbf_taxable" value="true"
						<?php echo checked( esc_attr( $taxable ), 'true' ); ?> 
						class="afpgbf_checkbox"> <span> <?php echo esc_html__( 'Enable', 'Addify_pgbf' ); ?></span>
						<p><?php echo esc_html__( 'Is taxable?', 'Addify_pgbf' ); ?></p>
					</td>
				</tr>						

				<tr class="tax_class_hide_show">
					<th>
						<label><?php echo esc_html__( 'Tax class', 'Addify_pgbf' ); ?></label>
					</th>
					<td>
						<select name="afpgbf_tax_classes">
							<?php foreach ( $wc_tax as $key => $value ) : ?>
								<option value=" <?php echo esc_attr( $value->slug ); ?>"
									<?php echo selected( $value->slug, $tax_class ); ?>
									> <?php echo esc_attr( $value->name ); ?> </option>
							<?php endforeach ?>
						</select>
					</td>
				</tr>		

			</tbody>
		</table>		
		<?php
	}


	public function afpgbf_restrictions_callback() {

		global $post, $wp_roles;
		wp_nonce_field( 'afpgbf_nonce_action', 'afpgbf_nonce_field' );
		$user_roles                    = (array) get_post_meta( $post->ID, 'afpgbf_user_roles', true );
		$countries                     = (array) get_post_meta( $post->ID, 'include_exclude_countries', true );
		$incl_excl_countries_radio_btn = get_post_meta( $post->ID, 'incl_excl_countries_radio_btn', true );
		$min_cart_amount               = get_post_meta( $post->ID, 'min_cart_amount', true );
		$max_cart_amount               = get_post_meta( $post->ID, 'max_cart_amount', true );
		?>

		<table class="afpgbf_table">
			<tbody class="afpgbf_tbody">

				<tr>
					<th>
						<label><?php echo esc_html__( 'Users roles', 'Addify_pgbf' ); ?></label>
					</th>
					<td>
						<?php
						$user_roles_ob  = new WP_Roles();
						$names          = $user_roles_ob->get_names();
						$names['guest'] = 'Guest';
						?>
						<select class="afpgbf_user_roles" name="afpgbf_user_roles[]" multiple>
							<?php foreach ( $names as $key => $value ) : ?>
								<option value="<?php echo esc_attr( $key ); ?>"
									<?php if ( in_array( $key, $user_roles ) ) : ?>
										selected
									<?php endif ?>
									><?php echo esc_attr( $value ); ?>		
								</option>
							<?php endforeach ?>
						</select>
						<p><?php echo esc_html__( 'Apply this rule to specific user roles. Leave empty to enable it for everyone.', 'Addify_pgbf' ); ?></p>
					</td>
				</tr>

				<tr>
					<th>
						<label><?php echo esc_html__( 'Apply by countries', 'Addify_pgbf' ); ?></label>
					</th>
					<td>
						<label><?php echo esc_html__( 'Include', 'Addify_pgbf' ); ?></label>
						<input type="radio" name="incl_excl_countries_radio_btn" value="include"
						<?php echo esc_attr( 'exclude' != $incl_excl_countries_radio_btn ) ? 'checked' : ''; ?>
						>
						<label><?php echo esc_html__( 'Exclude', 'Addify_pgbf' ); ?></label>
						<input type="radio" name="incl_excl_countries_radio_btn" value="exclude"
						<?php echo checked( 'exclude', $incl_excl_countries_radio_btn ); ?>
						>
						<p><?php echo esc_html__( 'Restrict this rule by countries. Leave empty to apply enable it for all countries.', 'Addify_pgbf' ); ?></p>
					</td>
				</tr>							

				<tr>
					<th>
					</th>
					<td>
						<?php
						$wc_countries = new WC_Countries();
						$nations      = $wc_countries->get_countries();
						?>
						<select name="include_exclude_countries[]" class="afpgbf_include_countries" multiple>
							<?php foreach ( $nations as $key => $state ) : ?>
								<option value="<?php echo esc_attr( $key ); ?>"
									<?php if ( in_array( esc_attr( $key ), $countries ) ) : ?>
										selected	
									<?php endif ?>
									><?php echo esc_attr( $state ); ?>				
								</option>
							<?php endforeach; ?>
						</select>
						<p><?php echo esc_html__( 'Countries to include and exclude.', 'Addify_pgbf' ); ?></p>
					</td>
				</tr>	

				<tr>
					<th>
						<label><?php echo esc_html__( 'Cart amount restriction:', 'Addify_pgbf' ); ?></label>
					</th>
					<td>
						<input type="number" name="min_cart_amount" value="<?php echo esc_attr( $min_cart_amount ); ?>" min='0'; >
						<p><?php echo esc_html__( 'Minimum cart amount for adding fee/discount.', 'Addify_pgbf' ); ?></p>
					</td>
				</tr>

				<tr>
					<th>
					</th>
					<td>
						<input type="number" name="max_cart_amount" value="<?php echo esc_attr( $max_cart_amount ); ?>" min='0'; >
						<p><?php echo esc_html__( 'Maximum cart amount for adding fee/discount.', 'Addify_pgbf' ); ?></p>
					</td>
				</tr>																						

			</tbody>
		</table>
		<?php
	}

	public function afpgbf_mata_box_save( $post_id ) {

		// Check if the current user can edit the post with a specific post ID:

		if ( ! current_user_can( 'edit_post', $post_id ) ) {
			return;
		}

		$exclude_status = array(
			'auto-draft',
			'trash',
		);

		$bulk_actions = isset( $_GET['action'] ) ? sanitize_text_field( wp_unslash( $_GET['action'] ) ) : '';

		if ( ! in_array( get_post_status( $post_id ), $exclude_status ) && ! is_ajax() && 'untrash' != $bulk_actions ) {

			$nonce = isset( $_POST['afpgbf_nonce_field'] ) ? sanitize_text_field( wp_unslash( $_POST['afpgbf_nonce_field'] ) ) : 0;

			if ( ! wp_verify_nonce( $nonce, 'afpgbf_nonce_action' ) ) {
				die( esc_html__( 'Failed security check', 'Addify_pgbf' ) );
			}

			if ( isset( $_POST['afpgbf_payment_methods'] ) ) {
				update_post_meta( $post_id, 'afpgbf_payment_method', sanitize_meta( '', wp_unslash( $_POST['afpgbf_payment_methods'] ), '' ) );
			} else {
				update_post_meta( $post_id, 'afpgbf_payment_method', array() );
			}

			if ( isset( $_POST['afpgbf_tax_classes'] ) ) {
				update_post_meta( $post_id, 'afpgbf_tax_classes', sanitize_text_field( wp_unslash( $_POST['afpgbf_tax_classes'] ) ) );
			}

			if ( isset( $_POST['afpgbf_taxable'] ) ) {
				update_post_meta( $post_id, 'afpgbf_taxable', sanitize_text_field( wp_unslash( $_POST['afpgbf_taxable'] ) ) );
			} else {
				update_post_meta( $post_id, 'afpgbf_taxable', '' );
			}

			if ( isset( $_POST['afpgbf_fee_discount'] ) ) {
				update_post_meta( $post_id, 'afpgbf_fee_discount', sanitize_text_field( wp_unslash( $_POST['afpgbf_fee_discount'] ) ) );
			}

			if ( isset( $_POST['afpgbf_fixed_percentage'] ) ) {
				update_post_meta( $post_id, 'afpgbf_fixed_percentage', sanitize_text_field( wp_unslash( $_POST['afpgbf_fixed_percentage'] ) ) );
			}

			if ( isset( $_POST['afpgbf_checkout_title'] ) ) {
				update_post_meta( $post_id, 'afpgbf_checkout_title', sanitize_text_field( wp_unslash( $_POST['afpgbf_checkout_title'] ) ) );
			}

			if ( isset( $_POST['afpgbf_fee_discount_value'] ) ) {
				update_post_meta( $post_id, 'afpgbf_fee_discount_value', sanitize_text_field( wp_unslash( $_POST['afpgbf_fee_discount_value'] ) ) );
			}

			if ( isset( $_POST['afpgbf_min_fee'] ) ) {
				update_post_meta( $post_id, 'afpgbf_min_fee', sanitize_text_field( wp_unslash( $_POST['afpgbf_min_fee'] ) ) );
			}

			if ( isset( $_POST['afpgbf_max_fee'] ) ) {
				update_post_meta( $post_id, 'afpgbf_max_fee', sanitize_text_field( wp_unslash( $_POST['afpgbf_max_fee'] ) ) );
			}

			if ( isset( $_POST['afpgbf_user_roles'] ) ) {
				update_post_meta( $post_id, 'afpgbf_user_roles', sanitize_meta( '', wp_unslash( $_POST['afpgbf_user_roles'] ), '' ) );
			} else {
				update_post_meta( $post_id, 'afpgbf_user_roles', '' );
			}

			update_post_meta( $post_id, 'include_exclude_countries', '' );
			if ( isset( $_POST['include_exclude_countries'] ) ) {
				update_post_meta( $post_id, 'include_exclude_countries', sanitize_meta( '', wp_unslash( $_POST['include_exclude_countries'] ), '' ) );
			}

			update_post_meta( $post_id, 'min_cart_amount', 0 );
			if ( ! empty( $_POST['min_cart_amount'] ) ) {
				update_post_meta( $post_id, 'min_cart_amount', sanitize_text_field( wp_unslash( $_POST['min_cart_amount'] ) ) );
			}

			update_post_meta( $post_id, 'max_cart_amount', 0 );
			if ( ! empty( $_POST['max_cart_amount'] ) ) {
				update_post_meta( $post_id, 'max_cart_amount', sanitize_text_field( wp_unslash( $_POST['max_cart_amount'] ) ) );
			}

			if ( isset( $_POST['incl_excl_countries_radio_btn'] ) ) {
				update_post_meta( $post_id, 'incl_excl_countries_radio_btn', sanitize_text_field( wp_unslash( $_POST['incl_excl_countries_radio_btn'] ) ) );
			} else {
				update_post_meta( $post_id, 'incl_excl_countries_radio_btn', 'Include' );
			}
		}
	}
}

new Af_PGBF_Admin();
