<?php
// Load WordPress environment
require_once('wp-load.php');

// Set filename for CSV export
$filename = "woocommerce-products-export.csv";

// Open file for writing
$handle = fopen($filename, 'w');

// Fetch all unique meta keys from wp_postmeta for products
global $wpdb;
$meta_keys = $wpdb->get_col("
    SELECT DISTINCT meta_key 
    FROM {$wpdb->postmeta} 
    WHERE post_id IN (SELECT ID FROM {$wpdb->posts} WHERE post_type = 'product')
");

// Set column headers (Product ID, Name, and all meta keys)
$headers = array_merge(['Product ID', 'Product Name'], $meta_keys);
fputcsv($handle, $headers);

// Fetch WooCommerce products
$products = $wpdb->get_results("
    SELECT ID, post_title 
    FROM {$wpdb->posts} 
    WHERE post_type = 'product'
");

foreach ($products as $product) {
    $product_id = $product->ID;
    $product_name = $product->post_title;

    // Get all meta values for this product
    $meta_values = [];
    foreach ($meta_keys as $meta_key) {
        $meta_values[] = get_post_meta($product_id, $meta_key, true);
    }

    // Write row to CSV
    fputcsv($handle, array_merge([$product_id, $product_name], $meta_values));
}

// Close file
fclose($handle);

// Set headers to force download
header("Content-Description: File Transfer");
header("Content-Disposition: attachment; filename=$filename");
header("Content-Type: application/csv; ");
readfile($filename);
unlink($filename);
exit;
?>
